/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.filter.ProcessingFilter;

public abstract class BasicFilter
implements ProcessingFilter {
    private final String name_;
    private final String usage_;

    protected BasicFilter(String name, String usage) {
        this.name_ = name;
        this.usage_ = usage;
    }

    public String getName() {
        return this.name_;
    }

    public String getUsage() {
        return this.usage_;
    }

    public String getDescription() {
        return DocUtils.join(this.getDescriptionLines());
    }

    protected abstract String[] getDescriptionLines();

    /*
     * WARNING - void declaration
     */
    public static String explainSyntax(String[] usages) {
        int nUsage = usages.length;
        if (nUsage == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer().append("<p>").append("Syntax for the ");
        String[] refids = new String[nUsage];
        for (int i = 0; i < nUsage; ++i) {
            void var6_6;
            String refid;
            String usage;
            if (i > 0) {
                sbuf.append(i == nUsage - 1 ? " and " : ", ");
            }
            if ((usage = usages[i]).startsWith("expr") || usage.startsWith("key-list")) {
                refid = "jel";
            } else if (usage.startsWith("col-id")) {
                refid = "col-id";
            } else if (usage.startsWith("colid-list")) {
                refid = "colid-list";
            } else {
                throw new IllegalArgumentException("Unknown usage type " + usage);
            }
            refids[i] = var6_6;
            if (nUsage > 1) {
                sbuf.append("<ref id=\"").append((String)var6_6).append("\">");
            }
            sbuf.append("<code>").append("&lt;").append(usage).append("&gt;").append("</code>");
            if (nUsage > 1) {
                sbuf.append("</ref>");
            }
            sbuf.append(" ");
        }
        if (nUsage == 1) {
            sbuf.append("argument").append(" is described in ").append("<ref id=\"").append(refids[0]).append("\"/>");
        } else {
            sbuf.append("arguments").append(" is described in ").append("the manual");
        }
        sbuf.append(".\n").append("</p>\n");
        return sbuf.toString();
    }
}

