/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class UniqueFilter
extends BasicFilter {
    private static final ValueInfo COUNT_INFO = new DefaultValueInfo("DupCount", Integer.class, "Number of duplicate rows");

    public UniqueFilter() {
        super("uniq", "[-count] [<colid-list>]");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"<p>Eliminates adjacent rows which have the same values.", "If used with no arguments, then any row which has identical", "values to its predecessor is removed.", "</p>", "<p>If the <code>&lt;colid-list&gt;</code> parameter is given", "then only the values in the specified columns must be equal", "in order for the row to be removed.", "</p>", "<p>If the <code>-count</code> flag is given, then an additional", "column with the name " + COUNT_INFO.getName() + " will be", "prepended to the table giving a count of the number of duplicated", "input rows represented by each output row.  A unique row", "has a " + COUNT_INFO.getName() + " value of 1.", "</p>", UniqueFilter.explainSyntax(new String[]{"colid-list"})};
    }

    public ProcessingStep createStep(Iterator argIt) {
        String testIds = null;
        boolean count = false;
        while (argIt.hasNext() && testIds == null) {
            String arg = (String)argIt.next();
            if (arg.equals("-count")) {
                argIt.remove();
                count = true;
                continue;
            }
            argIt.remove();
            testIds = arg;
        }
        final String tids = testIds;
        final boolean doCount = count;
        return new ProcessingStep(){

            public StarTable wrap(StarTable base) throws IOException {
                return new UniqueTable(base, tids, doCount);
            }
        };
    }

    private static final boolean equalValues(Object o1, Object o2) {
        return Tables.isBlank((Object)o1) && Tables.isBlank((Object)o2) || o1 != null && o1.equals(o2);
    }

    static /* synthetic */ boolean access$100(Object x0, Object x1) {
        return UniqueFilter.equalValues(x0, x1);
    }

    private static class UniqueTable
    extends WrapperStarTable {
        final boolean[] testFlags_;
        final boolean doCount_;

        UniqueTable(StarTable base, String testIds, boolean doCount) throws IOException {
            super(base);
            if (testIds == null) {
                this.testFlags_ = new boolean[base.getColumnCount()];
                Arrays.fill(this.testFlags_, true);
            } else {
                this.testFlags_ = new ColumnIdentifier(base).getColumnFlags(testIds);
            }
            this.doCount_ = doCount;
        }

        public boolean isRandom() {
            return false;
        }

        public int getColumnCount() {
            return super.getColumnCount() + (this.doCount_ ? 1 : 0);
        }

        public ColumnInfo getColumnInfo(int icol) {
            return icol == 0 && this.doCount_ ? new ColumnInfo(COUNT_INFO) : super.getColumnInfo(icol - (this.doCount_ ? 1 : 0));
        }

        public long getRowCount() {
            return -1L;
        }

        public RowSequence getRowSequence() throws IOException {
            RowSequence rseq = super.getRowSequence();
            int ncol = super.getColumnCount();
            return new RowSequence(this, rseq, ncol){
                Object[] lastRow_;
                Object[] nextRow_;
                private final /* synthetic */ RowSequence val$rseq;
                private final /* synthetic */ int val$ncol;
                private final /* synthetic */ UniqueTable this$0;
                {
                    this.this$0 = this$0;
                    this.val$rseq = val$rseq;
                    this.val$ncol = val$ncol;
                    if (this.val$rseq.next()) {
                        this.nextRow_ = (Object[])this.val$rseq.getRow().clone();
                    }
                }

                public boolean next() throws IOException {
                    if (this.nextRow_ == null) {
                        return false;
                    }
                    int dupCount = 1;
                    boolean same = true;
                    Object[] row = null;
                    while (same && this.val$rseq.next()) {
                        row = this.val$rseq.getRow();
                        for (int icol = 0; same && icol < this.val$ncol; ++icol) {
                            same = same && (!this.this$0.testFlags_[icol] || UniqueFilter.access$100(row[icol], this.nextRow_[icol]));
                        }
                        if (!same) continue;
                        ++dupCount;
                    }
                    this.lastRow_ = new Object[this.val$ncol + (this.this$0.doCount_ ? 1 : 0)];
                    System.arraycopy(this.nextRow_, 0, this.lastRow_, this.this$0.doCount_ ? 1 : 0, this.val$ncol);
                    if (this.this$0.doCount_) {
                        this.lastRow_[0] = new Integer(dupCount);
                    }
                    this.nextRow_ = same ? null : (Object[])row.clone();
                    return true;
                }

                public Object[] getRow() {
                    if (this.lastRow_ != null) {
                        return this.lastRow_;
                    }
                    throw new IllegalStateException();
                }

                public Object getCell(int icol) {
                    if (this.lastRow_ != null) {
                        return this.lastRow_[icol];
                    }
                    throw new IllegalStateException();
                }

                public void close() throws IOException {
                    this.val$rseq.close();
                }
            };
        }
    }
}

