/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public class HumanMatchEngine
implements MatchEngine {
    private final MatchEngine baseEngine_;
    private final ValueInfo[] tupleInfos_;
    private final DescribedValue[] matchParams_;
    private final ValueWrapper[] tupleWrappers_;
    private final ValueWrapper scoreWrapper_;
    private final ValueInfo scoreInfo_;
    private final int nval_;
    private static ValueWrapper NULL_WRAPPER = new ValueWrapper(){

        public Object wrapValue(Object value) {
            return value;
        }

        public Object unwrapValue(Object value) {
            return value;
        }

        public double wrapDouble(double value) {
            return value;
        }

        public ValueInfo wrapValueInfo(ValueInfo info) {
            return info;
        }

        public DescribedValue wrapDescribedValue(DescribedValue dval) {
            return dval;
        }
    };

    public HumanMatchEngine(MatchEngine baseEngine) {
        this.baseEngine_ = baseEngine;
        ValueInfo[] tinfos = baseEngine.getTupleInfos();
        this.nval_ = tinfos.length;
        this.tupleWrappers_ = new ValueWrapper[this.nval_];
        this.tupleInfos_ = new ValueInfo[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            this.tupleWrappers_[i] = HumanMatchEngine.createWrapper(tinfos[i]);
            this.tupleInfos_[i] = this.tupleWrappers_[i].wrapValueInfo(tinfos[i]);
        }
        DescribedValue[] params = baseEngine.getMatchParameters();
        this.matchParams_ = new DescribedValue[params.length];
        for (int i = 0; i < params.length; ++i) {
            DescribedValue param = params[i];
            this.matchParams_[i] = HumanMatchEngine.createWrapper(param.getInfo()).wrapDescribedValue(param);
        }
        ValueInfo minfo = baseEngine.getMatchScoreInfo();
        if (minfo != null) {
            this.scoreWrapper_ = HumanMatchEngine.createWrapper(minfo);
            this.scoreInfo_ = this.scoreWrapper_.wrapValueInfo(minfo);
        } else {
            this.scoreWrapper_ = NULL_WRAPPER;
            this.scoreInfo_ = null;
        }
    }

    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    public ValueInfo[] getTupleInfos() {
        return this.tupleInfos_;
    }

    public Object[] getBins(Object[] tuple) {
        return this.baseEngine_.getBins(this.unwrapTuple(tuple));
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        return this.scoreWrapper_.wrapDouble(this.baseEngine_.matchScore(this.unwrapTuple(tuple1), this.unwrapTuple(tuple2)));
    }

    public ValueInfo getMatchScoreInfo() {
        return this.scoreInfo_;
    }

    public boolean canBoundMatch() {
        return this.baseEngine_.canBoundMatch();
    }

    public Comparable[][] getMatchBounds(Comparable[] minTuple, Comparable[] maxTuple) {
        Comparable[][] unwrappedResult = this.baseEngine_.getMatchBounds(this.toComparables(this.unwrapTuple(minTuple)), this.toComparables(this.unwrapTuple(maxTuple)));
        return new Comparable[][]{this.toComparables(this.wrapTuple(unwrappedResult[0])), this.toComparables(this.wrapTuple(unwrappedResult[1]))};
    }

    private Object[] unwrapTuple(Object[] wrapped) {
        Object[] unwrapped = new Object[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            unwrapped[i] = this.tupleWrappers_[i].unwrapValue(wrapped[i]);
        }
        return unwrapped;
    }

    private Object[] wrapTuple(Object[] unwrapped) {
        Object[] wrapped = new Object[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            wrapped[i] = this.tupleWrappers_[i].wrapValue(unwrapped[i]);
        }
        return wrapped;
    }

    private Comparable[] toComparables(Object[] objs) {
        Comparable[] comps = new Comparable[objs.length];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = objs[i] instanceof Comparable ? (Comparable)objs[i] : null;
        }
        return comps;
    }

    private static ValueWrapper createWrapper(ValueInfo info) {
        Class clazz;
        String units = info == null ? null : info.getUnitString();
        Class clazz2 = clazz = info == null ? null : info.getContentClass();
        if (HumanMatchEngine.matches(info, (ValueInfo)Tables.RA_INFO) || HumanMatchEngine.matches(info, (ValueInfo)Tables.DEC_INFO)) {
            if ("radians".equals(units) && (clazz == Double.class || clazz == Number.class)) {
                return new DoubleFactorWrapper(Math.PI / 180, "degrees");
            }
        } else if ("radians".equals(units) && (clazz == Double.class || clazz == Number.class)) {
            return new DoubleFactorWrapper(4.84813681109536E-6, "arcsec");
        }
        return NULL_WRAPPER;
    }

    private static boolean matches(ValueInfo info1, ValueInfo info2) {
        return info1 != null && info2 != null && info1.getName().equals(info2.getName()) && info1.getContentClass().equals(info2.getContentClass());
    }

    private static class DoubleFactorWrapper
    extends ValueWrapper {
        final double factor_;
        final String units_;

        DoubleFactorWrapper(double factor, String units) {
            this.factor_ = factor;
            this.units_ = units;
        }

        public Object wrapValue(Object value) {
            return value instanceof Number ? new Double(((Number)value).doubleValue() / this.factor_) : null;
        }

        public Object unwrapValue(Object value) {
            return value instanceof Number ? new Double(((Number)value).doubleValue() * this.factor_) : null;
        }

        public double wrapDouble(double value) {
            return value / this.factor_;
        }

        public ValueInfo wrapValueInfo(ValueInfo info) {
            DefaultValueInfo vinfo = new DefaultValueInfo(info);
            vinfo.setUnitString(this.units_);
            return vinfo;
        }

        public DescribedValue wrapDescribedValue(DescribedValue dval) {
            return new DescribedValue(this, this.wrapValueInfo(dval.getInfo()), this.wrapValue(dval.getValue()), dval){
                private final /* synthetic */ DescribedValue val$dval;
                private final /* synthetic */ DoubleFactorWrapper this$0;
                {
                    this.this$0 = this$0;
                    this.val$dval = val$dval;
                    super(x0, x1);
                }

                public Object getValue() {
                    return this.this$0.wrapValue(this.val$dval.getValue());
                }

                public void setValue(Object value) {
                    this.val$dval.setValue(this.this$0.unwrapValue(value));
                }
            };
        }
    }

    private static abstract class ValueWrapper {
        private ValueWrapper() {
        }

        public abstract Object unwrapValue(Object var1);

        public abstract Object wrapValue(Object var1);

        public abstract double wrapDouble(double var1);

        public abstract ValueInfo wrapValueInfo(ValueInfo var1);

        public abstract DescribedValue wrapDescribedValue(DescribedValue var1);
    }
}

