/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AnisotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.CombinedMatchEngine;
import uk.ac.starlink.table.join.EqualsMatchEngine;
import uk.ac.starlink.table.join.HEALPixMatchEngine;
import uk.ac.starlink.table.join.HTMMatchEngine;
import uk.ac.starlink.table.join.IsotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.SphericalPolarMatchEngine;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.join.HumanMatchEngine;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.task.WordsParameter;

public class MatchEngineParameter
extends Parameter
implements ExtraParameter {
    private final WordsParameter paramsParam_ = new WordsParameter("params");
    private final Parameter scoreParam_;
    private MatchEngine matchEngine_;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Score", Number.class, "Closeness of match (0 is exact)");
    private static final String TUPLE_NAME = "values";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public MatchEngineParameter(String name) {
        super(name);
        this.setDefault("sky");
        this.setPreferExplicit(true);
        this.setUsage("<matcher-name>");
        this.setPrompt("Name of matching algorithm");
        this.setDescription(new String[]{"<p>Defines the nature of the matching that will be performed.", "Depending on the name supplied, this may be positional", "matching using celestial or Cartesian coordinates,", "exact matching on the value of a string column,", "or other things.", "A list and explanation of the available matching algorithms", "is given in <ref id='MatchEngine'/>.", "The value supplied for this parameter determines the meanings", "of the values required by the ", "<code>" + this.paramsParam_.getName() + "</code> and", "<code>values*</code> parameter(s).", "</p>"});
        this.paramsParam_.setPrompt("Match parameters");
        this.paramsParam_.setDescription(new String[]{"<p>Determines the parameters of this match.", "This is typically one or more tolerances such as error radii.", "It may contain zero or more values; the values that are", "required depend on the match type selected by the", "<code>" + this.getName() + "</code> parameter.", "If it contains multiple values, they must be separated by spaces;", "values which contain a space can be 'quoted' or \"quoted\".", "</p>"});
        this.paramsParam_.setNullPermitted(true);
        this.paramsParam_.setUsage("<match-params>");
        this.scoreParam_ = new Parameter("scorecol");
        this.scoreParam_.setUsage("<col-name>");
        this.scoreParam_.setPrompt("Match score output column name");
        this.scoreParam_.setDescription(new String[]{"<p>Gives the name of a column in the output table to contain", "the \"match score\" for each pairwise match.", "The meaning of this column is dependent on the chosen", "<code>" + this.getName() + "</code>,", "but it typically represents a distance of some kind between", "the two matching points.", "If a null value is chosen, no score column will be inserted", "in the output table.", "The default value of this parameter depends on", "<code>" + this.getName() + "</code>.", "</p>"});
        this.scoreParam_.setNullPermitted(true);
        this.scoreParam_.setDefault(SCORE_INFO.getName());
    }

    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Available matchers, with associated parameters, include:\n");
        try {
            Iterator<String> it = Arrays.asList(MatchEngineParameter.getExampleValues()).iterator();
            while (it.hasNext()) {
                String name = it.next();
                StringBuffer line = new StringBuffer();
                MatchEngine engine = this.createEngine(name);
                line.append("      ").append(this.getName()).append('=').append(name);
                String pad = line.toString().replaceAll(".", " ");
                String vu = this.getValuesUsage(engine);
                String pu = this.getParamsUsage(engine);
                line.append(vu);
                if (line.length() + pu.length() > 78) {
                    line.append('\n').append(pad);
                }
                line.append(pu).append('\n');
                sbuf.append(line);
            }
        }
        catch (UsageException e) {
            sbuf.append("\n      ???\n");
        }
        return sbuf.toString();
    }

    public Parameter getMatchParametersParameter() {
        return this.paramsParam_;
    }

    public Parameter getScoreParameter() {
        return this.scoreParam_;
    }

    public ValueInfo getScoreInfo(Environment env) throws TaskException {
        this.checkGotValue(env);
        String scoreVal = this.scoreParam_.stringValue(env);
        if (scoreVal == null || scoreVal.trim().length() == 0) {
            return null;
        }
        ValueInfo baseInfo = this.matchEngine_.getMatchScoreInfo();
        DefaultValueInfo info = baseInfo == null ? new DefaultValueInfo(SCORE_INFO) : new DefaultValueInfo(baseInfo);
        info.setName(scoreVal);
        return info;
    }

    public WordsParameter createMatchTupleParameter(String numLabel) {
        boolean isNumbered = numLabel != null && numLabel.length() > 0;
        WordsParameter tupleParam = new WordsParameter(TUPLE_NAME + numLabel);
        tupleParam.setUsage("<expr-list>");
        tupleParam.setPrompt("Expressions for match values" + (isNumbered ? " from table " + numLabel : ""));
        tupleParam.setDescription(new String[]{"<p>Defines the values from", isNumbered ? "table " + numLabel : "the input table", "which are used to determine whether a match has occurred.", "These will typically be coordinate values such as RA and Dec", "and perhaps some per-row error values as well, though exactly", "what values are required is determined by the kind of match", "as determined by <code>" + this.getName() + "</code>.", "Depending on the kind of match, the number and type of", "the values required will be different.", "Multiple values should be separated by whitespace;", "if whitespace occurs within a single value it must be", "'quoted' or \"quoted\".", "Elements of the expression list are commonly just column", "names, but may be algebraic expressions calculated from", "zero or more columns as explained in <ref id='jel'/>.", "</p>"});
        return tupleParam;
    }

    public static void configureTupleParameter(WordsParameter tupleParam, MatchEngine matcher) {
        String tname = tupleParam.getName();
        int inum = tname.indexOf(TUPLE_NAME);
        String numLabel = inum >= 0 ? tname.substring(TUPLE_NAME.length() + inum) : "";
        ValueInfo[] tinfos = matcher.getTupleInfos();
        int nexpr = tinfos.length;
        StringBuffer sbuf = new StringBuffer();
        if (numLabel == null || numLabel.length() == 0) {
            sbuf.append("Match value expressions");
        } else {
            sbuf.append("Table ").append(numLabel).append(" match value expressions");
        }
        sbuf.append(" (");
        for (int i = 0; i < nexpr; ++i) {
            if (i > 0) {
                sbuf.append(' ');
            }
            sbuf.append(tinfos[i].getName().replaceAll(" ", "_"));
            String units = tinfos[i].getUnitString();
            if (units == null || units.trim().length() <= 0) continue;
            if (units.equalsIgnoreCase("degree") || units.equalsIgnoreCase("degrees")) {
                units = "deg";
            }
            sbuf.append('/').append(units);
        }
        sbuf.append(")");
        String prompt = sbuf.toString();
        tupleParam.setRequiredWordCount(nexpr);
        tupleParam.setPrompt(prompt);
    }

    public MatchEngine matchEngineValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.matchEngine_;
    }

    public void setValueFromString(Environment env, String stringVal) throws TaskException {
        String name = stringVal.toLowerCase();
        MatchEngine engine = this.createEngine(name);
        ValueInfo scoreInfo = engine.getMatchScoreInfo();
        this.scoreParam_.setDefault(scoreInfo == null ? null : scoreInfo.getName());
        DescribedValue[] params = engine.getMatchParameters();
        int nParam = params.length;
        if (nParam == 0) {
            this.paramsParam_.setNullPermitted(true);
            this.paramsParam_.setDefault(null);
        } else {
            this.paramsParam_.setNullPermitted(false);
            StringBuffer sbuf = new StringBuffer("Match parameters (");
            for (int i = 0; i < nParam; ++i) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(this.getInfoUsage(params[i].getInfo()));
            }
            sbuf.append(')');
            this.paramsParam_.setPrompt(sbuf.toString());
            this.paramsParam_.setRequiredWordCount(nParam);
            String[] words = this.paramsParam_.wordsValue(env);
            for (int i = 0; i < nParam; ++i) {
                String word = words[i];
                try {
                    params[i].setValueFromString(word);
                    logger_.info(params[i].toString());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new UsageException("Value " + words[i] + " not suitable " + "for matching parameter " + params[i].getInfo(), (Throwable)e);
                }
            }
        }
        this.matchEngine_ = engine;
        super.setValueFromString(env, stringVal);
    }

    /*
     * WARNING - void declaration
     */
    public MatchEngine createEngine(String name) throws UsageException {
        String[] names = name.trim().toLowerCase().split("\\+");
        MatchEngine[] components = new MatchEngine[names.length];
        for (int i = 0; i < names.length; ++i) {
            void var5_5;
            int ndim;
            HEALPixMatchEngine component;
            String cName = names[i];
            if ("sky".equals(cName) || "healpix".equals(cName)) {
                component = new HEALPixMatchEngine(4.84813681109536E-6, false);
            } else if ("skyerr".equals(cName)) {
                component = new HEALPixMatchEngine(4.84813681109536E-6, true);
            } else if ("sky3d".equals(cName)) {
                component = new SphericalPolarMatchEngine(0.0);
            } else if ("exact".equals(cName)) {
                component = new EqualsMatchEngine();
            } else if (cName.matches("[0-9]d")) {
                ndim = Integer.parseInt(cName.substring(0, 1));
                component = new IsotropicCartesianMatchEngine(ndim, 0.0, false);
            } else if (cName.matches("[0-9]d_anisotropic")) {
                ndim = Integer.parseInt(cName.substring(0, 1));
                component = new AnisotropicCartesianMatchEngine(new double[ndim]);
            } else if (cName.matches("htm")) {
                component = new HTMMatchEngine(4.84813681109536E-6, false);
            } else {
                throw new UsageException("Unknown matcher element: " + cName);
            }
            components[i] = new HumanMatchEngine((MatchEngine)var5_5);
        }
        return components.length == 1 ? components[0] : new CombinedMatchEngine(components);
    }

    public String getValuesUsage(MatchEngine engine) {
        StringBuffer sbuf = new StringBuffer();
        ValueInfo[] tupleInfos = engine.getTupleInfos();
        if (tupleInfos.length > 0) {
            sbuf.append(" values*='");
            for (int i = 0; i < tupleInfos.length; ++i) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append('<').append(this.getInfoUsage(tupleInfos[i])).append('>');
            }
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    public String getParamsUsage(MatchEngine engine) {
        StringBuffer sbuf = new StringBuffer();
        DescribedValue[] params = engine.getMatchParameters();
        if (params.length > 0) {
            sbuf.append(" params='");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append('<').append(this.getInfoUsage(params[i].getInfo())).append('>');
            }
            sbuf.append('\'');
        }
        return sbuf.toString();
    }

    private String getInfoUsage(ValueInfo info) {
        StringBuffer sbuf = new StringBuffer().append(info.getName().toLowerCase().replaceAll(" ", "-"));
        String units = info.getUnitString();
        if (units != null) {
            sbuf.append('/').append(units);
        }
        return sbuf.toString();
    }

    public static String[] getExampleValues() {
        return new String[]{"sky", "skyerr", "sky3d", "exact", "1d", "2d", "3d", "2d_anisotropic", "3d_anisotropic", "sky+1d"};
    }
}

