/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.PlasticUtils;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableWriter;

public class PlasticMode
implements ProcessingMode {
    private final Parameter transportParam_ = new ChoiceParameter("transport", (Object[])TRANSPORTS);
    private final Parameter clientParam_;
    static final String TRANSPORT_STRING;
    static final String TRANSPORT_FILE;
    private static final String[] TRANSPORTS;
    public static final URI MSG_BYTEXT;
    public static final URI MSG_BYURL;

    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Broadcasts the table to any registered Plastic-aware", "applications.", "<webref url='http://plastic.sourceforge.net/'>PLASTIC</webref>,", "the PLatform for AStronomical Tool InterConnection,", "is a tool interoperability protocol.", "A <em>Plastic hub</em> must be running in order for this to work.", "</p>"});
    }

    public PlasticMode() {
        this.transportParam_.setDescription(new String[]{"<p>Determines the method (PLASTIC <em>message</em>) used", "to perform the PLASTIC communication.  The choices are", "<ul>", "<li><code>string</code>:", "VOTable serialized as a string and passed as a call parameter", "(<code>" + MSG_BYTEXT + "</code>).", "Not suitable for very large files.</li>", "<li><code>file</code>:", "VOTable written to a temporary file and the filename passed as", "a call parameter", "(<code>" + MSG_BYURL + "</code>).", "The file ought to be deleted once it has been loaded.", "Not suitable for inter-machine communication.</li>", "</ul>", "If no value is set (<code>null</code>) then a decision will", "be taken based on the apparent size of the table.", "</p>"});
        this.transportParam_.setNullPermitted(true);
        this.transportParam_.setPrompt("PLASTIC transport mechanism");
        this.clientParam_ = new Parameter("client");
        this.clientParam_.setDescription(new String[]{"<p>Gives the name of a PLASTIC listener application which is to", "receive the broadcast table.", "If a non-null value is given, then only the first registered", "application which reports its application name as that value", "will receive the message.  If no value is supplied, the", "broadcast will be to all listening applications.", "</p>"});
        this.clientParam_.setNullPermitted(true);
        this.clientParam_.setPrompt("Recipient application");
        this.clientParam_.setUsage("<app-name>");
    }

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.transportParam_, this.clientParam_};
    }

    /*
     * WARNING - void declaration
     */
    public TableConsumer createConsumer(Environment env) throws TaskException {
        void var3_3;
        URI plasticId;
        PlasticHubListener hub;
        URI msg;
        String transport = this.transportParam_.stringValue(env);
        if (transport == null) {
            msg = null;
        } else if (transport.equals(TRANSPORT_STRING)) {
            msg = MSG_BYTEXT;
        } else if (transport.equals(TRANSPORT_FILE)) {
            msg = MSG_BYURL;
        } else {
            throw new ParameterValueException(this.transportParam_, "Unknown transport type");
        }
        String client = this.clientParam_.stringValue(env);
        try {
            hub = PlasticUtils.getLocalHub();
            plasticId = hub.registerNoCallBack("stilts");
        }
        catch (Throwable e) {
            throw new TaskException("Can't connect to PLASTIC hub", e);
        }
        StoragePolicy policy = LineTableEnvironment.getStoragePolicy(env);
        PrintStream out = env.getOutputStream();
        return new TableConsumer((URI)var3_3, hub, plasticId, policy, client, out){
            private final /* synthetic */ URI val$msg;
            private final /* synthetic */ PlasticHubListener val$hub;
            private final /* synthetic */ URI val$plasticId;
            private final /* synthetic */ StoragePolicy val$policy;
            private final /* synthetic */ String val$client;
            private final /* synthetic */ PrintStream val$out;
            {
                this.val$msg = val$msg;
                this.val$hub = val$hub;
                this.val$plasticId = val$plasticId;
                this.val$policy = val$policy;
                this.val$client = val$client;
                this.val$out = val$out;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(StarTable table) throws IOException {
                try {
                    PlasticMode.broadcast(table, this.val$msg, this.val$hub, this.val$plasticId, this.val$policy, this.val$client, this.val$out);
                }
                finally {
                    this.val$hub.unregister(this.val$plasticId);
                }
            }
        };
    }

    public static void broadcast(StarTable table, URI msg, PlasticHubListener hub, URI plasticId, StoragePolicy policy, String client, PrintStream out) throws IOException {
        List<String> args;
        List<Object> clientList;
        block14: {
            long nrow = table.getRowCount();
            URI clientId = null;
            if (client != null && client.trim().length() > 0) {
                Map nameResponses = hub.request(plasticId, MessageId.INFO_GETNAME, new ArrayList());
                Iterator it = nameResponses.entrySet().iterator();
                while (clientId == null && it.hasNext()) {
                    Map.Entry entry = it.next();
                    URI id = (URI)entry.getKey();
                    Object value = entry.getValue();
                    if (!(value instanceof String) || !((String)value).equalsIgnoreCase(client)) continue;
                    clientId = id;
                }
            }
            if (client != null && clientId == null) {
                throw new IOException("No PLASTIC listener by the name of " + client);
            }
            List<Object> list = clientList = clientId == null ? null : Collections.singletonList(clientId);
            if (MSG_BYTEXT.equals(msg) || msg == null && policy == StoragePolicy.PREFER_MEMORY && nrow >= 0L && nrow < 1000L) {
                try {
                    ByteArrayOutputStream bstrm = new ByteArrayOutputStream();
                    new VOTableWriter(DataFormat.TABLEDATA, true).writeStarTable(table, (OutputStream)bstrm);
                    bstrm.close();
                    String vot = bstrm.toString();
                    bstrm = null;
                    args = Arrays.asList(vot, "");
                    if (clientList == null) {
                        hub.requestAsynch(plasticId, MSG_BYTEXT, args);
                    } else {
                        hub.requestToSubsetAsynch(plasticId, MSG_BYTEXT, args, clientList);
                    }
                    return;
                }
                catch (OutOfMemoryError e) {
                    if (!MSG_BYTEXT.equals(msg)) break block14;
                    throw e;
                }
            }
        }
        if (msg == null || msg.equals(MSG_BYURL)) {
            File tmpfile = File.createTempFile("plastic", ".vot");
            tmpfile.deleteOnExit();
            BufferedOutputStream ostrm = new BufferedOutputStream(new FileOutputStream(tmpfile));
            new VOTableWriter(DataFormat.TABLEDATA, true).writeStarTable(table, (OutputStream)ostrm);
            ((OutputStream)ostrm).close();
            args = Collections.singletonList(URLUtils.makeFileURL((File)tmpfile).toString());
            Map loadResponses = clientList == null ? hub.request(plasticId, MSG_BYURL, args) : hub.requestToSubset(plasticId, MSG_BYURL, args, clientList);
            tmpfile.delete();
            if (out != null) {
                if (loadResponses.size() > 0) {
                    out.print("Broadcast to listeners: ");
                    Map nameResponses = hub.requestToSubset(plasticId, MessageId.INFO_GETNAME, new ArrayList(), new ArrayList(loadResponses.keySet()));
                    Iterator it = loadResponses.keySet().iterator();
                    while (it.hasNext()) {
                        URI id = (URI)it.next();
                        String name = (String)nameResponses.get(id);
                        if (name == null || name.trim().length() == 0) {
                            name = id.toString();
                        }
                        out.print(name);
                        if (!it.hasNext()) continue;
                        out.print(", ");
                    }
                    out.println();
                } else {
                    out.println("Nobody listening");
                }
            }
            return;
        }
        throw new AssertionError((Object)("Unknown transport: " + msg));
    }

    static {
        String[] stringArray = new String[2];
        TRANSPORT_STRING = "string";
        stringArray[0] = "string";
        TRANSPORT_FILE = "file";
        stringArray[1] = "file";
        TRANSPORTS = stringArray;
        MSG_BYTEXT = MessageId.VOT_LOAD;
        MSG_BYURL = MessageId.VOT_LOADURL;
    }
}

