/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.FixedEpsGraphics2D;

public abstract class GraphicExporter {
    private final String name_;
    private final String mimeType_;
    private final String[] fileSuffixes_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plot");
    public static final GraphicExporter JPEG = new ImageIOExporter("jpeg", "image/jpeg", new String[]{".jpg", ".jpeg"}, false);
    public static final GraphicExporter PNG = new ImageIOExporter("png", "image/png", new String[]{".png"}, true);
    public static final GraphicExporter GIF = new GraphicExporter("gif", "image/gif", new String[]{".gif"}){

        public void exportGraphic(JComponent comp, OutputStream out) throws IOException {
            int w = comp.getWidth();
            int h = comp.getHeight();
            BufferedImage image = new BufferedImage(w, h, 6);
            Graphics2D g = image.createGraphics();
            g.setBackground(new Color(0xFFFFFF, true));
            g.clearRect(0, 0, w, h);
            comp.print(g);
            g.dispose();
            HashSet<Integer> colors = new HashSet<Integer>();
            for (int ix = 0; ix < w; ++ix) {
                for (int iy = 0; iy < h; ++iy) {
                    colors.add(new Integer(image.getRGB(ix, iy)));
                }
            }
            if (colors.size() > 254) {
                logger_.warning("GIF export colour map filled up - JPEG or PNG might do a better job");
                IndexColorModel gifColorModel = GraphicExporter.getGifColorModel();
                image = new BufferedImage(w, h, 13, gifColorModel);
                WritableRaster raster = image.getRaster();
                int itrans = gifColorModel.getTransparentPixel();
                if (itrans >= 0) {
                    byte[] pixValue = new byte[]{(byte)itrans};
                    for (int ix = 0; ix < w; ++ix) {
                        for (int iy = 0; iy < h; ++iy) {
                            raster.setDataElements(ix, iy, pixValue);
                        }
                    }
                }
                Graphics2D gifG = image.createGraphics();
                gifG.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                comp.print(gifG);
                gifG.dispose();
            }
            new GifEncoder(image, out).encode();
        }
    };
    public static final GraphicExporter EPS = new GraphicExporter("eps", "application/postscript", new String[]{".eps", ".ps"}){

        public void exportGraphic(JComponent comp, OutputStream out) throws IOException {
            int pad;
            double scale;
            Rectangle bounds = comp.getBounds();
            double padfrac = 0.05;
            double xdpi = (double)bounds.width / 6.0;
            double ydpi = (double)bounds.height / 9.0;
            if (xdpi > ydpi) {
                scale = 72.0 / xdpi;
                pad = (int)Math.ceil((double)bounds.width * padfrac * scale);
            } else {
                scale = 72.0 / ydpi;
                pad = (int)Math.ceil((double)bounds.height * padfrac * scale);
            }
            int xlo = (int)Math.floor(scale * (double)bounds.x) - pad;
            int ylo = (int)Math.floor(scale * (double)bounds.y) - pad;
            int xhi = (int)Math.ceil(scale * (double)(bounds.x + bounds.width)) + pad;
            int yhi = (int)Math.ceil(scale * (double)(bounds.y + bounds.height)) + pad;
            FixedEpsGraphics2D g2 = new FixedEpsGraphics2D("Plot", out, xlo, ylo, xhi, yhi);
            g2.scale(scale, scale);
            comp.print(g2);
            g2.close();
        }
    };
    public static final GraphicExporter EPS_GZIP = new GzipExporter(EPS);

    protected GraphicExporter(String name, String mimeType, String[] fileSuffixes) {
        this.name_ = name;
        this.mimeType_ = mimeType;
        this.fileSuffixes_ = fileSuffixes == null ? new String[]{} : (String[])fileSuffixes.clone();
    }

    public abstract void exportGraphic(JComponent var1, OutputStream var2) throws IOException;

    public String getName() {
        return this.name_;
    }

    public String getMimeType() {
        return this.mimeType_;
    }

    public String getContentEncoding() {
        return null;
    }

    public String[] getFileSuffixes() {
        return (String[])this.fileSuffixes_.clone();
    }

    public String toString() {
        return this.name_;
    }

    private static IndexColorModel getGifColorModel() {
        IndexColorModel rgbModel = (IndexColorModel)new BufferedImage(1, 1, 13).getColorModel();
        byte[][] rgbs = new byte[3][256];
        rgbModel.getReds(rgbs[0]);
        rgbModel.getGreens(rgbs[1]);
        rgbModel.getBlues(rgbs[2]);
        int itrans = 254;
        rgbs[0][itrans] = -1;
        rgbs[1][itrans] = -1;
        rgbs[2][itrans] = -1;
        IndexColorModel gifModel = new IndexColorModel(8, 256, rgbs[0], rgbs[1], rgbs[2], itrans);
        return gifModel;
    }

    private static class GzipExporter
    extends GraphicExporter {
        private final GraphicExporter baseExporter_;

        GzipExporter(GraphicExporter baseExporter) {
            super(baseExporter.getName() + "-gzip", baseExporter.getMimeType(), GzipExporter.appendGzipSuffix(baseExporter.getFileSuffixes()));
            this.baseExporter_ = baseExporter;
        }

        public void exportGraphic(JComponent comp, OutputStream out) throws IOException {
            GZIPOutputStream gzout = new GZIPOutputStream(out);
            this.baseExporter_.exportGraphic(comp, gzout);
            gzout.finish();
        }

        public String getContentEncoding() {
            return "gzip";
        }

        private static String[] appendGzipSuffix(String[] names) {
            String[] sNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                sNames[i] = names[i] + ".gz";
            }
            return sNames;
        }
    }

    private static class ImageIOExporter
    extends GraphicExporter {
        private final String formatName_;
        private final int imageType_;
        private final boolean isSupported_;

        ImageIOExporter(String formatName, String mimeType, String[] fileSuffixes, boolean transparent) {
            super(formatName, mimeType, fileSuffixes);
            this.formatName_ = formatName;
            this.imageType_ = transparent ? 2 : 1;
            this.isSupported_ = ImageIO.getImageWritersByFormatName(formatName).hasNext();
        }

        public void exportGraphic(JComponent comp, OutputStream out) throws IOException {
            if (!this.isSupported_) {
                throw new IOException("Graphics export to " + this.formatName_ + " not supported");
            }
            int w = comp.getWidth();
            int h = comp.getHeight();
            BufferedImage image = new BufferedImage(w, h, this.imageType_);
            Graphics2D g2 = image.createGraphics();
            Color color = g2.getColor();
            Composite compos = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(2));
            g2.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            g2.fillRect(0, 0, w, h);
            g2.setColor(color);
            g2.setComposite(compos);
            comp.print(g2);
            boolean done = ImageIO.write((RenderedImage)image, this.formatName_, out);
            out.flush();
            g2.dispose();
            if (!done) {
                throw new IOException("No handler for format " + this.formatName_ + " (surprising - thought there was)");
            }
        }
    }
}

