/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot.BinnedData;

public class MapBinnedData
implements BinnedData {
    private final SortedMap map_;
    private final int nset_;
    private final BinMapper mapper_;
    private boolean isFloat_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");

    public MapBinnedData(int nset, BinMapper mapper) {
        this.nset_ = nset;
        this.mapper_ = mapper;
        this.map_ = new TreeMap();
    }

    public void submitDatum(double value, double weight, boolean[] setFlags) {
        if (Double.isNaN(value) || Double.isNaN(weight) || weight == 0.0) {
            return;
        }
        this.isFloat_ = this.isFloat_ || weight != (double)((int)weight);
        Comparable key = this.mapper_.getKey(value);
        if (key != null) {
            double[] counts = (double[])this.map_.get(key);
            if (counts == null) {
                counts = new double[this.nset_];
                this.map_.put(key, counts);
            }
            for (int is = 0; is < this.nset_; ++is) {
                if (!setFlags[is]) continue;
                int n = is;
                counts[n] = counts[n] + weight;
            }
        }
    }

    public Iterator getBinIterator(boolean includeEmpty) {
        final Iterator keyIt = includeEmpty && !this.map_.isEmpty() ? this.mapper_.keyIterator(this.map_.firstKey(), this.map_.lastKey()) : this.map_.keySet().iterator();
        return new Iterator(){
            final double[] EMPTY_SUMS;
            {
                this.EMPTY_SUMS = new double[MapBinnedData.this.nset_];
            }

            public boolean hasNext() {
                return keyIt.hasNext();
            }

            public Object next() {
                Object key = keyIt.next();
                double[] sums = MapBinnedData.this.map_.containsKey(key) ? (double[])MapBinnedData.this.map_.get(key) : this.EMPTY_SUMS;
                double[] bounds = MapBinnedData.this.mapper_.getBounds(key);
                return new BinnedData.Bin(this, bounds, sums){
                    private final /* synthetic */ double[] val$bounds;
                    private final /* synthetic */ double[] val$sums;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$bounds = val$bounds;
                        this.val$sums = val$sums;
                    }

                    public double getLowBound() {
                        return this.val$bounds[0];
                    }

                    public double getHighBound() {
                        return this.val$bounds[1];
                    }

                    public double getWeightedCount(int iset) {
                        return this.val$sums[iset];
                    }
                };
            }

            public void remove() {
                keyIt.remove();
            }
        };
    }

    public int getSetCount() {
        return this.nset_;
    }

    public boolean isInteger() {
        return !this.isFloat_;
    }

    public BinMapper getMapper() {
        return this.mapper_;
    }

    public static BinMapper createBinMapper(boolean logFlag, double binWidth, double binBase) {
        return logFlag ? new LogBinMapper(binWidth, binBase) : new LinearBinMapper(binWidth, binBase);
    }

    private static class LogBinMapper
    implements BinMapper {
        final double factor_;
        final double base_;
        final double logFactor_;

        LogBinMapper(double factor, double base) {
            this.factor_ = factor;
            this.base_ = base > 0.0 ? base : 1.0;
            this.logFactor_ = Math.log(factor);
        }

        public Comparable getKey(double value) {
            return value > 0.0 ? new Long((long)Math.floor(Math.log(value / this.base_) / this.logFactor_)) : null;
        }

        public double[] getBounds(Object key) {
            double lo = Math.pow(this.factor_, ((Long)key).doubleValue()) * this.base_;
            return new double[]{lo, lo * this.factor_};
        }

        public Iterator keyIterator(Object loKey, Object hiKey) {
            return new Iterator(this, hiKey, loKey){
                final long hiVal_;
                long val_;
                private final /* synthetic */ Object val$hiKey;
                private final /* synthetic */ Object val$loKey;
                private final /* synthetic */ LogBinMapper this$0;
                {
                    this.this$0 = this$0;
                    this.val$hiKey = val$hiKey;
                    this.val$loKey = val$loKey;
                    this.hiVal_ = (Long)this.val$hiKey;
                    this.val_ = (Long)this.val$loKey;
                }

                public boolean hasNext() {
                    return this.val_ <= this.hiVal_;
                }

                public Object next() {
                    return new Long(this.val_++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class LinearBinMapper
    implements BinMapper {
        final double width_;
        final double base_;

        LinearBinMapper(double binWidth, double binBase) {
            if (binWidth <= 0.0 || Double.isNaN(binWidth)) {
                throw new IllegalArgumentException("Bad width " + binWidth);
            }
            this.width_ = binWidth;
            this.base_ = binBase;
        }

        public Comparable getKey(double value) {
            return new Long((long)Math.floor((value - this.base_) / this.width_));
        }

        public double[] getBounds(Object key) {
            long keyval = (Long)key;
            double bottom = (double)keyval * this.width_ + this.base_;
            if (Double.isNaN(bottom) && !Double.isNaN(bottom)) {
                logger_.warning("Monstrous Java 1.4.1 JVM bug");
            }
            return new double[]{bottom, bottom + this.width_};
        }

        public Iterator keyIterator(Object loKey, Object hiKey) {
            return new Iterator(this, hiKey, loKey){
                final long hiVal_;
                long val_;
                private final /* synthetic */ Object val$hiKey;
                private final /* synthetic */ Object val$loKey;
                private final /* synthetic */ LinearBinMapper this$0;
                {
                    this.this$0 = this$0;
                    this.val$hiKey = val$hiKey;
                    this.val$loKey = val$loKey;
                    this.hiVal_ = (Long)this.val$hiKey;
                    this.val_ = (Long)this.val$loKey;
                }

                public boolean hasNext() {
                    return this.val_ <= this.hiVal_;
                }

                public Object next() {
                    return new Long(this.val_++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static interface BinMapper {
        public Comparable getKey(double var1);

        public double[] getBounds(Object var1);

        public Iterator keyIterator(Object var1, Object var2);
    }
}

