/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.HashSet;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot.PointArrayPixellator;

public abstract class MarkShape {
    private final String name_;
    private static final Pixellator[] OPEN_CIRCLE_PIXELS = MarkShape.calculateOpenCirclePixels();
    private static final Pixellator[] FILLED_CIRCLE_PIXELS = MarkShape.calculateFilledCirclePixels();
    public static final MarkShape POINT = new MarkShape("point"){
        final Object id = new Object();

        public MarkStyle getStyle(Color color, int size) {
            return new MarkStyle(this, color, this.id, this, 0, 1){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.fillRect(0, 0, 1, 1);
                }

                protected void drawLegendShape(Graphics g) {
                    g.fillRect(0, 0, 2, 2);
                }
            };
        }
    };
    public static final MarkShape OPEN_CIRCLE = new MarkShape("open circle"){

        public MarkStyle getStyle(Color color, int size) {
            int off = -size;
            int diam = size * 2;
            return new MarkStyle(this, color, new Integer(size), this, size, size + 1, off, diam, size){
                private final /* synthetic */ int val$off;
                private final /* synthetic */ int val$diam;
                private final /* synthetic */ int val$size;
                private final /* synthetic */ 3 this$0;
                {
                    this.this$0 = this$0;
                    this.val$off = val$off;
                    this.val$diam = val$diam;
                    this.val$size = val$size;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.drawOval(this.val$off, this.val$off, this.val$diam, this.val$diam);
                }

                public Pixellator getPixelOffsets() {
                    return this.val$size < MarkShape.access$000().length ? MarkShape.access$000()[this.val$size] : super.getPixelOffsets();
                }
            };
        }
    };
    public static final MarkShape FILLED_CIRCLE = new MarkShape("filled circle"){

        public MarkStyle getStyle(Color color, int size) {
            int off = -size;
            int diam = size * 2;
            return new MarkStyle(this, color, new Integer(size), this, size, size + 1, off, diam, size){
                private final /* synthetic */ int val$off;
                private final /* synthetic */ int val$diam;
                private final /* synthetic */ int val$size;
                private final /* synthetic */ 5 this$0;
                {
                    this.this$0 = this$0;
                    this.val$off = val$off;
                    this.val$diam = val$diam;
                    this.val$size = val$size;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.fillOval(this.val$off, this.val$off, this.val$diam, this.val$diam);
                    g.drawOval(this.val$off, this.val$off, this.val$diam, this.val$diam);
                }

                public Pixellator getPixelOffsets() {
                    return this.val$size < MarkShape.access$100().length ? MarkShape.access$100()[this.val$size] : super.getPixelOffsets();
                }
            };
        }
    };
    public static final MarkShape OPEN_SQUARE = new MarkShape("open square"){

        public MarkStyle getStyle(Color color, int size) {
            int off = -size;
            int height = size * 2;
            return new MarkStyle(this, color, new Integer(size), this, size, size + 1, off, height){
                private final /* synthetic */ int val$off;
                private final /* synthetic */ int val$height;
                private final /* synthetic */ 7 this$0;
                {
                    this.this$0 = this$0;
                    this.val$off = val$off;
                    this.val$height = val$height;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.drawRect(this.val$off, this.val$off, this.val$height, this.val$height);
                }
            };
        }
    };
    public static final MarkShape FILLED_SQUARE = new MarkShape("filled square"){

        public MarkStyle getStyle(Color color, int size) {
            int off = -size;
            int height = size * 2 + 1;
            return new MarkStyle(this, color, new Integer(size), this, size, size + 1, off, height){
                private final /* synthetic */ int val$off;
                private final /* synthetic */ int val$height;
                private final /* synthetic */ 9 this$0;
                {
                    this.this$0 = this$0;
                    this.val$off = val$off;
                    this.val$height = val$height;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.fillRect(this.val$off, this.val$off, this.val$height, this.val$height);
                }
            };
        }
    };
    public static final MarkShape CROSS = new MarkShape("cross"){

        public MarkStyle getStyle(Color color, int size) {
            int off = size;
            return new MarkStyle(this, color, new Integer(size), this, size, size + 1, off){
                private final /* synthetic */ int val$off;
                private final /* synthetic */ 11 this$0;
                {
                    this.this$0 = this$0;
                    this.val$off = val$off;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.drawLine(-this.val$off, 0, this.val$off, 0);
                    g.drawLine(0, -this.val$off, 0, this.val$off);
                }
            };
        }
    };
    public static final MarkShape CROXX = new MarkShape("x"){

        public MarkStyle getStyle(Color color, int size) {
            int off = size;
            return new MarkStyle(this, color, new Integer(size), this, size, size + 1, off){
                private final /* synthetic */ int val$off;
                private final /* synthetic */ 13 this$0;
                {
                    this.this$0 = this$0;
                    this.val$off = val$off;
                    super(x0, x1, x2, x3, x4);
                }

                protected void drawShape(Graphics g) {
                    g.drawLine(-this.val$off, -this.val$off, this.val$off, this.val$off);
                    g.drawLine(this.val$off, -this.val$off, -this.val$off, this.val$off);
                }
            };
        }
    };
    public static final MarkShape OPEN_DIAMOND = new MarkShape("open diamond"){

        public MarkStyle getStyle(Color color, int size) {
            return MarkShape.shapeStyle(color, MarkShape.diamond(size), (MarkShape)this, size, true, false);
        }
    };
    public static final MarkShape FILLED_DIAMOND = new MarkShape("filled diamond"){

        public MarkStyle getStyle(Color color, int size) {
            return MarkShape.shapeStyle(color, MarkShape.diamond(size), (MarkShape)this, size, true, true);
        }
    };
    public static final MarkShape OPEN_TRIANGLE_UP = new MarkShape("open triangle up"){

        public MarkStyle getStyle(Color color, int size) {
            return MarkShape.shapeStyle(color, MarkShape.triangle(size, true), (MarkShape)this, size, true, false);
        }
    };
    public static final MarkShape OPEN_TRIANGLE_DOWN = new MarkShape("open triangle down"){

        public MarkStyle getStyle(Color color, int size) {
            return MarkShape.shapeStyle(color, MarkShape.triangle(size, false), (MarkShape)this, size, true, false);
        }
    };
    public static final MarkShape FILLED_TRIANGLE_UP = new MarkShape("filled triangle up"){

        public MarkStyle getStyle(Color color, int size) {
            return MarkShape.shapeStyle(color, MarkShape.triangle(size, true), (MarkShape)this, size, false, true);
        }
    };
    public static final MarkShape FILLED_TRIANGLE_DOWN = new MarkShape("filled triangle down"){

        public MarkStyle getStyle(Color color, int size) {
            return MarkShape.shapeStyle(color, MarkShape.triangle(size, false), (MarkShape)this, size, false, true);
        }
    };

    public MarkShape(String name) {
        this.name_ = name;
    }

    public abstract MarkStyle getStyle(Color var1, int var2);

    public String toString() {
        return this.name_;
    }

    private static int getMaxRadius(Shape shape) {
        Rectangle rect = shape.getBounds();
        int[] bounds = new int[]{rect.x, rect.x + rect.width, rect.y, rect.y + rect.height};
        int maxr = 1;
        for (int i = 0; i < bounds.length; ++i) {
            maxr = Math.max(maxr, Math.abs(bounds[i]));
        }
        return maxr;
    }

    private static MarkStyle shapeStyle(Color color, final Shape shape, MarkShape shapeId, int size, final boolean draw, final boolean fill) {
        return new MarkStyle(color, shape, shapeId, size, MarkShape.getMaxRadius(shape)){

            protected void drawShape(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    if (fill) {
                        g2.fill(shape);
                    }
                    if (draw) {
                        g2.draw(shape);
                    }
                } else {
                    if (fill) {
                        g.fillRect(-1, -1, 2, 2);
                    }
                    if (draw) {
                        g.drawRect(-1, -1, 2, 2);
                    }
                }
            }
        };
    }

    private static MarkStyle filledShapeStyle(Color color, final Shape shape, MarkShape shapeId, int size) {
        return new MarkStyle(color, shape, shapeId, size, MarkShape.getMaxRadius(shape)){

            protected void drawShape(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.fill(shape);
                } else {
                    g.fillRect(-1, -1, 2, 2);
                }
            }
        };
    }

    private static Shape diamond(int size) {
        return new TestablePolygon(new int[]{-size, 0, size, 0}, new int[]{0, -size, 0, size}, 4);
    }

    private static Shape triangle(int size, boolean up) {
        double scale = (double)size * 1.5;
        int c = (int)Math.round(scale * Math.sqrt(3.0) / 2.0);
        int s = (int)Math.round(scale * 0.5);
        int r = (int)Math.round(scale);
        return up ? new TestablePolygon(new int[]{-c, 0, c}, new int[]{-s, r, -s}, 3) : new TestablePolygon(new int[]{-c, 0, c}, new int[]{s, -r, s}, 3);
    }

    private static Pixellator[] calculateOpenCirclePixels() {
        return MarkShape.rotatePixelLists(new int[][]{{0, 0}, {0, 1, 1, 1}, {0, 2, 1, 2}, {0, 3, 1, 3, 2, 2}, {0, 4, 1, 4, 2, 4, 3, 3}, {0, 5, 1, 5, 2, 5, 3, 4}});
    }

    private static Pixellator[] calculateFilledCirclePixels() {
        return MarkShape.rotatePixelLists(new int[][]{{0, 0}, {0, 0, 0, 1, 1, 1}, {0, 0, 0, 1, 0, 2, 1, 1, 1, 2}, {0, 0, 0, 1, 0, 2, 0, 3, 1, 1, 1, 2, 1, 3, 2, 2}, {0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 1, 1, 1, 2, 1, 3, 1, 4, 2, 2, 2, 3, 2, 4, 3, 3}, {0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 2, 2, 2, 3, 2, 4, 2, 5, 3, 3, 3, 4}});
    }

    private static Pixellator[] rotatePixelLists(int[][] seeds) {
        Pixellator[] results = new Pixellator[seeds.length];
        for (int size = 0; size < seeds.length; ++size) {
            int[] seed = seeds[size];
            HashSet<Point> pointSet = new HashSet<Point>();
            for (int ip = 0; ip < seed.length / 2; ++ip) {
                int a = seed[ip * 2 + 0];
                int b = seed[ip * 2 + 1];
                pointSet.add(new Point(a, b));
                pointSet.add(new Point(-b, a));
                pointSet.add(new Point(-a, -b));
                pointSet.add(new Point(b, -a));
                pointSet.add(new Point(b, a));
                pointSet.add(new Point(-a, b));
                pointSet.add(new Point(-b, -a));
                pointSet.add(new Point(a, -b));
            }
            Point[] points = pointSet.toArray(new Point[0]);
            results[size] = new PointArrayPixellator(points);
        }
        return results;
    }

    static /* synthetic */ Pixellator[] access$000() {
        return OPEN_CIRCLE_PIXELS;
    }

    static /* synthetic */ Pixellator[] access$100() {
        return FILLED_CIRCLE_PIXELS;
    }

    private static class TestablePolygon
    extends Polygon {
        public TestablePolygon(int[] xpoints, int[] ypoints, int npoints) {
            super(xpoints, ypoints, npoints);
        }

        public boolean equals(Object other) {
            if (other instanceof TestablePolygon) {
                TestablePolygon o = (TestablePolygon)other;
                return this.npoints == o.npoints && Arrays.equals(this.xpoints, o.xpoints) && Arrays.equals(this.ypoints, o.ypoints);
            }
            return false;
        }

        public int hashCode() {
            return this.npoints + this.xpoints.hashCode() + this.ypoints.hashCode();
        }
    }
}

