/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.util.ArrayList;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plottask.TablePlotData;
import uk.ac.starlink.ttools.plottask.TablePointSequence;

public class CartesianTablePlotData
extends TablePlotData {
    private final int ndim_;
    private final String labelExpr_;
    private final String[] setExprs_;
    private final String[] coordExprs_;
    private final String[] errExprs_;
    private final int nerrPairs_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CartesianTablePlotData(StarTable table, String[] setExprs, String[] setNames, Style[] setStyles, String labelExpr, String[] coordExprs, String[] errExprs) throws CompilationException {
        super(table, setExprs, setNames, setStyles, labelExpr);
        this.labelExpr_ = labelExpr;
        this.setExprs_ = setExprs;
        this.coordExprs_ = (String[])coordExprs.clone();
        this.ndim_ = coordExprs.length;
        this.errExprs_ = (String[])errExprs.clone();
        int nerr = 0;
        DummyJELRowReader dummyReader = new DummyJELRowReader(table);
        for (int idim = 0; idim < errExprs.length; ++idim) {
            if (this.createErrorReader(idim, errExprs[idim], dummyReader) == null) continue;
            ++nerr;
        }
        this.nerrPairs_ = nerr;
    }

    public int getNdim() {
        return this.ndim_;
    }

    public int getNerror() {
        return this.nerrPairs_ * 2;
    }

    private final ErrorReader createErrorReader(final int idim, String expr, final StarTableJELRowReader jelReader) throws CompilationException {
        if (expr == null || expr.trim().length() == 0 || expr.trim().equals(",")) {
            return null;
        }
        expr = expr.trim();
        ArrayList<Class> staticClassList = new ArrayList<Class>(JELUtils.getStaticClasses());
        staticClassList.add(PairCreator.class);
        Class[] staticLib = staticClassList.toArray(new Class[0]);
        Class[] dynamicLib = new Class[]{jelReader.getClass()};
        Class[] dotClasses = new Class[]{};
        Library lib = new Library(staticLib, dynamicLib, dotClasses, jelReader, null);
        StarTable table = jelReader.getTable();
        final double[][] errPair = new double[2][];
        final double[] lo = new double[this.ndim_];
        final double[] hi = new double[this.ndim_];
        if (expr.startsWith(",")) {
            String hiExpr = expr.substring(1).trim();
            final CompiledExpression hiCompex = JELUtils.compile(lib, table, hiExpr, Double.TYPE);
            return new ErrorReader(jelReader){

                public double[][] readErrorPair(double[] point) {
                    double off = this.evaluateDouble(hiCompex);
                    if (off > 0.0) {
                        for (int id = 0; id < CartesianTablePlotData.this.ndim_; ++id) {
                            hi[id] = point[id];
                        }
                        int n = idim;
                        hi[n] = hi[n] + off;
                        errPair[1] = hi;
                    } else {
                        errPair[1] = null;
                    }
                    return errPair;
                }
            };
        }
        if (expr.endsWith(",")) {
            String loExpr = expr.substring(0, expr.length() - 1).trim();
            final CompiledExpression loCompex = JELUtils.compile(lib, table, loExpr, Double.TYPE);
            return new ErrorReader(jelReader){

                public double[][] readErrorPair(double[] point) {
                    double off = this.evaluateDouble(loCompex);
                    if (off > 0.0) {
                        for (int id = 0; id < CartesianTablePlotData.this.ndim_; ++id) {
                            lo[id] = point[id];
                        }
                        int n = idim;
                        lo[n] = lo[n] - off;
                        errPair[0] = lo;
                    } else {
                        errPair[0] = null;
                    }
                    return errPair;
                }
            };
        }
        try {
            final CompiledExpression bothCompex = JELUtils.compile(lib, table, expr, Double.TYPE);
            return new ErrorReader(jelReader){

                public double[][] readErrorPair(double[] point) {
                    double off = this.evaluateDouble(bothCompex);
                    if (off > 0.0) {
                        for (int id = 0; id < CartesianTablePlotData.this.ndim_; ++id) {
                            lo[id] = point[id];
                            hi[id] = point[id];
                        }
                        int n = idim;
                        lo[n] = lo[n] - off;
                        int n2 = idim;
                        hi[n2] = hi[n2] + off;
                        errPair[0] = lo;
                        errPair[1] = hi;
                    } else {
                        errPair[0] = null;
                        errPair[1] = null;
                    }
                    return errPair;
                }
            };
        }
        catch (CompilationException e) {
            if (expr.indexOf(44) < 0) {
                throw e;
            }
            String pairExpr = "createDoublePair(" + expr + ")";
            final CompiledExpression pairCompex = Evaluator.compile(pairExpr, lib);
            return new ErrorReader(jelReader){

                public double[][] readErrorPair(double[] point) {
                    double[] offs;
                    try {
                        offs = (double[])jelReader.evaluate(pairCompex);
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        errPair[0] = null;
                        errPair[1] = null;
                        return errPair;
                    }
                    double loOff = offs[0];
                    if (loOff > 0.0) {
                        for (int id = 0; id < CartesianTablePlotData.this.ndim_; ++id) {
                            lo[id] = point[id];
                        }
                        int n = idim;
                        lo[n] = lo[n] - loOff;
                        errPair[0] = lo;
                    } else {
                        errPair[0] = null;
                    }
                    double hiOff = offs[1];
                    if (hiOff > 0.0) {
                        for (int id = 0; id < CartesianTablePlotData.this.ndim_; ++id) {
                            hi[id] = point[id];
                        }
                        int n = idim;
                        hi[n] = hi[n] + hiOff;
                        errPair[1] = hi;
                    } else {
                        errPair[1] = null;
                    }
                    return errPair;
                }
            };
        }
    }

    protected PointSequence createPointSequence(SequentialJELRowReader rseq) throws CompilationException {
        Library lib = JELUtils.getLibrary(rseq);
        final CompiledExpression[] coordCompexs = new CompiledExpression[this.ndim_];
        for (int idim = 0; idim < this.ndim_; ++idim) {
            String expr = this.coordExprs_[idim];
            coordCompexs[idim] = expr == null ? null : JELUtils.compile(lib, rseq.getTable(), expr, Double.TYPE);
        }
        ArrayList<ErrorReader> errReaderList = new ArrayList<ErrorReader>();
        for (int idim = 0; idim < this.errExprs_.length; ++idim) {
            ErrorReader errReader = this.createErrorReader(idim, this.errExprs_[idim], rseq);
            if (errReader == null) continue;
            errReaderList.add(errReader);
        }
        final ErrorReader[] errorReaders = errReaderList.toArray(new ErrorReader[0]);
        if (!$assertionsDisabled && errorReaders.length != this.nerrPairs_) {
            throw new AssertionError();
        }
        return new TablePointSequence(rseq, this.labelExpr_, this.setExprs_){
            private final double[] coords_;
            private final double[] coords1_;
            private final double[][] errors_;
            private final double[][] errors1_;
            private final double[][] errors2_;
            private boolean hasPoint_;
            private boolean hasErrors_;
            {
                super(x0, x1, x2);
                this.coords_ = new double[CartesianTablePlotData.this.ndim_];
                this.coords1_ = new double[CartesianTablePlotData.this.ndim_];
                this.errors_ = new double[CartesianTablePlotData.this.nerrPairs_ * 2][];
                this.errors1_ = new double[CartesianTablePlotData.this.nerrPairs_ * 2][];
                this.errors2_ = new double[CartesianTablePlotData.this.nerrPairs_ * 2][CartesianTablePlotData.this.ndim_];
            }

            public boolean next() {
                this.hasPoint_ = false;
                this.hasErrors_ = false;
                return super.next();
            }

            public double[] getPoint() {
                this.ensureHasPoint();
                for (int idim = 0; idim < CartesianTablePlotData.this.ndim_; ++idim) {
                    this.coords1_[idim] = this.coords_[idim];
                }
                return this.coords1_;
            }

            public double[][] getErrors() {
                this.ensureHasErrors();
                for (int ierr = 0; ierr < CartesianTablePlotData.this.nerrPairs_ * 2; ++ierr) {
                    double[] err1;
                    double[] err = this.errors_[ierr];
                    if (err == null) {
                        err1 = null;
                    } else {
                        err1 = this.errors2_[ierr];
                        for (int idim = 0; idim < CartesianTablePlotData.this.ndim_; ++idim) {
                            err1[idim] = err[idim];
                        }
                    }
                    this.errors1_[ierr] = err1;
                }
                return this.errors1_;
            }

            private void ensureHasPoint() {
                if (!this.hasPoint_) {
                    for (int idim = 0; idim < CartesianTablePlotData.this.ndim_; ++idim) {
                        this.coords_[idim] = this.evaluateDouble(coordCompexs[idim]);
                    }
                    this.hasPoint_ = true;
                }
            }

            private void ensureHasErrors() {
                if (!this.hasErrors_) {
                    this.ensureHasPoint();
                    for (int ierr = 0; ierr < CartesianTablePlotData.this.nerrPairs_; ++ierr) {
                        double[][] errPair = errorReaders[ierr].readErrorPair(this.coords_);
                        this.errors_[ierr * 2 + 0] = errPair[0];
                        this.errors_[ierr * 2 + 1] = errPair[1];
                    }
                    this.hasErrors_ = true;
                }
            }
        };
    }

    static {
        $assertionsDisabled = !CartesianTablePlotData.class.desiredAssertionStatus();
    }

    public static class PairCreator {
        public static double[] createDoublePair(double lo, double hi) {
            return new double[]{lo, hi};
        }
    }

    private static abstract class ErrorReader {
        final JELRowReader jelReader_;

        ErrorReader(JELRowReader jelReader) {
            this.jelReader_ = jelReader;
        }

        abstract double[][] readErrorPair(double[] var1);

        double evaluateDouble(CompiledExpression compex) {
            try {
                return this.jelReader_.evaluateDouble(compex);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                return Double.NaN;
            }
        }
    }
}

