/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plottask.PaintMode;
import uk.ac.starlink.ttools.plottask.PaintModeParameter;
import uk.ac.starlink.ttools.plottask.Painter;
import uk.ac.starlink.util.Destination;

public abstract class PaintMode {
    private final String name_;
    public static final PaintMode DEFAULT_MODE;
    private static final PaintMode SWING_MODE;
    private static final PaintMode OUTPUT_MODE;
    private static final PaintMode[] MODES;
    private static final GraphicExporter[] EXPORTERS;

    protected PaintMode(String name) {
        this.name_ = name;
    }

    public abstract Painter createPainter(Environment var1, PaintModeParameter var2) throws TaskException;

    public abstract String getDescription(PaintModeParameter var1);

    public abstract String getModeUsage(PaintModeParameter var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public static PaintMode[] getKnownModes() {
        return (PaintMode[])MODES.clone();
    }

    public static GraphicExporter[] getKnownExporters() {
        return (GraphicExporter[])EXPORTERS.clone();
    }

    static {
        SWING_MODE = new SwingPaintMode();
        OUTPUT_MODE = new OutputPaintMode();
        DEFAULT_MODE = new AutoPaintMode();
        MODES = new PaintMode[]{SWING_MODE, OUTPUT_MODE, new CgiPaintMode(), new DiscardPaintMode(), DEFAULT_MODE};
        EXPORTERS = new GraphicExporter[]{GraphicExporter.PNG, GraphicExporter.GIF, GraphicExporter.JPEG, GraphicExporter.EPS, GraphicExporter.EPS_GZIP};
    }

    private static class AutoPaintMode
    extends PaintMode {
        protected AutoPaintMode() {
            super("auto");
        }

        public String getDescription(PaintModeParameter modeParam) {
            return "Behaves as <code>" + SWING_MODE + "</code> or " + "<code>" + OUTPUT_MODE + "</code> mode" + " depending on presence of " + "<code>" + modeParam.getOutputParameter().getName() + "</code> parameter";
        }

        public String getModeUsage(PaintModeParameter modeParam) {
            OutputStreamParameter outParam = modeParam.getOutputParameter();
            return " [" + outParam.getName() + "=" + outParam.getUsage() + "]";
        }

        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            OutputStreamParameter outParam = param.getOutputParameter();
            ChoiceParameter formatParam = param.getFormatParameter();
            outParam.setNullPermitted(true);
            if (outParam.stringValue(env) == null) {
                return SWING_MODE.createPainter(env, param);
            }
            return OUTPUT_MODE.createPainter(env, param);
        }
    }

    private static class DiscardPaintMode
    extends PaintMode {
        DiscardPaintMode() {
            super("discard");
        }

        public String getDescription(PaintModeParameter modeParam) {
            return "Plot is drawn, but discarded.  There is no output.";
        }

        public String getModeUsage(PaintModeParameter modeParam) {
            return "";
        }

        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            return new Painter(this){
                private final /* synthetic */ DiscardPaintMode this$0;
                {
                    this.this$0 = this$0;
                }

                public void paintPlot(JComponent plot) {
                    BufferedImage image = new BufferedImage(1, 1, 1);
                    Graphics2D g2 = image.createGraphics();
                    plot.print(g2);
                    g2.dispose();
                }
            };
        }
    }

    private static class CgiPaintMode
    extends PaintMode {
        CgiPaintMode() {
            super("cgi");
        }

        public String getDescription(PaintModeParameter modeParam) {
            return "Plot will be written in a way suitable for CGI use direct from a web server.\nThe output is in the graphics format given by <code>" + modeParam.getFormatParameter().getName() + "</code>,\n" + "preceded by a suitable \"Content-type\" declaration.";
        }

        public String getModeUsage(PaintModeParameter modeParam) {
            ChoiceParameter formatParam = modeParam.getFormatParameter();
            return " " + formatParam.getName() + "=" + formatParam.getUsage();
        }

        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            GraphicExporter exporter = (GraphicExporter)param.getFormatParameter().objectValue(env);
            PrintStream out = env.getOutputStream();
            return new Painter(this, out, exporter){
                private final /* synthetic */ OutputStream val$out;
                private final /* synthetic */ GraphicExporter val$exporter;
                private final /* synthetic */ CgiPaintMode this$0;
                {
                    this.this$0 = this$0;
                    this.val$out = val$out;
                    this.val$exporter = val$exporter;
                }

                public void paintPlot(JComponent plot) throws IOException {
                    BufferedOutputStream bout = new BufferedOutputStream(this.val$out);
                    StringBuffer hbuf = new StringBuffer();
                    hbuf.append("Content-Type: ").append(this.val$exporter.getMimeType()).append('\n');
                    String encoding = this.val$exporter.getContentEncoding();
                    if (encoding != null) {
                        hbuf.append("Content-Encoding: ").append(encoding).append('\n');
                    }
                    hbuf.append('\n');
                    bout.write(hbuf.toString().getBytes("UTF-8"));
                    this.val$exporter.exportGraphic(plot, bout);
                    bout.flush();
                }
            };
        }
    }

    private static class OutputPaintMode
    extends PaintMode {
        OutputPaintMode() {
            super("out");
        }

        public String getDescription(PaintModeParameter modeParam) {
            return "Plot will be written to a file given by <code>" + modeParam.getOutputParameter().getName() + "</code> " + "using the graphics format given by " + "<code>" + modeParam.getFormatParameter().getName() + "</code>.";
        }

        public String getModeUsage(PaintModeParameter modeParam) {
            OutputStreamParameter outParam = modeParam.getOutputParameter();
            ChoiceParameter formatParam = modeParam.getFormatParameter();
            return " " + outParam.getName() + "=" + outParam.getUsage() + " " + formatParam.getName() + "=" + formatParam.getUsage();
        }

        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            OutputStreamParameter outParam = param.getOutputParameter();
            ChoiceParameter formatParam = param.getFormatParameter();
            Destination dest = outParam.destinationValue(env);
            String out = outParam.stringValue(env);
            GraphicExporter dfltExp = null;
            if (out != null) {
                for (int ie = 0; ie < EXPORTERS.length; ++ie) {
                    String[] fss = EXPORTERS[ie].getFileSuffixes();
                    for (int is = 0; is < fss.length; ++is) {
                        if (!out.toLowerCase().endsWith(fss[is].toLowerCase())) continue;
                        dfltExp = EXPORTERS[ie];
                    }
                }
            }
            if (dfltExp != null) {
                formatParam.setDefault(dfltExp.getName());
            }
            GraphicExporter exporter = (GraphicExporter)formatParam.objectValue(env);
            return new Painter(this, dest, exporter){
                private final /* synthetic */ Destination val$dest;
                private final /* synthetic */ GraphicExporter val$exporter;
                private final /* synthetic */ OutputPaintMode this$0;
                {
                    this.this$0 = this$0;
                    this.val$dest = val$dest;
                    this.val$exporter = val$exporter;
                }

                public void paintPlot(JComponent plot) throws IOException {
                    BufferedOutputStream out = new BufferedOutputStream(this.val$dest.createStream());
                    try {
                        this.val$exporter.exportGraphic(plot, out);
                    }
                    catch (IOException e) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e2) {
                            throw e;
                        }
                    }
                    ((OutputStream)out).close();
                }
            };
        }
    }

    private static class SwingPaintMode
    extends PaintMode {
        SwingPaintMode() {
            super("swing");
        }

        public String getDescription(PaintModeParameter modeParam) {
            return "Plot will be displayed in a window on the screen.";
        }

        public String getModeUsage(PaintModeParameter modeParam) {
            return "";
        }

        public Painter createPainter(Environment env, PaintModeParameter param) {
            return new Painter(this){
                private final /* synthetic */ SwingPaintMode this$0;
                {
                    this.this$0 = this$0;
                }

                public void paintPlot(JComponent plot) {
                    plot.setDoubleBuffered(true);
                    plot.setPreferredSize(plot.getSize());
                    JFrame frame = new JFrame("STILTS Plot");
                    frame.setDefaultCloseOperation(2);
                    frame.getContentPane().add(plot);
                    String quitKey = "quit";
                    plot.getInputMap().put(KeyStroke.getKeyStroke('q'), quitKey);
                    plot.getActionMap().put(quitKey, new AbstractAction(this, frame){
                        private final /* synthetic */ JFrame val$frame;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$frame = val$frame;
                        }

                        public void actionPerformed(ActionEvent evt) {
                            this.val$frame.dispose();
                        }
                    });
                    frame.pack();
                    frame.setVisible(true);
                }
            };
        }
    }
}

