/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.task.InputTableParameter;

public class Calc
implements Task {
    private final Parameter exprParam_ = new Parameter("expression");
    private final InputTableParameter tableParam_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Calc() {
        this.exprParam_.setPosition(1);
        this.exprParam_.setUsage("<expr>");
        this.exprParam_.setPrompt("Expression to evaluate");
        this.exprParam_.setDescription(new String[]{"<p>An expression to evaluate.", "The functions in <ref id='staticMethods'/> can be used.", "</p>"});
        this.tableParam_ = new InputTableParameter("table");
        this.tableParam_.setNullPermitted(true);
        this.tableParam_.setUsage("<table>");
        this.tableParam_.setPrompt("Table providing context for expression");
        this.tableParam_.setDescription(new String[]{"<p>A table which provides the context within which", "<code>" + this.exprParam_.getName() + "</code> is evaluated.", "This parameter is optional, and will usually not be required;", "its only purpose is to allow use of constant expressions", "(table parameters) associated with the table.", "These can be referenced using identifiers of the form", "<code>param$*</code> or", "<code>ucd$*</code> -", "see <ref id='jel-paramref'/> for more detail.", "</p>"});
    }

    public String getPurpose() {
        return "Evaluates expressions";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.exprParam_, this.tableParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        CompiledExpression compEx;
        ColumnStarTable table;
        block5: {
            table = ColumnStarTable.makeTableWithRows((long)0L);
            List paramList = table.getParameters();
            try {
                paramList.clear();
                String tname = this.tableParam_.stringValue(env);
                if (tname != null && tname.trim().length() > 0) {
                    paramList.addAll(this.tableParam_.tableValue(env).getParameters());
                }
            }
            catch (UnsupportedOperationException e) {
                logger_.log(Level.WARNING, "Immutable table parameter list: " + e, e);
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        final DummyJELRowReader rdr = new DummyJELRowReader((StarTable)table);
        Library lib = JELUtils.getLibrary(rdr);
        String expr = this.exprParam_.stringValue(env);
        final PrintStream out = env.getOutputStream();
        try {
            compEx = Evaluator.compile(expr, lib);
        }
        catch (CompilationException e) {
            throw new TaskException("Bad expression \"" + expr + "\": " + e.getMessage(), (Throwable)e);
        }
        return new Executable(){

            public void execute() throws TaskException {
                out.println("   " + this.evaluate());
            }

            private Object evaluate() throws TaskException {
                try {
                    return rdr.evaluate(compEx);
                }
                catch (NullPointerException e) {
                    return null;
                }
                catch (Throwable e) {
                    String msg = e.getMessage();
                    msg = msg == null ? "Execution error: " + e.toString() : "Execution error: " + msg;
                    throw new TaskException(msg, e);
                }
            }
        };
    }

    static {
        $assertionsDisabled = !Calc.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    }
}

