/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.LineWord;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class LineInvoker {
    private final String toolName_;
    private final ObjectFactory taskFactory_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools");

    public LineInvoker(String toolName, ObjectFactory taskFactory) {
        this.toolName_ = toolName;
        this.taskFactory_ = taskFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(String[] args) {
        String arg;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        LineTableEnvironment env = new LineTableEnvironment();
        int verbosity = 0;
        boolean bench = false;
        PrintStream out = System.out;
        PrintStream err = System.err;
        Iterator it = argList.iterator();
        while (it.hasNext() && ((arg = (String)it.next()).startsWith("-") || arg.startsWith("+"))) {
            if (arg.equals("-help") || arg.equals("-h")) {
                it.remove();
                String topic = it.hasNext() ? (String)it.next() : null;
                out.println("\n" + this.getUsage(topic));
                return 0;
            }
            if (arg.equals("-version")) {
                it.remove();
                String[] lines = new String[]{"", "This is STILTS, the STIL Tool Set", "", "STILTS version " + Stilts.getVersion(), "STIL version " + IOUtils.getResourceContents((Class)StarTable.class, (String)"stil.version"), "JVM: " + InvokeUtils.getJavaVM(), "", "Author: Mark Taylor", "WWW: http://www.starlink.ac.uk/stilts/", ""};
                for (int il = 0; il < lines.length; ++il) {
                    String line = lines[il];
                    if (line.length() > 0) {
                        out.print("    ");
                    }
                    out.println(line);
                }
                return 0;
            }
            if (arg.equals("-verbose")) {
                it.remove();
                ++verbosity;
                continue;
            }
            if (arg.equals("+verbose")) {
                it.remove();
                --verbosity;
                continue;
            }
            if (arg.equals("-disk")) {
                it.remove();
                StoragePolicy.setDefaultPolicy((StoragePolicy)StoragePolicy.PREFER_DISK);
                env.getTableFactory().setStoragePolicy(StoragePolicy.PREFER_DISK);
                continue;
            }
            if (arg.equals("-votstrict")) {
                it.remove();
                env.setStrictVotable(true);
                continue;
            }
            if (arg.equals("-novotstrict")) {
                it.remove();
                env.setStrictVotable(false);
                continue;
            }
            if (arg.equals("-batch")) {
                it.remove();
                env.setInteractive(false);
                continue;
            }
            if (arg.equals("-prompt")) {
                it.remove();
                env.setPromptAll(true);
                continue;
            }
            if (arg.equals("-debug")) {
                it.remove();
                env.setDebug(true);
                continue;
            }
            if (arg.equals("-bench")) {
                it.remove();
                bench = true;
                continue;
            }
            if (arg.equals("-checkversion") && it.hasNext()) {
                it.remove();
                String vers = (String)it.next();
                it.remove();
                if (vers.equals(Stilts.getVersion())) continue;
                err.println("Version mismatch: " + Stilts.getVersion() + " != " + vers);
                return 1;
            }
            if (arg.equals("-stdout") && it.hasNext()) {
                it.remove();
                String outName = (String)it.next();
                it.remove();
                if (outName == null || outName.trim().length() == 0 || "-".equals(outName)) {
                    out = System.out;
                    continue;
                }
                try {
                    out = new PrintStream(new FileOutputStream(outName));
                    continue;
                }
                catch (IOException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(err);
                    } else {
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = e.toString();
                        }
                        err.println("\n" + msg + "\n");
                    }
                    return 1;
                }
            }
            if (arg.equals("-stderr") && it.hasNext()) {
                it.remove();
                String errName = (String)it.next();
                it.remove();
                if (errName == null || errName.trim().length() == 0 || "=".equals(errName)) {
                    err = System.err;
                    continue;
                }
                try {
                    err = new PrintStream(new FileOutputStream(errName));
                    continue;
                }
                catch (IOException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(err);
                    } else {
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = e.toString();
                        }
                        err.println("\n" + msg + "\n");
                    }
                    return 1;
                }
            }
            it.remove();
            err.println("\n" + this.getUsage());
            return 1;
        }
        if (argList.size() == 0) {
            err.println("\n" + this.getUsage());
            return 1;
        }
        env.setOutputStream(out);
        env.setErrorStream(err);
        InvokeUtils.configureLogging((int)verbosity, (boolean)env.isDebug());
        String taskName = (String)argList.remove(0);
        if (this.taskFactory_.isRegistered(taskName)) {
            Task task = null;
            try {
                task = (Task)this.taskFactory_.createObject(taskName);
                String[] taskArgs = argList.toArray(new String[0]);
                String helpText = this.helpMessage(env, task, taskName, taskArgs);
                if (helpText != null) {
                    out.println("\n" + helpText);
                    int msg = 0;
                    return msg;
                }
                LineWord[] words = new LineWord[taskArgs.length];
                for (int i = 0; i < taskArgs.length; ++i) {
                    words[i] = new LineWord(taskArgs[i]);
                }
                env.setWords(words);
                long start = System.currentTimeMillis();
                Executable exec = task.createExecutable((Environment)env);
                String[] unused = env.getUnused();
                if (unused.length == 0) {
                    this.logParameterValues(taskName, env);
                    exec.execute();
                    if (bench) {
                        long millis = System.currentTimeMillis() - start;
                        String secs = Float.toString((float)(millis / 100L) * 0.1f);
                        err.println("Elapsed time: " + secs + "s");
                    }
                    int n = 0;
                    return n;
                }
                err.println("\n" + LineInvoker.getUnusedWarning(unused));
                err.println(LineInvoker.getTaskUsage(task, taskName));
                int n = 1;
                return n;
            }
            catch (TaskException e) {
                this.reportError(env, e);
                if (e instanceof ParameterValueException && task != null) {
                    Parameter param = ((ParameterValueException)e).getParameter();
                    err.println("Usage: " + param.getName() + "=" + param.getUsage());
                    err.println();
                } else if (e instanceof UsageException && task != null) {
                    err.println(LineInvoker.getTaskUsage(task, taskName));
                }
                int param = 1;
                return param;
            }
            catch (IllegalArgumentException e) {
                this.reportError(env, e);
                int param = 1;
                return param;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                int param = 1;
                return param;
            }
            catch (IOException e) {
                this.reportError(env, e);
                int param = 1;
                return param;
            }
            catch (LoadException e) {
                err.println("Task " + taskName + " not available");
                if (e.getMessage() != null) {
                    err.println(e.getMessage() + "\n");
                }
                if (env.isDebug()) {
                    e.printStackTrace(err);
                }
                int param = 1;
                return param;
            }
            catch (OutOfMemoryError e) {
                err.println("\nOut of memory");
                if (e.getMessage() != null) {
                    err.println(e.getMessage());
                }
                if (env.getTableFactory().getStoragePolicy() != StoragePolicy.PREFER_DISK) {
                    err.println("Try \"-disk\" flag?\n");
                } else {
                    err.println("Try increasing heap memory (-Xmx flag)\n");
                }
                if (env.isDebug()) {
                    e.printStackTrace(err);
                }
                int param = 1;
                return param;
            }
            catch (NoClassDefFoundError e) {
                this.reportError(env, e);
                if (env.isDebug()) {
                    e.printStackTrace(err);
                }
                try {
                    String msg = "\n" + "The runtime Java Runtime Environment (JRE) " + "is missing some compile-time classes.\n" + "The most likely reason is that you are " + "using an incomplete java such as GNU gcj.\n" + "The JVM you are using is " + System.getProperty("java.vm.name", "unknown") + " version " + System.getProperty("java.vm.version", "?") + ".\n" + "The recommended JRE is Sun's J2SE " + "version 1.4 or greater.\n";
                    err.println(msg);
                }
                catch (Throwable e1) {
                    e1.printStackTrace(err);
                }
                int n = 1;
                return n;
            }
            finally {
                out.flush();
                err.flush();
            }
        }
        err.println("\nNo such task: " + taskName);
        err.println("\n" + this.getUsage());
        err.flush();
        return 1;
    }

    private void logParameterValues(String taskName, LineTableEnvironment env) {
        StringBuffer sbuf = new StringBuffer(taskName);
        String[] words = env.getAssignments();
        for (int i = 0; i < words.length; ++i) {
            sbuf.append(' ').append(words[i]);
        }
        logger_.info(sbuf.toString());
    }

    private String helpMessage(LineTableEnvironment env, Task task, String taskName, String[] taskArgs) {
        for (int i = 0; i < taskArgs.length; ++i) {
            String arg = taskArgs[i];
            String helpFor = null;
            if (arg.equals("-help") || arg.equals("-h") || arg.equalsIgnoreCase("help")) {
                return LineInvoker.getTaskUsage(task, taskName);
            }
            if (arg.toLowerCase().startsWith("-help=")) {
                helpFor = arg.substring(6).trim().toLowerCase();
            } else if (arg.toLowerCase().startsWith("help=")) {
                helpFor = arg.substring(5).trim().toLowerCase();
            } else if (arg.length() > 2 && arg.endsWith("=?")) {
                helpFor = arg.substring(0, arg.length() - 2);
            }
            if ("*".equals(helpFor)) {
                Parameter[] params = task.getParameters();
                StringBuffer sbuf = new StringBuffer();
                for (int j = 0; j < params.length; ++j) {
                    sbuf.append(LineInvoker.getParamHelp(env, taskName, params[j]));
                    sbuf.append('\n');
                }
                return sbuf.toString();
            }
            if (helpFor == null) continue;
            Parameter[] params = task.getParameters();
            for (int j = 0; j < params.length; ++j) {
                Parameter param = params[j];
                if (!env.paramNameMatches(helpFor, param)) continue;
                return LineInvoker.getParamHelp(env, taskName, param);
            }
            String stripper = '(' + "N" + '|' + "S" + '|' + "" + ')' + '*' + '$';
            for (int j = 0; j < params.length; ++j) {
                Parameter param = params[j];
                String pname = param.getName().replaceFirst(stripper, "");
                if (!LineTableEnvironment.normaliseName(helpFor).equals(LineTableEnvironment.normaliseName(pname))) continue;
                return LineInvoker.getParamHelp(env, taskName, param);
            }
            return "No help for parameter: " + helpFor + "\n\n" + LineInvoker.getTaskUsage(task, taskName);
        }
        return null;
    }

    private String getUsage(String topic) {
        if (topic != null) {
            try {
                Task task = (Task)this.taskFactory_.createObject(topic);
                return LineInvoker.getTaskUsage(task, topic);
            }
            catch (LoadException loadException) {
                // empty catch block
            }
        }
        return this.getUsage();
    }

    private void reportError(TableEnvironment env, Throwable e) {
        if (env.isDebug()) {
            e.printStackTrace(env.getErrorStream());
        } else {
            StringBuffer sbuf = new StringBuffer();
            int i = 0;
            while (e != null) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                if (i > 0) {
                    sbuf.append('\n');
                    for (int j = 0; j < i; ++j) {
                        sbuf.append("    ");
                    }
                    sbuf.append('(');
                }
                sbuf.append(msg);
                ++i;
                e = e.getCause();
            }
            for (int j = 1; j < i; ++j) {
                sbuf.append(')');
            }
            env.getErrorStream().println(sbuf.toString());
        }
    }

    private String getUsage() {
        StringBuffer sbuf = new StringBuffer().append("Usage:\n");
        String pad1 = "   ";
        String pad = (pad1 + this.toolName_).replaceAll(".", " ");
        sbuf.append(pad1).append(this.toolName_).append(" [-help]").append(" [-version]").append(" [-verbose]").append(" [-disk]").append(" [-debug]").append(" [-prompt]").append(" [-batch]").append('\n').append(pad).append(" [-bench]").append(" [-checkversion <vers>]").append(" [-stdout <file>]").append(" [-stderr <file>]").append('\n').append(pad).append(" <task-name> <task-args>").append('\n').append('\n');
        sbuf.append(pad1).append(this.toolName_).append(" <task-name> help[=<param-name>|*]").append('\n').append('\n');
        sbuf.append("   Known tasks:\n");
        String[] tasks = this.taskFactory_.getNickNames();
        for (int i = 0; i < tasks.length; ++i) {
            sbuf.append("      ").append(tasks[i]).append('\n');
        }
        return sbuf.toString();
    }

    private static String getTaskUsage(Task task, String taskName) {
        String prefix = "Usage: " + taskName;
        StringBuffer usage = new StringBuffer();
        usage.append(LineInvoker.getPrefixedTaskUsage(task, prefix));
        String pad = prefix.replaceAll(".", " ");
        return usage.toString();
    }

    public static String getPrefixedTaskUsage(Task task, String prefix) {
        Parameter[] params = task.getParameters();
        ArrayList namedWords = new ArrayList();
        ArrayList<String> numberedWords = new ArrayList<String>();
        int iPos = 0;
        for (int i = 0; i < params.length; ++i) {
            StringBuffer word = new StringBuffer();
            word.append(' ');
            Parameter param = params[i];
            int pos = param.getPosition();
            boolean byPos = false;
            if (param.getPosition() > 0) {
                if (pos == ++iPos) {
                    byPos = true;
                } else {
                    logger_.warning("Parameter positions out of sync for " + param);
                }
            }
            if (byPos) {
                word.append('[');
            }
            word.append(param.getName()).append('=');
            if (byPos) {
                word.append(']');
            }
            word.append(param.getUsage());
            (byPos ? numberedWords : namedWords).add(word.toString());
        }
        StringBuffer usage = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append(prefix);
        String pad = line.toString().replaceAll(".", " ");
        if (namedWords.size() > 0) {
            Iterator it = namedWords.iterator();
            while (it.hasNext()) {
                String word = (String)it.next();
                if (line.length() + word.length() > 78) {
                    usage.append(line).append('\n');
                    line = new StringBuffer(pad);
                }
                line.append(word);
            }
            usage.append(line).append('\n');
            line = new StringBuffer(pad);
        }
        if (numberedWords.size() > 0) {
            Iterator it = numberedWords.iterator();
            while (it.hasNext()) {
                String word = (String)it.next();
                if (line.length() + word.length() > 78) {
                    usage.append(line).append('\n');
                    line = new StringBuffer(pad);
                }
                line.append(word);
            }
            usage.append(line).append('\n');
            line = new StringBuffer(pad);
        }
        if (line.toString().trim().length() > 0) {
            usage.append(line).append('\n');
        }
        return usage.toString();
    }

    public static String getParamHelp(TableEnvironment env, String taskName, Parameter param) {
        boolean byPos = param.getPosition() > 0;
        boolean isOptional = param.getDefault() != null || param.isNullPermitted();
        StringBuffer sbuf = new StringBuffer();
        if (taskName != null) {
            sbuf.append("Help for parameter ").append(param.getName().toUpperCase()).append(" in task ").append(taskName.toUpperCase()).append('\n').append(sbuf.toString().replaceAll(".", "-"));
        }
        sbuf.append("\n   Name:\n").append("      ").append(param.getName()).append("\n\n   Usage:\n").append("      ").append(isOptional ? "[" : "").append(byPos ? "[" : "").append(param.getName()).append('=').append(byPos ? "]" : "").append(param.getUsage()).append(isOptional ? "]" : "").append("\n\n   Summary:\n").append("      ").append(param.getPrompt()).append("\n\n   Description:\n");
        try {
            sbuf.append(new Formatter().formatXML(param.getDescription(), 6));
        }
        catch (SAXException e) {
            sbuf.append("      ???");
        }
        if (param.getDefault() != null || param.isNullPermitted()) {
            sbuf.append("\n\n   Default:\n").append("      ").append(param.getDefault());
        }
        if (param instanceof ExtraParameter) {
            sbuf.append("\n\n").append(((ExtraParameter)param).getExtraUsage(env));
        }
        sbuf.append('\n');
        return sbuf.toString();
    }

    private static String getUnusedWarning(String[] unused) {
        StringBuffer sbuf = new StringBuffer("Unused arguments:");
        for (int i = 0; i < unused.length; ++i) {
            sbuf.append(' ').append(unused[i]);
        }
        sbuf.append('\n');
        return sbuf.toString();
    }
}

