/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.InputStreamParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.lint.DoctypeInterpolator;
import uk.ac.starlink.ttools.lint.LintContext;
import uk.ac.starlink.ttools.lint.Linter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class VotLint
implements Task {
    private final InputStreamParameter inParam_ = new InputStreamParameter("votable");
    private final BooleanParameter validParam_;
    private final Parameter versionParam_;
    private final OutputStreamParameter outParam_;

    public VotLint() {
        this.inParam_.setDefault("-");
        this.inParam_.setPosition(1);
        this.inParam_.setPrompt("VOTable location");
        this.inParam_.setDescription(new String[]{"<p>Location of the VOTable to be checked.", "This may be a filename, URL or \"-\" (the default),", "to indicate standard input.", "The input may be compressed using one of the known", "compression formats (Unix compress, gzip or bzip2).", "</p>"});
        this.validParam_ = new BooleanParameter("validate");
        this.validParam_.setDefault(true);
        this.validParam_.setPrompt("Validate against VOTable DTD?");
        this.validParam_.setDescription(new String[]{"<p>Whether to validate the input document aganist", "the VOTable DTD.", "If true (the default), then as well as", "<code>votlint</code>'s own checks,", "it is validated against an appropriate version of the VOTable", "DTD which picks up such things as the presence of", "unknown elements and attributes, elements in the wrong place,", "and so on.", "Sometimes however, particularly when XML namespaces are", "involved, the validator can get confused and may produce", "a lot of spurious errors.  Setting this flag false prevents", "this validation step so that only <code>votlint</code>'s", "own checks are performed.", "In this case many violations of the VOTable standard", "concerning document structure will go unnoticed.", "</p>"});
        this.versionParam_ = new ChoiceParameter("version", (Object[])LintContext.VOT_VERSIONS);
        this.versionParam_.setNullPermitted(true);
        this.versionParam_.setPrompt("VOTable standard version");
        this.versionParam_.setDescription(new String[]{"<p>Selects the version of the VOTable standard which the input", "table is supposed to exemplify.", "Currently the version can be 1.0 or 1.1.", "The version may also be specified within the document", "using the \"version\" attribute of the document's VOTABLE", "element; if it is and it conflicts with the value specified", "by this flag, a warning is issued.", "</p>"});
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPrompt("File for output messages");
        this.outParam_.setUsage("<location>");
        this.outParam_.setDefault("-");
        this.outParam_.setDescription(new String[]{"<p>Destination file for output messages.", "May be a filename or \"-\" to indicate standard output.", "</p>"});
    }

    public String getPurpose() {
        return "Validates VOTable documents";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inParam_, this.validParam_, this.versionParam_, this.outParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        PrintStream out;
        String version = this.versionParam_.stringValue(env);
        boolean validate = this.validParam_.booleanValue(env);
        LintContext context = new LintContext(version);
        context.setValidating(validate);
        if (env instanceof TableEnvironment) {
            context.setDebug(((TableEnvironment)env).isDebug());
        }
        String sysid = this.inParam_.stringValue(env);
        InputStream in = this.inParam_.inputStreamValue(env);
        try {
            out = new PrintStream(this.outParam_.destinationValue(env).createStream());
        }
        catch (IOException e) {
            throw new UsageException("Can't open \"" + this.outParam_.stringValue(env) + "\" for output: " + e.getMessage(), (Throwable)e);
        }
        context.setOutput(out);
        return new VotLintExecutable(in, validate, context, sysid);
    }

    private class VotLintExecutable
    implements Executable {
        final InputStream baseIn_;
        final boolean validate_;
        final LintContext context_;
        final String sysid_;

        VotLintExecutable(InputStream in, boolean validate, LintContext context, String sysid) {
            this.baseIn_ = in;
            this.validate_ = validate;
            this.context_ = context;
            this.sysid_ = sysid;
        }

        public void execute() throws IOException, ExecutionException {
            InputStream in = new BufferedInputStream(this.baseIn_);
            if (this.validate_) {
                DoctypeInterpolator interp = new DoctypeInterpolator(this){
                    private final /* synthetic */ VotLintExecutable this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void message(String msg) {
                        this.this$1.context_.info(msg);
                    }
                };
                in = interp.getStreamWithDoctype((BufferedInputStream)in);
                String foundVers = interp.getVotableVersion();
                if (foundVers != null && this.context_.getVersion() == null) {
                    this.context_.setVersion(foundVers);
                }
            }
            InputSource sax = new InputSource(in);
            sax.setSystemId(this.sysid_);
            try {
                new Linter(this.context_).createParser(this.context_.isValidating()).parse(sax);
            }
            catch (SAXException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

