/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxIO;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

class ExistingNdxParameter
extends Parameter {
    private NdxIO ndxio = new NdxIO();
    private Ndx ndxvalue;
    private AccessMode accessMode = AccessMode.READ;

    public ExistingNdxParameter(String name) {
        super(name);
    }

    public void setAccessMode(AccessMode mode) {
        if (mode != AccessMode.READ && mode != AccessMode.UPDATE) {
            throw new IllegalArgumentException("Writable not allowed");
        }
        this.accessMode = mode;
    }

    public Ndx ndxValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.ndxvalue;
    }

    public void setValueFromString(Environment env, String stringval) throws TaskException {
        String loc = stringval;
        try {
            this.ndxvalue = this.ndxio.makeNdx(loc, this.accessMode);
        }
        catch (Exception e) {
            throw new ParameterValueException(this, "Failed to read NDX from " + loc, e);
        }
        if (this.ndxvalue == null) {
            throw new ParameterValueException((Parameter)this, "Unknown NDX type " + loc);
        }
        super.setValueFromString(env, stringval);
    }
}

