/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NdxConsumer;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndtools.TypeParameter;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;

class SetType
implements Task {
    private ExistingNdxParameter inpar = new ExistingNdxParameter("in");
    private NewNdxParameter outpar;
    private TypeParameter typepar;

    public SetType() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
        this.outpar = new NewNdxParameter("out");
        this.outpar.setPrompt("Output NDX");
        this.outpar.setPosition(2);
        this.typepar = new TypeParameter("type");
        this.typepar.setPrompt("New type");
        this.typepar.setPosition(3);
    }

    public String getPurpose() {
        return "Sets the numeric type of an NDX";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar, this.outpar, this.typepar};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        return new Typer(this.inpar.ndxValue(env), this.outpar.ndxConsumerValue(env), this.typepar.typeValue(env));
    }

    private class Typer
    implements Executable {
        final Ndx ndx1;
        final NdxConsumer ndxOut;
        final Type type;

        Typer(Ndx ndx1, NdxConsumer ndxOut, Type type) {
            this.ndx1 = ndx1;
            this.ndxOut = ndxOut;
            this.type = type;
        }

        public void execute() throws IOException {
            Requirements req = new Requirements(AccessMode.READ).setType(this.type);
            NDArray image = NDArrays.toRequiredArray(this.ndx1.getImage(), req);
            NDArray variance = null;
            if (this.ndx1.hasVariance()) {
                variance = NDArrays.toRequiredArray(this.ndx1.getVariance(), req);
            }
            NDArray quality = null;
            if (this.ndx1.hasQuality()) {
                quality = this.ndx1.getQuality();
            }
            DefaultMutableNdx ndx2 = new DefaultMutableNdx(this.ndx1);
            ndx2.setImage(image);
            ndx2.setVariance(variance);
            ndx2.setQuality(quality);
            this.ndxOut.consume(ndx2);
        }
    }
}

