/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.StatsValues;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;

class Stats
implements Task {
    private ExistingNdxParameter inpar = new ExistingNdxParameter("in");

    public Stats() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
    }

    public String getPurpose() {
        return "Calculates statistics for the pixels of an NDX";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        return new Statter(this.inpar.ndxValue(env), env.getOutputStream());
    }

    private class Statter
    implements Executable {
        final Ndx ndx;
        final PrintStream pstrm;

        Statter(Ndx ndx, PrintStream pstrm) {
            this.ndx = ndx;
            this.pstrm = pstrm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() throws IOException, ExecutionException {
            void var1_2;
            void var2_3;
            void var4_4;
            NDArray nda = null;
            try {
                String title = this.ndx.hasTitle() ? this.ndx.getTitle() : null;
                nda = Ndxs.getMaskedImage(this.ndx);
                long npix = nda.getShape().getNumPixels();
                StatsValues answers = new StatsValues(nda);
            }
            finally {
                if (nda != null) {
                    nda.close();
                }
            }
            float sum = (float)var4_4.total;
            float mean = (float)var4_4.mean;
            float stdev = (float)Math.sqrt(var4_4.variance);
            Number minval = var4_4.minValue;
            Number maxval = var4_4.maxValue;
            String minpos = NDShape.toString(var4_4.minPosition);
            String maxpos = NDShape.toString(var4_4.maxPosition);
            long ngood = var4_4.numGood;
            void nbad = var2_3 - ngood;
            float pcgood = (float)(100.0 * (double)ngood / (double)var2_3);
            float pcbad = (float)(100.0 * (double)nbad / (double)var2_3);
            this.pstrm.println("Title:   " + (String)var1_2);
            if (ngood > 0L) {
                this.pstrm.println("   Pixel sum              : " + sum);
                this.pstrm.println("   Pixel mean             : " + mean);
                this.pstrm.println("   Standard deviation     : " + stdev);
                this.pstrm.println("   Minimum pixel value    : " + minval);
                this.pstrm.println("      At pixel            : " + minpos);
                this.pstrm.println("   Maximum pixel value    : " + maxval);
                this.pstrm.println("      At pixel            : " + maxpos);
                this.pstrm.println("   Total number of pixels : " + (long)var2_3);
                this.pstrm.println("   Number of pixels used  : " + ngood + " (" + pcgood + "%)");
                if (nbad > 0L) {
                    this.pstrm.println("   No. of pixels excluded : " + (long)nbad + " (" + pcbad + "%)");
                }
            } else {
                this.pstrm.println("No good pixels");
            }
            this.pstrm.println();
        }
    }
}

