/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;

public class StatsValues {
    public final double total;
    public final double mean;
    public final double variance;
    public final long numGood;
    public final Number minValue;
    public final Number maxValue;
    public final long[] minPosition;
    public final long[] maxPosition;

    public StatsValues(NDArray nda) throws IOException {
        this(nda, new ChunkStepper(nda.getShape().getNumPixels()));
    }

    public StatsValues(NDArray nda, ChunkStepper stepper) throws IOException {
        long npix = nda.getShape().getNumPixels();
        if (stepper.getTotalLength() != nda.getShape().getNumPixels()) {
            throw new IllegalArgumentException("Wrong length stepper");
        }
        OrderedNDShape oshape = nda.getShape();
        Type type = nda.getType();
        long ngood = 0L;
        double sum = 0.0;
        double sum2 = 0.0;
        long minindex = 0L;
        long maxindex = 0L;
        long index = 0L;
        double dmin = type.maximumValue();
        double dmax = type.minimumValue();
        ArrayAccess acc = nda.getAccess();
        Object buf = type.newArray(stepper.getSize());
        BadHandler bh = nda.getBadHandler();
        BadHandler.ArrayHandler ah = bh.arrayHandler(buf);
        while (stepper.hasNext()) {
            Object[] buffer;
            int leng = stepper.getSize();
            long base = stepper.getBase();
            acc.read(buf, 0, leng);
            if (type == Type.BYTE) {
                buffer = (byte[])buf;
                byte min = (byte)dmin;
                byte max = (byte)dmax;
                for (int i = 0; i < leng; ++i) {
                    if (ah.isBad(i)) continue;
                    byte val = buffer[i];
                    ++ngood;
                    sum += (double)val;
                    sum2 += (double)(val * val);
                    if (val > max) {
                        max = val;
                        maxindex = base + (long)i;
                    }
                    if (val >= min) continue;
                    min = val;
                    minindex = base + (long)i;
                }
                dmin = min;
                dmax = max;
            } else if (type == Type.SHORT) {
                buffer = (short[])buf;
                short min = (short)dmin;
                short max = (short)dmax;
                for (int i = 0; i < leng; ++i) {
                    if (ah.isBad(i)) continue;
                    short val = buffer[i];
                    ++ngood;
                    sum += (double)val;
                    sum2 += (double)(val * val);
                    if (val > max) {
                        max = val;
                        maxindex = base + (long)i;
                    }
                    if (val >= min) continue;
                    min = val;
                    minindex = base + (long)i;
                }
                dmin = min;
                dmax = max;
            } else if (type == Type.INT) {
                buffer = (int[])buf;
                int min = (int)dmin;
                int max = (int)dmax;
                for (int i = 0; i < leng; ++i) {
                    if (ah.isBad(i)) continue;
                    int val = buffer[i];
                    ++ngood;
                    sum += (double)val;
                    sum2 += (double)(val * val);
                    if (val > max) {
                        max = val;
                        maxindex = base + (long)i;
                    }
                    if (val >= min) continue;
                    min = val;
                    minindex = base + (long)i;
                }
                dmin = min;
                dmax = max;
            } else if (type == Type.FLOAT) {
                buffer = (float[])buf;
                float min = (float)dmin;
                float max = (float)dmax;
                for (int i = 0; i < leng; ++i) {
                    if (ah.isBad(i)) continue;
                    byte val = buffer[i];
                    ++ngood;
                    sum += (double)val;
                    sum2 += (double)(val * val);
                    if (val > max) {
                        max = val;
                        maxindex = base + (long)i;
                    }
                    if (!(val < min)) continue;
                    min = val;
                    minindex = base + (long)i;
                }
                dmin = min;
                dmax = max;
            } else if (type == Type.DOUBLE) {
                buffer = (double[])buf;
                double min = dmin;
                double max = dmax;
                for (int i = 0; i < leng; ++i) {
                    if (ah.isBad(i)) continue;
                    byte val = buffer[i];
                    ++ngood;
                    sum += val;
                    sum2 += val * val;
                    if (val > max) {
                        max = val;
                        maxindex = base + (long)i;
                    }
                    if (!(val < min)) continue;
                    min = val;
                    minindex = base + (long)i;
                }
                dmin = min;
                dmax = max;
            }
            stepper.next();
        }
        acc.close();
        this.total = sum;
        this.mean = sum / (double)ngood;
        this.variance = sum2 / (double)ngood - this.mean * this.mean;
        this.minPosition = oshape.offsetToPosition(minindex);
        this.maxPosition = oshape.offsetToPosition(maxindex);
        this.numGood = ngood;
        if (dmin > dmax) {
            this.minValue = null;
            this.maxValue = null;
        } else if (type == Type.BYTE) {
            this.minValue = new Byte((byte)dmin);
            this.maxValue = new Byte((byte)dmax);
        } else if (type == Type.SHORT) {
            this.minValue = new Short((short)dmin);
            this.maxValue = new Short((short)dmax);
        } else if (type == Type.INT) {
            this.minValue = new Integer((int)dmin);
            this.maxValue = new Integer((int)dmax);
        } else if (type == Type.FLOAT) {
            this.minValue = new Float((float)dmin);
            this.maxValue = new Float((float)dmax);
        } else if (type == Type.DOUBLE) {
            this.minValue = new Double(dmin);
            this.maxValue = new Double(dmax);
        } else {
            throw new AssertionError();
        }
    }
}

