/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NdxConsumer;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndtools.ShapeParameter;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;

class Window
implements Task {
    ExistingNdxParameter inpar = new ExistingNdxParameter("in");
    NewNdxParameter outpar;
    ShapeParameter shapepar;

    public Window() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
        this.outpar = new NewNdxParameter("out");
        this.outpar.setPrompt("Output NDX");
        this.outpar.setPosition(2);
        this.shapepar = new ShapeParameter("shape");
        this.shapepar.setPrompt("New shape specification");
        this.shapepar.setPosition(3);
    }

    public String getPurpose() {
        return "Creates a rectangular window on an existing NDX";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar, this.outpar, this.shapepar};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        return new Windower(this.inpar.ndxValue(env), this.outpar.ndxConsumerValue(env), this.shapepar.shapeValue(env));
    }

    private class Windower
    implements Executable {
        final Ndx ndx1;
        final NdxConsumer ndxOut;
        final NDShape shape;

        Windower(Ndx ndx1, NdxConsumer ndxOut, NDShape shape) {
            this.ndx1 = ndx1;
            this.ndxOut = ndxOut;
            this.shape = shape;
        }

        public void execute() throws IOException {
            Requirements req = new Requirements(AccessMode.READ).setWindow(this.shape);
            NDArray im = NDArrays.toRequiredArray(this.ndx1.getImage(), req);
            NDArray var = null;
            if (this.ndx1.hasVariance()) {
                var = NDArrays.toRequiredArray(this.ndx1.getVariance(), req);
            }
            NDArray qual = null;
            if (this.ndx1.hasQuality()) {
                qual = NDArrays.toRequiredArray(this.ndx1.getQuality(), req);
            }
            DefaultMutableNdx ndx2 = new DefaultMutableNdx(im);
            ndx2.setVariance(var);
            ndx2.setQuality(qual);
            this.ndxOut.consume(ndx2);
        }
    }
}

