/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.lang.reflect.Array;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;

public class ArrayArrayImpl
implements ArrayImpl {
    private Object data;
    private OrderedNDShape oshape;
    private Type type;
    private Number badValue;

    public ArrayArrayImpl(Object data, OrderedNDShape oshape, Number badValue) {
        this.data = data;
        this.oshape = oshape;
        this.badValue = badValue;
        this.type = Type.getType(data.getClass().getComponentType());
        if (oshape.getNumPixels() != (long)Array.getLength(data)) {
            throw new IllegalArgumentException("Primitive array has wrong number of elements " + Array.getLength(data) + " for shape " + oshape);
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Unsupported primitive numeric element array of type " + data.getClass());
        }
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isRandom() {
        return true;
    }

    public boolean multipleAccess() {
        return true;
    }

    public void open() {
    }

    public boolean canMap() {
        return true;
    }

    public Object getMapped() {
        return this.data;
    }

    public void close() {
    }

    public AccessImpl getAccess() {
        return new AccessImpl(){
            private int off = 0;

            public void setOffset(long off) {
                this.off = (int)off;
            }

            public void read(Object buf, int start, int size) {
                System.arraycopy(ArrayArrayImpl.this.data, this.off, buf, start, size);
                this.off += size;
            }

            public void write(Object buf, int start, int size) {
                System.arraycopy(buf, start, ArrayArrayImpl.this.data, this.off, size);
                this.off += size;
            }

            public void close() {
            }
        };
    }
}

