/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.Converter;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.WrapperArrayImpl;

public class ConvertArrayImpl
extends WrapperArrayImpl {
    private final NDArray nda;
    private final Converter conv;
    private final Type type1;
    private final Type type2;
    private static final int BUFSIZE = ChunkStepper.defaultChunkSize;

    public ConvertArrayImpl(NDArray nda, Converter conv) {
        super(nda);
        this.nda = nda;
        this.conv = conv;
        if (conv.getType1() != nda.getType()) {
            throw new IllegalArgumentException("Converter type 1 (" + conv.getType1() + ") does not match " + "NDArray type (" + nda.getType() + ")");
        }
        this.type1 = conv.getType1();
        this.type2 = conv.getType2();
    }

    public Type getType() {
        return this.type2;
    }

    public Number getBadValue() {
        return this.conv.getBadHandler2().getBadValue();
    }

    public AccessImpl getAccess() throws IOException {
        return new AccessImpl(){
            private ArrayAccess acc;
            private Object standardBuffer1;
            {
                this.acc = ConvertArrayImpl.this.nda.getAccess();
                this.standardBuffer1 = ConvertArrayImpl.this.type1.newArray(BUFSIZE);
            }

            public void setOffset(long off) throws IOException {
                this.acc.setOffset(off);
            }

            public void read(Object buffer2, int start, int size) throws IOException {
                Object buffer1 = this.getBuffer1(size);
                this.acc.read(buffer1, 0, size);
                ConvertArrayImpl.this.conv.convert12(buffer1, 0, buffer2, start, size);
            }

            public void write(Object buffer2, int start, int size) throws IOException {
                Object buffer1 = this.getBuffer1(size);
                ConvertArrayImpl.this.conv.convert21(buffer2, start, buffer1, 0, size);
                this.acc.write(buffer1, 0, size);
            }

            public void close() throws IOException {
                this.acc.close();
            }

            private final Object getBuffer1(int size) {
                return size <= BUFSIZE ? this.standardBuffer1 : ConvertArrayImpl.this.type1.newArray(size);
            }
        };
    }
}

