/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import java.net.URL;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.ScratchNDArray;

public class CopyNDArray
extends ScratchNDArray {
    private NDArray nda;
    private final boolean copyOnClose;
    private final URL url;

    public CopyNDArray(NDArray nda, AccessMode mode) throws IOException {
        super(nda);
        this.url = nda.getURL();
        if (mode == null) {
            if (nda.isReadable() && nda.isWritable()) {
                mode = AccessMode.UPDATE;
            } else if (nda.isReadable()) {
                mode = AccessMode.READ;
            } else if (nda.isWritable()) {
                mode = AccessMode.WRITE;
            } else {
                throw new IllegalArgumentException("NDArray has neither read nor write access");
            }
        }
        if (mode.isReadable()) {
            NDArrays.copy(nda, this);
        }
        if (mode.isWritable()) {
            this.copyOnClose = true;
        } else {
            this.copyOnClose = false;
            nda = null;
        }
        this.nda = nda;
    }

    public URL getURL() {
        return this.url;
    }

    public void close() throws IOException {
        if (this.nda != null) {
            if (this.copyOnClose) {
                NDArrays.copy(this, this.nda);
            }
            this.nda.close();
            this.nda = null;
        }
    }
}

