/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;

public class DeterministicArrayImpl
implements ArrayImpl {
    private final Type type;
    private final OrderedNDShape shape;
    private final Number badValue;
    private final BadHandler badHandler;
    static /* synthetic */ Class class$uk$ac$starlink$array$DeterministicArrayImpl;

    public DeterministicArrayImpl(NDShape shape, Type type) {
        this.type = type;
        this.shape = shape instanceof OrderedNDShape ? (OrderedNDShape)shape : new OrderedNDShape(shape, Order.COLUMN_MAJOR);
        this.badValue = type.defaultBadValue();
        this.badHandler = BadHandler.getHandler(type, this.badValue);
    }

    protected double offsetToValue(long off) {
        return (off + 5L) % 23L == 0L ? Double.NaN : (double)off;
    }

    public OrderedNDShape getShape() {
        return this.shape;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isRandom() {
        return true;
    }

    public boolean canMap() {
        return false;
    }

    public Object getMapped() {
        return null;
    }

    public boolean multipleAccess() {
        return true;
    }

    public void open() {
    }

    public void close() {
    }

    public AccessImpl getAccess() {
        return new AccessImpl(){
            private long offset = 0L;
            static final /* synthetic */ boolean $assertionsDisabled;

            public void setOffset(long off) {
                this.offset = off;
            }

            public void read(Object buffer, int start, int size) {
                while (size-- > 0) {
                    double val;
                    if (Double.isNaN(val = DeterministicArrayImpl.this.offsetToValue(this.offset++))) {
                        DeterministicArrayImpl.this.badHandler.putBad(buffer, start);
                    } else if (DeterministicArrayImpl.this.type == Type.BYTE) {
                        ((byte[])buffer)[start] = (byte)val;
                    } else if (DeterministicArrayImpl.this.type == Type.SHORT) {
                        ((short[])buffer)[start] = (short)val;
                    } else if (DeterministicArrayImpl.this.type == Type.INT) {
                        ((int[])buffer)[start] = (int)val;
                    } else if (DeterministicArrayImpl.this.type == Type.FLOAT) {
                        ((float[])buffer)[start] = (float)val;
                    } else if (DeterministicArrayImpl.this.type == Type.DOUBLE) {
                        ((double[])buffer)[start] = val;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    ++start;
                }
            }

            public void write(Object buffer, int start, int size) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public boolean isMapped() {
                return false;
            }

            public Object getMapped() {
                throw new AssertionError();
            }

            public void close() {
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$array$DeterministicArrayImpl == null ? (class$uk$ac$starlink$array$DeterministicArrayImpl = DeterministicArrayImpl.class$("uk.ac.starlink.array.DeterministicArrayImpl")) : class$uk$ac$starlink$array$DeterministicArrayImpl).desiredAssertionStatus();
            }
        };
    }
}

