/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.util.NoSuchElementException;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;

class IntersectionRowIterator {
    private OrderedNDShape aShape;
    private OrderedNDShape bShape;
    private OrderedNDShape inter;
    private boolean fitsLike;
    private int ndim;
    private long[] interDims;
    private long[] aDims;
    private long[] bDims;
    private int dim0;
    private int ndim1;
    private long[] interPos;
    private long aOff;
    private long bOff;
    private long nleft;

    public IntersectionRowIterator(NDShape shapeA, NDShape shapeB, Order order) {
        this.aShape = new OrderedNDShape(shapeA, order);
        this.bShape = new OrderedNDShape(shapeB, order);
        this.fitsLike = order.isFitsLike();
        NDShape intersect = shapeA.intersection(shapeB);
        if (intersect != null) {
            this.inter = new OrderedNDShape(intersect, order);
            this.ndim = shapeA.getNumDims();
            this.ndim1 = this.ndim - 1;
            this.dim0 = this.fitsLike ? 0 : this.ndim1;
            this.aDims = this.aShape.getDims();
            this.bDims = this.bShape.getDims();
            this.interDims = this.inter.getDims();
            this.nleft = 1L;
            for (int j = 0; j < this.ndim1; ++j) {
                int i = this.fitsLike ? j + 1 : this.ndim1 - 1 - j;
                this.nleft *= this.interDims[i];
            }
            this.interPos = new long[this.ndim];
            long[] absolutePos = this.inter.offsetToPosition(0L);
            this.aOff = this.aShape.positionToOffset(absolutePos);
            this.bOff = this.bShape.positionToOffset(absolutePos);
        } else {
            this.nleft = 0L;
            this.aOff = -1L;
            this.bOff = -1L;
            this.inter = null;
        }
    }

    public boolean hasNext() {
        return this.nleft > 0L;
    }

    public void next() {
        long aStride = this.aDims[this.dim0];
        long bStride = this.bDims[this.dim0];
        for (int j = 0; j < this.ndim1; ++j) {
            int i = this.fitsLike ? j + 1 : this.ndim1 - 1 - j;
            this.aOff += aStride;
            this.bOff += bStride;
            int n = i;
            this.interPos[n] = this.interPos[n] + 1L;
            if (this.interPos[n] < this.interDims[i]) break;
            this.interPos[i] = 0L;
            this.aOff -= this.interDims[i] * aStride;
            this.bOff -= this.interDims[i] * bStride;
            aStride *= this.aDims[i];
            bStride *= this.bDims[i];
        }
        if (--this.nleft < 0L) {
            throw new NoSuchElementException();
        }
    }

    public long getOffsetA() {
        return this.aOff;
    }

    public long getOffsetB() {
        return this.bOff;
    }

    public OrderedNDShape getIntersection() {
        return this.inter;
    }

    public long getRowLength() {
        return this.interDims[this.dim0];
    }
}

