/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayBuilder;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.util.URLUtils;

public class NDArrayFactory {
    private List builders = new ArrayList(2);
    private static Logger logger = Logger.getLogger("uk.ac.starlink.array");

    public NDArrayFactory() {
        ArrayBuilder builder;
        Method meth;
        Class<?> clazz;
        Class[] noParams = new Class[]{};
        Object[] noArgs = new Object[]{};
        String className = "uk.ac.starlink.hds.HDSArrayBuilder";
        try {
            this.getClass();
            clazz = Class.forName(className);
            meth = clazz.getMethod("getInstance", noParams);
            builder = (ArrayBuilder)meth.invoke(null, noArgs);
            this.builders.add(builder);
            logger.config(className + " registered");
        }
        catch (ClassNotFoundException e) {
            logger.config(className + " not found - can't register");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof LinkageError) {
                try {
                    this.getClass();
                    Class.forName("uk.ac.starlink.hds.HDSPackage").getMethod("isAvailable", noParams).invoke(null, noArgs);
                }
                catch (Exception e2) {
                    logger.config(className + " " + e2 + " - can't register");
                }
            } else {
                logger.config(className + " " + e + " - can't register");
            }
        }
        catch (Exception e) {
            logger.config(className + e + " - can't register");
        }
        className = "uk.ac.starlink.fits.FitsArrayBuilder";
        try {
            this.getClass();
            clazz = Class.forName(className);
            meth = clazz.getMethod("getInstance", noParams);
            builder = (ArrayBuilder)meth.invoke(null, noArgs);
            this.builders.add(builder);
            logger.config(className + " registered");
        }
        catch (ClassNotFoundException e) {
            logger.config(className + " class not found - can't register");
        }
        catch (Exception e) {
            logger.config("Failed to register " + className + ": - " + e);
        }
    }

    public List getBuilders() {
        return this.builders;
    }

    public void setBuilders(ArrayBuilder[] builders) {
        this.builders = new ArrayList<ArrayBuilder>(Arrays.asList(builders));
    }

    public NDArray makeNDArray(URL url, AccessMode mode) throws IOException {
        Iterator it = this.builders.iterator();
        while (it.hasNext()) {
            ArrayBuilder builder = (ArrayBuilder)it.next();
            NDArray nda = builder.makeNDArray(url, mode);
            if (nda == null) continue;
            return nda;
        }
        return null;
    }

    public NDArray makeNewNDArray(URL url, NDShape shape, Type type, BadHandler bh) throws IOException {
        if (bh != null && bh.getType() != type) {
            throw new IllegalArgumentException("Bad handler type " + bh.getType() + " does not match specified type " + type);
        }
        Iterator it = this.builders.iterator();
        while (it.hasNext()) {
            ArrayBuilder builder = (ArrayBuilder)it.next();
            NDArray nda = builder.makeNewNDArray(url, shape, type, bh);
            if (nda == null) continue;
            return nda;
        }
        return null;
    }

    public NDArray makeNewNDArray(URL url, NDArray template) throws IOException {
        return this.makeNewNDArray(url, (NDShape)template.getShape(), template.getType(), template.getBadHandler());
    }

    public NDArray makeNDArray(String location, AccessMode mode) throws IOException {
        return this.makeNDArray(NDArrayFactory.getUrl(location), mode);
    }

    public NDArray makeNewNDArray(String location, NDShape shape, Type type, BadHandler bh) throws IOException {
        return this.makeNewNDArray(NDArrayFactory.getUrl(location), shape, type, bh);
    }

    public NDArray makeNewNDArray(String location, NDArray template) throws IOException {
        return this.makeNewNDArray(NDArrayFactory.getUrl(location), template);
    }

    private static URL getUrl(String location) {
        return URLUtils.makeURL(location);
    }
}

