/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.util.Arrays;

public class NDShape
implements Cloneable {
    public static final long DEFAULT_ORIGIN = 1L;
    private final long[] origin;
    private final long[] dims;
    private final int ndim;
    private final long[] limits;
    private final long[] ubnds;
    private final long npix;

    public NDShape(long[] origin, long[] dims) {
        this.origin = (long[])origin.clone();
        this.dims = (long[])dims.clone();
        NDShape.validate(origin, dims);
        this.ndim = dims.length;
        this.limits = new long[this.ndim];
        this.ubnds = new long[this.ndim];
        long np = 1L;
        for (int i = 0; i < this.ndim; ++i) {
            this.limits[i] = origin[i] + dims[i];
            this.ubnds[i] = this.limits[i] - 1L;
            np *= dims[i];
        }
        this.npix = np;
    }

    public NDShape(long[] origin, int[] dims) {
        this(origin, NDShape.intsToLongs(dims));
    }

    public NDShape(long[] dims) {
        this(NDShape.defaultOrigin(dims.length), dims);
    }

    public NDShape(int[] dims) {
        this(NDShape.defaultOrigin(dims.length), dims);
    }

    public NDShape(NDShape shape) {
        this(shape.getOrigin(), shape.getDims());
    }

    public long[] getOrigin() {
        return (long[])this.origin.clone();
    }

    public long[] getDims() {
        return (long[])this.dims.clone();
    }

    public long[] getLimits() {
        return (long[])this.limits.clone();
    }

    public long[] getUpperBounds() {
        return (long[])this.ubnds.clone();
    }

    public int getNumDims() {
        return this.ndim;
    }

    public long getNumPixels() {
        return this.npix;
    }

    public NDShape intersection(NDShape other) {
        if (other.getNumDims() != this.getNumDims()) {
            throw new IllegalArgumentException("Dimensionality mismatch between" + other + " and " + this);
        }
        long[] iOrigin = new long[this.ndim];
        long[] iDims = new long[this.ndim];
        for (int i = 0; i < this.ndim; ++i) {
            long otherLimit = other.origin[i] + other.dims[i];
            iOrigin[i] = Math.max(this.origin[i], other.origin[i]);
            long iLimit = Math.min(this.limits[i], otherLimit);
            iDims[i] = iLimit - iOrigin[i];
            if (iDims[i] > 0L) continue;
            return null;
        }
        return new NDShape(iOrigin, iDims);
    }

    public NDShape union(NDShape other) {
        if (other.getNumDims() != this.getNumDims()) {
            throw new IllegalArgumentException("Dimensionality mismatch between" + other + " and " + this);
        }
        long[] uOrigin = new long[this.ndim];
        long[] uDims = new long[this.ndim];
        for (int i = 0; i < this.ndim; ++i) {
            long otherLimit = other.origin[i] + other.dims[i];
            uOrigin[i] = Math.min(this.origin[i], other.origin[i]);
            long uLimit = Math.max(this.limits[i], otherLimit);
            uDims[i] = uLimit - uOrigin[i];
        }
        return new NDShape(uOrigin, uDims);
    }

    public boolean within(long[] pos) {
        for (int i = 0; i < this.ndim; ++i) {
            if (pos[i] >= this.origin[i] && pos[i] < this.limits[i]) continue;
            return false;
        }
        return true;
    }

    public boolean sameShape(NDShape other) {
        return other != null && Arrays.equals(other.getOrigin(), this.getOrigin()) && Arrays.equals(other.getDims(), this.getDims());
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            NDShape o = (NDShape)other;
            return Arrays.equals(o.origin, this.origin) && Arrays.equals(o.dims, this.dims);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        for (int i = 0; i < this.ndim; ++i) {
            hash = hash * 23 + (int)this.origin[i];
            hash = hash * 23 + (int)this.dims[i];
        }
        return hash;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return NDShape.toString(this);
    }

    public static String toString(NDShape shape) {
        StringBuffer buf = new StringBuffer("(");
        int ndim = shape.ndim;
        for (int i = 0; i < ndim; ++i) {
            long o = shape.origin[i];
            if (o == Long.MIN_VALUE) {
                buf.append('*');
            } else {
                buf.append(shape.origin[i]).append('+').append(shape.dims[i]);
            }
            buf.append(i < ndim - 1 ? (char)',' : ')');
        }
        return buf.toString();
    }

    public static String toString(long[] pos) {
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < pos.length; ++i) {
            long val;
            if (i > 0) {
                buf.append(',');
            }
            if ((val = pos[i]) != Long.MIN_VALUE) {
                buf.append(val);
                continue;
            }
            buf.append('*');
        }
        buf.append(')');
        return buf.toString();
    }

    public static NDShape fromString(String str) {
        String[] specs = str.split(" *, *", -1);
        int ndim = specs.length;
        long[] origin = new long[ndim];
        long[] dims = new long[ndim];
        for (int i = 0; i < ndim; ++i) {
            String spec = specs[i];
            if (spec.indexOf(58) >= 0) {
                String[] lu = spec.split(" *: *", 2);
                origin[i] = Integer.parseInt(lu[0]);
                dims[i] = (long)Integer.parseInt(lu[1]) - origin[i] + 1L;
                continue;
            }
            if (spec.indexOf(43) >= 0) {
                String[] od = spec.split(" *\\+ *", 2);
                origin[i] = Integer.parseInt(od[0]);
                dims[i] = Integer.parseInt(od[1]);
                continue;
            }
            throw new IllegalArgumentException("Bad shape format " + str);
        }
        return new NDShape(origin, dims);
    }

    public static long[] intsToLongs(int[] iarray) {
        long[] larray = new long[iarray.length];
        for (int i = 0; i < iarray.length; ++i) {
            larray[i] = iarray[i];
        }
        return larray;
    }

    public static int[] longsToInts(long[] larray) {
        int[] iarray = new int[larray.length];
        for (int i = 0; i < larray.length; ++i) {
            if (larray[i] < Integer.MIN_VALUE || larray[i] > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Long value " + larray[i] + " out of integer range");
            }
            iarray[i] = (int)larray[i];
        }
        return iarray;
    }

    static long[] defaultOrigin(int ndim) {
        long[] origin = new long[ndim];
        Arrays.fill(origin, 1L);
        return origin;
    }

    private static void validate(long[] origin, long[] dims) {
        if (origin.length != dims.length) {
            throw new IllegalArgumentException("Origin and dimsension arrays have different lengths");
        }
        if (dims.length == 0) {
            throw new IllegalArgumentException("Zero-dimensional shape not permitted");
        }
        for (int i = 0; i < origin.length; ++i) {
            if (dims[i] >= 1L) continue;
            throw new IllegalArgumentException("Dimensions less than 1 not allowed " + NDShape.toString(dims));
        }
    }
}

