/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;

public class OrderedNDShape
extends NDShape
implements Cloneable {
    private final long[] origin;
    private final long[] dims;
    private final Order order;
    private final int ndim;
    private final long[] limits;
    private final long npix;
    private final boolean hasFitsOrder;

    public OrderedNDShape(long[] origin, long[] dims, Order order) {
        super(origin, dims);
        this.origin = (long[])origin.clone();
        this.dims = (long[])dims.clone();
        this.order = order == null ? Order.COLUMN_MAJOR : order;
        this.hasFitsOrder = this.order.isFitsLike();
        this.ndim = dims.length;
        long np = 1L;
        this.limits = new long[this.ndim];
        for (int i = 0; i < this.ndim; ++i) {
            this.limits[i] = origin[i] + dims[i];
            np *= dims[i];
        }
        this.npix = np;
    }

    public OrderedNDShape(long[] dims, Order order) {
        this(OrderedNDShape.defaultOrigin(dims.length), dims, order);
    }

    public OrderedNDShape(NDShape shape, Order order) {
        this(shape.getOrigin(), shape.getDims(), order);
    }

    public OrderedNDShape(NDShape shape) {
        this(shape, shape instanceof OrderedNDShape ? ((OrderedNDShape)shape).getOrder() : null);
    }

    public Order getOrder() {
        return this.order;
    }

    public Iterator pixelIterator(final long start, final long length) {
        if (start < 0L || length < 0L || start + length > this.npix) {
            throw new IllegalArgumentException();
        }
        return new Iterator(){
            private long[] pos;
            private long nleft;
            {
                if (start == 0L) {
                    this.pos = new long[OrderedNDShape.this.ndim];
                    for (int i = 0; i < OrderedNDShape.this.ndim; ++i) {
                        this.pos[i] = OrderedNDShape.this.limits[i] - 1L;
                    }
                } else {
                    this.pos = OrderedNDShape.this.offsetToPosition(start - 1L);
                }
                this.nleft = length;
            }

            public boolean hasNext() {
                return this.nleft > 0L;
            }

            public Object next() {
                if (this.nleft-- > 0L) {
                    for (int j = 0; j < OrderedNDShape.this.ndim; ++j) {
                        int i;
                        int n = i = OrderedNDShape.this.hasFitsOrder ? j : OrderedNDShape.this.ndim - 1 - j;
                        this.pos[n] = this.pos[n] + 1L;
                        if (this.pos[n] < OrderedNDShape.this.limits[i]) break;
                        this.pos[i] = OrderedNDShape.this.origin[i];
                    }
                    return this.pos;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator pixelIterator() {
        return this.pixelIterator(0L, this.npix);
    }

    public long positionToOffset(long[] pos) {
        boolean hasFitsOrder = this.order.isFitsLike();
        long offset = 0L;
        long step = 1L;
        for (int j = 0; j < this.ndim; ++j) {
            int i = hasFitsOrder ? j : this.ndim - 1 - j;
            long c = pos[i];
            if (c < this.origin[i] || c >= this.limits[i]) {
                throw new IndexOutOfBoundsException();
            }
            offset += (c - this.origin[i]) * step;
            step *= this.dims[i];
        }
        return offset;
    }

    public long[] offsetToPosition(long offset) {
        boolean hasFitsOrder = this.order.isFitsLike();
        if (offset < 0L || offset >= this.npix) {
            throw new IndexOutOfBoundsException("Offset " + offset + " out of range 0.." + this.npix);
        }
        long[] p = (long[])this.origin.clone();
        for (int k = 0; k < this.ndim; ++k) {
            int i;
            int n = i = hasFitsOrder ? k : this.ndim - 1 - k;
            p[n] = p[n] + offset % this.dims[i];
            offset /= this.dims[i];
        }
        return p;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean sameSequence(OrderedNDShape other) {
        return Arrays.equals(other.getOrigin(), this.getOrigin()) && Arrays.equals(other.getDims(), this.getDims()) && (other.getOrder() == this.getOrder() || this.ndim == 1);
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            OrderedNDShape o = (OrderedNDShape)other;
            return Arrays.equals(o.origin, this.origin) && Arrays.equals(o.dims, this.dims) && this.order.equals(o.getOrder());
        }
        return false;
    }

    public int hashCode() {
        int hash = this.order.hashCode();
        for (int i = 0; i < this.ndim; ++i) {
            hash = hash * 23 + (int)this.origin[i];
            hash = hash * 23 + (int)this.dims[i];
        }
        return hash;
    }

    public String toString() {
        return super.toString() + ":" + this.order;
    }
}

