/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;

public class Requirements
implements Cloneable {
    private Type type;
    private NDShape window;
    private Order order;
    private BadHandler badHandler;
    private boolean random;
    private AccessMode mode;

    public Requirements() {
        this(null);
    }

    public Requirements(AccessMode mode) {
        this.setMode(mode);
    }

    public Type getType() {
        return this.type;
    }

    public Requirements setType(Type type) {
        this.type = type;
        if (this.badHandler != null && this.badHandler.getType() != type) {
            this.setBadHandler(null);
        }
        return this;
    }

    public NDShape getWindow() {
        return this.window;
    }

    public Requirements setWindow(NDShape window) {
        this.window = new NDShape(window);
        return this;
    }

    public Order getOrder() {
        return this.order;
    }

    public Requirements setOrder(Order order) {
        this.order = order;
        return this;
    }

    public Requirements setShape(OrderedNDShape oshape) {
        this.setWindow(oshape);
        this.setOrder(oshape != null ? oshape.getOrder() : null);
        return this;
    }

    public BadHandler getBadHandler() {
        return this.badHandler;
    }

    public Requirements setBadHandler(BadHandler handler) {
        if (this.type == null && handler != null) {
            throw new IllegalStateException("Cannot set BadHandler without set Type");
        }
        if (handler != null && handler.getType() != this.type) {
            throw new IllegalArgumentException("BadHandler type " + handler.getType() + " is inconsistent with Requirements type " + this.type);
        }
        this.badHandler = handler;
        return this;
    }

    public Requirements setBadValue(Number badValue) {
        if (this.type == null && badValue != null) {
            throw new IllegalStateException("Cannot set bad value without set Type");
        }
        BadHandler handler = BadHandler.getHandler(this.type, badValue);
        this.setBadHandler(handler);
        return this;
    }

    public boolean getRandom() {
        return this.random;
    }

    public Requirements setRandom(boolean random) {
        this.random = random;
        return this;
    }

    public AccessMode getMode() {
        return this.mode;
    }

    public Requirements setMode(AccessMode mode) {
        this.mode = mode;
        return this;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.type != null) {
            buf.append(" type=" + this.type);
        }
        if (this.window != null) {
            buf.append(" window=" + NDShape.toString(this.window));
        }
        if (this.order != null) {
            buf.append(" order=" + this.order);
        }
        if (this.badHandler != null) {
            buf.append(" badHandler=" + this.badHandler);
        }
        if (this.random) {
            buf.append(" random=true");
        }
        if (this.mode != null) {
            buf.append(" mode=" + this.mode);
        }
        if (buf.length() == 0) {
            buf.append(" <no requirements>");
        }
        return "Requirements: " + buf.toString();
    }
}

