/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ConvertWorker;
import uk.ac.starlink.array.Converter;
import uk.ac.starlink.array.Function;
import uk.ac.starlink.array.Type;

public class TypeConverter
implements Converter {
    private final Type type1;
    private final Type type2;
    private final BadHandler badHandler1;
    private final BadHandler badHandler2;
    private final ConvertWorker worker12;
    private final ConvertWorker worker21;

    public TypeConverter(Type type1, BadHandler handler1, Type type2, BadHandler handler2, final Function func) {
        ConvertWorker.Mapper mapper21;
        ConvertWorker.Mapper mapper12;
        this.type1 = type1;
        this.type2 = type2;
        this.badHandler1 = handler1;
        this.badHandler2 = handler2;
        if (func == null) {
            mapper12 = null;
            mapper21 = null;
        } else {
            mapper12 = new ConvertWorker.Mapper(){

                public final double func(double x) {
                    return func.forward(x);
                }
            };
            mapper21 = new ConvertWorker.Mapper(){

                public final double func(double x) {
                    return func.inverse(x);
                }
            };
        }
        this.worker12 = ConvertWorker.makeWorker(type1, handler1, type2, handler2, mapper12);
        this.worker21 = ConvertWorker.makeWorker(type2, handler2, type1, handler1, mapper21);
    }

    public TypeConverter(Type type1, BadHandler handler1, Type type2, BadHandler handler2) {
        this(type1, handler1, type2, handler2, null);
    }

    public Type getType1() {
        return this.type1;
    }

    public Type getType2() {
        return this.type2;
    }

    public BadHandler getBadHandler1() {
        return this.badHandler1;
    }

    public BadHandler getBadHandler2() {
        return this.badHandler2;
    }

    public boolean isUnit12() {
        return this.worker12.isUnit();
    }

    public boolean isUnit21() {
        return this.worker21.isUnit();
    }

    public void convert12(Object src1, int srcPos, Object dest2, int destPos, int length) {
        this.worker12.convert(src1, srcPos, dest2, destPos, length);
    }

    public void convert21(Object src2, int srcPos, Object dest1, int destPos, int length) {
        this.worker21.convert(src2, srcPos, dest1, destPos, length);
    }
}

