/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ivoa.registry.search.ParseException;
import net.ivoa.registry.search.SimpleCharStream;
import net.ivoa.registry.search.Token;
import net.ivoa.registry.search.Where2DOMConstants;
import net.ivoa.registry.search.Where2DOMTokenManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Where2DOM
implements Where2DOMConstants {
    private boolean defineSTCR = false;
    private boolean defineSTCC = false;
    public static final String ADQL_NS = "http://www.ivoa.net/xml/ADQL/v1.0";
    public static final String ADQL_PREFIX = "ad";
    public static final String STCR_NS = "http://www.ivoa.net/xml/STC/STCregion/v1.10";
    public static final String STCR_PREFIX = "reg";
    public static final String STCC_NS = "http://www.ivoa.net/xml/STC/STCcoords/v1.10";
    public static final String STCC_PREFIX = "stc";
    protected Document doc = null;
    protected Node parent = null;
    protected int indent = -1;
    protected short nsmode = 0;
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final short MODE_ALWAYS_QUALIFIED = 0;
    public static final short MODE_DEFAULT_NS = 1;
    protected static final short MODE_COUNT = 2;
    public Where2DOMTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws TransformerException {
        Where2DOM p = null;
        if (args.length < 1) {
            p = new Where2DOM(System.in);
        } else {
            try {
                p = new Where2DOM(new DataInputStream(new FileInputStream(args[0])));
            }
            catch (FileNotFoundException e) {
                p = new Where2DOM(System.in);
            }
        }
        try {
            p.parseWhere();
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        System.out.println("Parse Successful");
    }

    public Where2DOM() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.parent = this.doc;
        }
        catch (ParserConfigurationException pce) {
            throw new InternalError("programmer error: DOM new doc failure");
        }
    }

    protected Element createADQLElement(String name) {
        if (this.nsmode == 0) {
            name = "ad:" + name;
        }
        return this.doc.createElementNS(ADQL_NS, name);
    }

    private Element createSTCRElement(String name) {
        this.defineSTCR = true;
        name = "reg:" + name;
        return this.doc.createElementNS(STCR_NS, name);
    }

    private Element createSTCCElement(String name) {
        this.defineSTCC = true;
        if (this.nsmode == 0) {
            name = "stc:" + name;
        }
        return this.doc.createElementNS(STCC_NS, name);
    }

    private Element createRootElement(String name) {
        Element root = this.createADQLElement(name);
        root.setAttribute("xmlns:ad", ADQL_NS);
        if (this.defineSTCR) {
            root.setAttribute("xmlns:reg", STCR_NS);
        }
        if (this.defineSTCC) {
            root.setAttribute("xmlns:stc", STCC_NS);
        }
        root.setAttribute("xmlns:xsi", XSI_NS);
        if (this.nsmode == 1) {
            root.setAttribute("xmlns", ADQL_NS);
        }
        this.parent.appendChild(root);
        return root;
    }

    private Element getBinaryExpr(String name, boolean setXSIType, Element arg1, Element arg2, String op) {
        Element out = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(out, "binaryExprType");
        }
        out.setAttribute("Oper", op);
        out.appendChild(arg1);
        out.appendChild(arg2);
        return out;
    }

    private static void setXSITypeAttr(Element on, String type) {
        on.setAttributeNS(XSI_NS, "xsi:type", "ad:" + type);
    }

    public Element parseWhere() throws ParseException {
        return this.Where("Where");
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void indent() {
        Element parent = this.doc.getDocumentElement();
        if (parent == null || this.indent < 0) {
            return;
        }
        this.indent(parent, "\n", this.indent);
    }

    public void indent(Element parent, String indent, int incr) {
        Text txt;
        if (!parent.hasChildNodes()) {
            return;
        }
        if (indent == null) {
            indent = "\n";
        }
        String childIndent = Where2DOM.addIndentation(indent, incr);
        boolean skipElement = false;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                skipElement = true;
                continue;
            }
            if (!skipElement) {
                txt = this.doc.createTextNode(childIndent);
                parent.insertBefore(txt, child);
            }
            if (child.getNodeType() == 1) {
                this.indent((Element)child, childIndent, incr);
            }
            skipElement = false;
        }
        if (!skipElement) {
            txt = this.doc.createTextNode(indent);
            parent.appendChild(txt);
        }
    }

    public static String addIndentation(String base, int spaceCount) {
        StringBuffer sb = new StringBuffer(base);
        for (int i = 0; i < spaceCount; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void setNSMode(short mode) {
        if (mode >= 2) {
            throw new IllegalArgumentException("Undefined namespace qualification modes (" + mode + ")");
        }
        this.nsmode = mode;
    }

    public short getNSMode(short mode) {
        return this.nsmode;
    }

    protected Element getChildByTag(Element el, String name) {
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    protected boolean matchesXSIType(Element el, String qtype) {
        String type = el.getAttributeNS(XSI_NS, "xsi:type");
        return type != null && type.length() > 0 && type.equals(qtype);
    }

    protected Element renameADQLElement(Element el, String newname, Node parent) {
        Element out = this.createADQLElement(newname);
        Attr attr = null;
        NamedNodeMap attrs = el.getAttributes();
        while (attrs.getLength() > 0 && (attr = (Attr)attrs.item(0)) != null) {
            el.removeAttributeNode(attr);
            out.setAttributeNode(attr);
        }
        Node node = el.getFirstChild();
        while (node != null) {
            el.removeChild(node);
            out.appendChild(node);
            node = el.getFirstChild();
        }
        if (parent != null) {
            parent.insertBefore(out, el);
            parent.removeChild(el);
        }
        return out;
    }

    public final String MathFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase();
    }

    public final String AggregateFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase();
    }

    public final String TrigonometricFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase();
    }

    /*
     * WARNING - void declaration
     */
    public final Element FunctionOfOneVar(String name, boolean setXSIType) throws ParseException {
        void var7_6;
        boolean isMath = false;
        boolean isAgg = false;
        boolean isTrig = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                String fname = this.MathFunctionName();
                isMath = true;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                String fname = this.AggregateFunctionName();
                isAgg = true;
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                String fname = this.TrigonometricFunctionName();
                isTrig = true;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(75);
        Element arg = this.ScalarExpression("Arg");
        this.jj_consume_token(76);
        Element f = null;
        f = this.createADQLElement(name);
        if (setXSIType) {
            if (isMath) {
                Where2DOM.setXSITypeAttr(f, "mathFunctionType");
            } else if (isAgg) {
                Where2DOM.setXSITypeAttr(f, "aggregateFunctionType");
            } else if (isTrig) {
                Where2DOM.setXSITypeAttr(f, "trigonometricFunctionType");
            }
        }
        f.setAttribute("Name", (String)var7_6);
        f.appendChild(arg);
        return f;
    }

    public final Element Atom(String name, boolean setXSIType) throws ParseException {
        Element u = null;
        Element l = this.Literal("Literal", true);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: 
            case 70: {
                u = this.Unit("Unit");
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        Element a = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(a, "atomType");
        }
        a.appendChild(l);
        if (u != null) {
            a.appendChild(u);
        }
        return a;
    }

    public final Element Unit(String name) throws ParseException {
        String unit = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                unit = this.token.image;
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                unit = this.token.image.substring(1, this.token.image.length() - 1).trim();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Element u = this.createADQLElement(name);
        Text txt = this.doc.createTextNode(unit);
        u.appendChild(txt);
        return u;
    }

    public final Element BetweenPred(String name, boolean setXSIType) throws ParseException {
        boolean not = false;
        Element arg0 = this.ScalarExpression("Arg");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                not = true;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        Element arg1 = this.ScalarExpression("Arg");
        this.jj_consume_token(6);
        Element arg2 = this.ScalarExpression("Arg");
        Element b = this.createADQLElement(name);
        if (not) {
            if (setXSIType) {
                Where2DOM.setXSITypeAttr(b, "notBetweenPredType");
            }
        } else if (setXSIType) {
            Where2DOM.setXSITypeAttr(b, "betweenPredType");
        }
        b.appendChild(arg0);
        b.appendChild(arg1);
        b.appendChild(arg2);
        return b;
    }

    public final Element ClosedExpr(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(75);
        Element arg = this.ScalarExpression("Arg");
        this.jj_consume_token(76);
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(c, "closedExprType");
        }
        c.appendChild(arg);
        return c;
    }

    public final Element ClosedSearch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(75);
        Element s = this.Search(name);
        this.jj_consume_token(76);
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(c, "closedSearchType");
        }
        c.appendChild(s);
        return c;
    }

    public final Element ColumnReference(String name, boolean setXSIType) throws ParseException {
        Element col = this.XPathReference(name, setXSIType);
        return col;
    }

    public final Element ActualColumnReference(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(68);
        String table = this.token.image;
        this.jj_consume_token(77);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String cname = this.token.image;
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(c, "columnReferenceType");
        }
        c.setAttribute("Table", table);
        c.setAttribute("Name", cname);
        return c;
    }

    public final Element XPathReference(String name, boolean setXSIType) throws ParseException {
        StringBuffer sb = new StringBuffer();
        this.jj_consume_token(67);
        String cname = this.token.image;
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(c, "columnReferenceType");
        }
        c.setAttribute("Table", "");
        c.setAttribute("xpathName", cname);
        int s = cname.lastIndexOf("/");
        if (s < 0) {
            c.setAttribute("name", cname);
        } else {
            c.setAttribute("name", cname.substring(s + 1));
        }
        return c;
    }

    public final void RelativeXPath(StringBuffer sb) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                sb.append(this.token.image);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this.jj_consume_token(68);
        sb.append(this.token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 80: {
                this.jj_consume_token(80);
                sb.append(this.token.image);
                this.RelativeXPath(sb);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final Element ComparisonPred(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.ScalarExpression("Arg");
        String divider = this.ComparisonDivider();
        Element arg2 = this.ScalarExpression("Arg");
        Element c = this.createADQLElement(name);
        Matcher like = Pattern.compile(".*LIKE", 2).matcher(divider);
        Matcher not = Pattern.compile("NOT.*", 2).matcher(divider);
        if (like.matches()) {
            arg2 = this.renameADQLElement(arg2, "Pattern", null);
            if (setXSIType) {
                if (not.matches()) {
                    Where2DOM.setXSITypeAttr(c, "notLikePredType");
                } else {
                    Where2DOM.setXSITypeAttr(c, "likePredType");
                }
            }
        } else {
            if (setXSIType) {
                Where2DOM.setXSITypeAttr(c, "comparisonPredType");
            }
            c.setAttribute("Comparison", divider);
        }
        c.appendChild(arg1);
        c.appendChild(arg2);
        return c;
    }

    public final String ComparisonDivider() throws ParseException {
        String value = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                value = this.Comparison();
                break;
            }
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        value = "NOT ";
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                this.jj_consume_token(21);
                value = value + this.token.image;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String Comparison() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final Element IntersectionSearch(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.IntersectionElement(name, true);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(6);
            Element arg2 = this.IntersectionElement("Condition", true);
            arg1 = this.renameADQLElement(arg1, "Condition", null);
            Element is = this.createADQLElement(name);
            if (setXSIType) {
                Where2DOM.setXSITypeAttr(is, "intersectionSearchType");
            }
            is.appendChild(arg1);
            is.appendChild(arg2);
            arg1 = is;
        }
        return arg1;
    }

    /*
     * WARNING - void declaration
     */
    public final Element IntersectionElement(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        Element s;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            s = this.ClosedSearch(name, true);
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            s = this.BetweenPred(name, true);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    s = this.InverseSearch(name, true);
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 59: 
                case 60: 
                case 67: 
                case 73: 
                case 75: 
                case 88: 
                case 89: {
                    s = this.ComparisonPred(name, true);
                    break;
                }
                case 57: {
                    s = this.RegionSearch(name, true);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return var3_3;
    }

    public final Element InverseSearch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(22);
        Element s = this.Search("Condition");
        Element is = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(is, "inverseSearchType");
        }
        is.appendChild(s);
        return is;
    }

    /*
     * WARNING - void declaration
     */
    public final Element Literal(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: 
            case 60: {
                Element l = this.Number(name, true);
                break;
            }
            case 73: {
                Element l = this.XString(name, true);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var3_3;
    }

    public final Element Number(String name, boolean setXSIType) throws ParseException {
        Element num = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                num = this.createADQLElement(name);
                if (setXSIType) {
                    Where2DOM.setXSITypeAttr(num, "realType");
                }
                num.setAttribute("Value", this.token.image);
                return num;
            }
            case 60: {
                this.jj_consume_token(60);
                num = this.createADQLElement(name);
                if (setXSIType) {
                    Where2DOM.setXSITypeAttr(num, "integerType");
                }
                num.setAttribute("Value", this.token.image);
                return num;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Element RegionSearch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(57);
        this.jj_consume_token(75);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String literal = this.token.image;
        this.jj_consume_token(76);
        literal = literal.substring(1, literal.length() - 1);
        Pattern p = Pattern.compile(" ");
        String[] flds = p.split(literal);
        if (flds.length != 5) {
            throw new ParseException("Error parsing region literal:" + literal);
        }
        if (!flds[0].toUpperCase().equals("CIRCLE") || !flds[1].toUpperCase().equals("J2000")) {
            throw new ParseException("Unsupported region type, or coordinate system.  Only CIRCLE J2000 supported. " + flds[0] + ":" + flds[1]);
        }
        Element rs = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(rs, "regionSearchType");
        }
        Element ct = this.createADQLElement("Region");
        ct.setAttribute("unit", "deg");
        ct.setAttributeNS(XSI_NS, "xsi:type", "reg:circleType");
        rs.appendChild(ct);
        Element cen = this.createSTCRElement("Center");
        Text txt = this.doc.createTextNode(flds[2] + " " + flds[3]);
        cen.appendChild(txt);
        ct.appendChild(cen);
        if (flds[4].endsWith("\"")) {
            double radius = Double.parseDouble(flds[4].substring(0, flds[4].length() - 1)) / 3660.0;
            flds[4] = Double.toString(radius);
        } else if (flds[4].endsWith("'")) {
            double radius = Double.parseDouble(flds[4].substring(0, flds[4].length() - 1)) / 60.0;
            flds[4] = Double.toString(radius);
        } else {
            double radius = Double.parseDouble(flds[4]);
        }
        Element rad = this.createSTCRElement("Radius");
        txt = this.doc.createTextNode(flds[4]);
        rad.appendChild(txt);
        ct.appendChild(rad);
        return rs;
    }

    public final Element ScalarExpression(String name) throws ParseException {
        Element s = this.PlusExpr(name);
        return s;
    }

    public final Element PlusExpr(String name) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 67: 
            case 73: 
            case 75: {
                Element arg1 = this.MultExpr(name, true);
                while (this.jj_2_4(2)) {
                    Element be;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 88: {
                            this.jj_consume_token(88);
                            break;
                        }
                        case 89: {
                            this.jj_consume_token(89);
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    String op = this.token.image;
                    Element arg2 = this.MultExpr("Arg", true);
                    arg1 = this.renameADQLElement(arg1, "Arg", null);
                    arg1 = be = this.getBinaryExpr(name, true, arg1, arg2, op);
                }
                return arg1;
            }
            case 88: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 88: {
                        this.jj_consume_token(88);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String op = this.token.image;
                Element arg1 = this.MultExpr(name, true);
                if (this.matchesXSIType(arg1, "ad:AtomType")) {
                    String val;
                    Element lit = this.getChildByTag(arg1, "Literal");
                    if (lit != null && (this.matchesXSIType(lit, "ad:IntegerType") || this.matchesXSIType(lit, "ad:RealType")) && op.equals("-") && (val = arg1.getAttribute("Value")) != null) {
                        val = val.trim().startsWith("-") ? val.trim().substring(1) : (val.trim().startsWith("+") ? "-" + val.trim().substring(1) : "-" + val.trim());
                        arg1.setAttribute("Value", val);
                    }
                } else {
                    Element un = this.createADQLElement(name);
                    Where2DOM.setXSITypeAttr(un, "unaryType");
                    un.setAttribute("Oper", op);
                    un.appendChild(arg1);
                    arg1 = un;
                }
                while (this.jj_2_5(2)) {
                    Element be;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 88: {
                            this.jj_consume_token(88);
                            break;
                        }
                        case 89: {
                            this.jj_consume_token(89);
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    op = this.token.image;
                    Element arg2 = this.MultExpr("Arg", true);
                    arg1 = this.renameADQLElement(arg1, "Arg", null);
                    arg1 = be = this.getBinaryExpr(name, true, arg1, arg2, op);
                }
                return arg1;
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Element MultExpr(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.UnitExpr(name, true);
        while (this.jj_2_6(2)) {
            Element be;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    this.jj_consume_token(78);
                    break;
                }
                case 80: {
                    this.jj_consume_token(80);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String op = this.token.image;
            Element arg2 = this.UnitExpr("Arg", true);
            arg1 = this.renameADQLElement(arg1, "Arg", null);
            arg1 = be = this.getBinaryExpr(name, true, arg1, arg2, op);
        }
        return arg1;
    }

    /*
     * WARNING - void declaration
     */
    public final Element UnitExpr(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: 
            case 60: 
            case 73: {
                Element s = this.Atom(name, true);
                break;
            }
            case 75: {
                Element s = this.ClosedExpr(name, true);
                break;
            }
            case 67: {
                Element s = this.ColumnReference(name, true);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                Element s = this.FunctionOfOneVar(name, true);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var3_3;
    }

    public final Element Search(String name) throws ParseException {
        Element s = this.UnionSearch(name, true);
        return s;
    }

    public final Element XString(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(73);
        Element lit = this.createADQLElement(name);
        if (setXSIType) {
            Where2DOM.setXSITypeAttr(lit, "stringType");
        }
        String val = this.token.image;
        val = val.substring(1, val.length() - 1);
        Matcher m = Pattern.compile("''").matcher(val);
        val = m.replaceAll("'");
        lit.setAttribute("Value", val);
        return lit;
    }

    public final Element UnionSearch(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.IntersectionSearch(name, true);
        while (this.jj_2_7(2)) {
            this.jj_consume_token(24);
            Element arg2 = this.IntersectionSearch("Condition", true);
            arg1 = this.renameADQLElement(arg1, "Condition", null);
            Element us = this.createADQLElement(name);
            if (setXSIType) {
                Where2DOM.setXSITypeAttr(us, "unionSearchType");
            }
            us.appendChild(arg1);
            us.appendChild(arg2);
            arg1 = us;
        }
        return arg1;
    }

    public final Element Where(String name) throws ParseException {
        this.jj_consume_token(29);
        Element cond = this.Search("Condition");
        Element w = name == null ? this.createRootElement("Where") : this.createADQLElement(name);
        w.appendChild(cond);
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_45();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_41()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_29();
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        return this.jj_scan_token(76);
    }

    private final boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_22()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_23()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private final boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(78)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(80)) {
                return true;
            }
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_8();
    }

    private final boolean jj_3R_9() {
        Token xsp;
        if (this.jj_3R_10()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_6());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_19() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_15() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_14() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_8() {
        if (this.jj_3R_18()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_8();
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_14()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_15()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_16()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(88)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_57() {
        return this.jj_scan_token(70);
    }

    private final boolean jj_3R_56() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_55();
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_6();
    }

    private final boolean jj_3R_29() {
        if (this.jj_3R_35()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        Token xsp;
        if (this.jj_3R_6()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(81)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(82)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(83)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(84)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(85)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(86)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(87)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(88)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_43();
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_42();
    }

    private final boolean jj_3R_54() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_53();
    }

    private final boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_38()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_39()) {
                    return true;
                }
            }
        }
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        return this.jj_scan_token(76);
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_51()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(88)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_33() {
        Token xsp;
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(36)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(37)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(38)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(39)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(40)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(41)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_28();
    }

    private final boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(32)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(33)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(34)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_3R_18();
    }

    private final boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(43)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(44)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(45)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(46)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(48)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(47)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(49)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(52)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(53)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(54)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(55)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(56)) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3R_27() {
        Token xsp;
        if (this.jj_3R_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_7());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_scan_token(75)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(73)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(74)) {
                return true;
            }
        }
        return this.jj_scan_token(76);
    }

    private final boolean jj_3R_48() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_46() {
        return this.jj_scan_token(73);
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_48()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_47() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_7() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(76);
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_46();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, -1073741824, 0, -1073741824, 0, 0, 0x400000, 0, 0, 0, 0x400000, 0x600000, 0, -1069547520, 0, 0, 0, 0, 0, 0, -1073741824, 0, -1073741824};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{32766976, 7, 1016, 0x1F3FFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 468975615, 0x18000000, 0x18000000, 0, 0, 0, 0, 435421183, 0, 435421183};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 80, 80, 0, 16400, 32768, 65536, 0, 0xFE0000, 0xFE0000, 50334216, 512, 0, 1536, 0x3000000, 0x3000000, 0x3000000, 50334216, 81920, 2568};
    }

    public Where2DOM(InputStream stream) {
        this();
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new Where2DOMTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Where2DOM(Reader stream) {
        this();
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new Where2DOMTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Where2DOM(Where2DOMTokenManager tm) {
        this();
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Where2DOMTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[90];
        for (i = 0; i < 90; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 23; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 90; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, Where2DOMConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Where2DOM.jj_la1_0();
        Where2DOM.jj_la1_1();
        Where2DOM.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

