/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.coords.CoordinateRadius;
import jsky.util.gui.DialogUtil;

public abstract class AbstractCatalogDirectory
implements CatalogDirectory {
    private String _name;
    private String _id;
    private URL _url;
    private List _catalogs = new Vector();
    private HTMLQueryResultHandler _htmlQueryResultHandler;
    private CatalogDirectory _parent;
    private EventListenerList _listenerList = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public AbstractCatalogDirectory(String name) {
        this._name = this._id = name;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public CatalogDirectory getParent() {
        return this._parent;
    }

    public void setParent(CatalogDirectory dir) {
        if (dir != this) {
            this._parent = dir;
        }
    }

    public HTMLQueryResultHandler getHTMLQueryResultHandler() {
        return this._htmlQueryResultHandler;
    }

    public void setHTMLQueryResultHandler(HTMLQueryResultHandler handler) {
        this._htmlQueryResultHandler = handler;
    }

    public String toString() {
        return this._name;
    }

    public void addCatalog(int index, Catalog cat) {
        int i = this._catalogs.indexOf(cat);
        if (i != -1) {
            return;
        }
        String name = cat.getName();
        Catalog oldCat = this.getCatalog(name);
        int size = this._catalogs.size();
        if (oldCat != null) {
            int ans = DialogUtil.confirm(name + " already exists. Do you want to replace it?");
            if (ans != 0) {
                return;
            }
            this.removeCatalog(oldCat);
            --size;
        }
        if (index < 0 || index >= size) {
            this._catalogs.add(cat);
        } else {
            this._catalogs.add(index, cat);
        }
        cat.setParent(this);
        CatalogFactory.registerCatalog(cat, this.isLocal());
        this._fireTreeNodesInserted(this._getTreeModelEvent(cat));
    }

    public void addCatalog(Catalog cat) {
        this.addCatalog(this._catalogs.size(), cat);
    }

    public void removeCatalog(Catalog cat) {
        TreeModelEvent tme = this._getTreeModelEvent(cat);
        this._catalogs.remove(cat);
        this._fireTreeNodesRemoved(tme);
        cat.setParent(null);
        CatalogFactory.unregisterCatalog(cat);
    }

    public void replaceCatalog(Catalog oldCat, Catalog newCat) {
        int i = this._catalogs.indexOf(oldCat);
        if (i != -1) {
            this._catalogs.set(i, newCat);
            newCat.setParent(this);
            this._fireTreeNodesChanged(this._getTreeModelEvent(newCat));
        }
    }

    public void moveCatalog(Catalog cat, boolean up) {
        int i = this._catalogs.indexOf(cat);
        if (i == -1 || up && i == 0 || !up && i == this._catalogs.size() - 1) {
            return;
        }
        this.removeCatalog(cat);
        this.addCatalog(i + (up ? -1 : 1), cat);
    }

    public void moveCatalogToEnd(Catalog cat, boolean up) {
        int i = this._catalogs.indexOf(cat);
        if (i == -1 || up && i == 0 || !up && i == this._catalogs.size() - 1) {
            return;
        }
        this.removeCatalog(cat);
        if (up) {
            this.addCatalog(0, cat);
        } else {
            this.addCatalog(cat);
        }
    }

    public Catalog getCatalog(String catalogName) {
        int n = this.getNumCatalogs();
        for (int i = 0; i < n; ++i) {
            Catalog cat = this.getCatalog(i);
            if (!catalogName.equals(cat.getName()) && !catalogName.equals(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    public int getNumCatalogs() {
        return this._catalogs.size();
    }

    public Catalog getCatalog(int i) {
        return (Catalog)this._catalogs.get(i);
    }

    public int indexOf(Catalog cat) {
        return this._catalogs.indexOf(cat);
    }

    public void setCatalogs(List catalogs) {
        this._catalogs = catalogs;
        int n = this._catalogs.size();
        for (int i = 0; i < n; ++i) {
            Catalog cat = (Catalog)this._catalogs.get(i);
            cat.setParent(this);
            CatalogFactory.registerCatalog(cat, this.isLocal());
        }
        this._fireTreeStructureChanged(this._getTreeModelEvent(this));
    }

    public List getCatalogs() {
        return new Vector(this._catalogs);
    }

    public TableQueryResult getCatalogList() {
        FieldDesc[] columns = new FieldDescAdapter[]{new FieldDescAdapter("Title")};
        int numCatalogs = this.getNumCatalogs();
        Vector rows = new Vector(numCatalogs, 1);
        for (int i = 0; i < numCatalogs; ++i) {
            Vector<Catalog> cols = new Vector<Catalog>(1, 1);
            cols.add(this.getCatalog(i));
            rows.add(cols);
        }
        MemoryCatalog result = new MemoryCatalog(columns, rows);
        result.setName(this._name);
        result.setTitle(this._name);
        result.setDescription(this._name);
        return result;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getDescription() {
        if (this._url != null) {
            return this._name + " [" + this._url.toString() + "]";
        }
        return this._name;
    }

    public URL getDocURL() {
        return null;
    }

    public int getNumParams() {
        return 0;
    }

    public FieldDesc getParamDesc(int i) {
        return null;
    }

    public FieldDesc getParamDesc(String name) {
        return null;
    }

    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
    }

    public boolean isLocal() {
        return this._url.getProtocol().equals("file");
    }

    public boolean isImageServer() {
        return false;
    }

    public String getType() {
        return "directory";
    }

    public QueryResult query(QueryArgs queryArgs) throws IOException {
        return this;
    }

    public List getNameServers() {
        return CatalogFactory.getCatalogsByType("namesvr");
    }

    public AbstractCatalogDirectory getRootCatalogDirectory() {
        return (AbstractCatalogDirectory)this.getRoot();
    }

    public Object getRoot() {
        AbstractCatalogDirectory rootDir = null;
        for (CatalogDirectory catDir = this; catDir != null; catDir = catDir.getParent()) {
            rootDir = catDir;
        }
        return rootDir;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof CatalogDirectory) {
            CatalogDirectory catDir = (CatalogDirectory)parent;
            if (index >= 0 && index < catDir.getNumCatalogs()) {
                return catDir.getCatalog(index);
            }
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof CatalogDirectory) {
            CatalogDirectory catDir = (CatalogDirectory)parent;
            return catDir.getNumCatalogs();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof Catalog) {
            return !((Catalog)node).getType().equals("directory");
        }
        return false;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this._fireTreeNodesChanged(this._getTreeModelEvent((Catalog)newValue));
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof CatalogDirectory && child instanceof Catalog) {
            CatalogDirectory catDir = (CatalogDirectory)parent;
            Catalog cat = (Catalog)child;
            return catDir.indexOf(cat);
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this._listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = AbstractCatalogDirectory.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this._listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = AbstractCatalogDirectory.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    private TreeModelEvent _getTreeModelEvent(Catalog cat) {
        AbstractCatalogDirectory source = this;
        CatalogDirectory catDir = cat.getParent();
        Object[] path = null;
        int[] childIndices = null;
        Object[] children = null;
        if (catDir == null) {
            path = new Catalog[]{cat};
            childIndices = new int[]{0};
        } else {
            path = this.getPath(catDir);
            childIndices = new int[]{catDir.indexOf(cat)};
        }
        children = new Object[]{cat};
        return new TreeModelEvent((Object)source, path, childIndices, children);
    }

    public Catalog[] getPath(Catalog cat) {
        CatalogDirectory dir;
        if (cat == null) {
            return null;
        }
        Vector<Catalog> l = new Vector<Catalog>();
        if (cat instanceof CatalogDirectory) {
            dir = (CatalogDirectory)cat;
        } else {
            dir = cat.getParent();
            l.add(cat);
        }
        while (dir != null) {
            l.add(dir);
            dir = dir.getParent();
        }
        int n = l.size();
        Catalog[] ar = new Catalog[n];
        for (int i = 0; i < n; ++i) {
            ar[n - i - 1] = (Catalog)l.get(i);
        }
        return ar;
    }

    public Catalog[] getPath() {
        return this.getPath(this);
    }

    private void _fireTreeNodesChanged(TreeModelEvent e) {
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeNodesChanged(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractCatalogDirectory.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    private void _fireTreeNodesInserted(TreeModelEvent e) {
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeNodesInserted(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractCatalogDirectory.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    private void _fireTreeNodesRemoved(TreeModelEvent e) {
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeNodesRemoved(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractCatalogDirectory.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    private void _fireTreeStructureChanged(TreeModelEvent e) {
        AbstractCatalogDirectory root = this.getRootCatalogDirectory();
        if (root != null && this != root) {
            root._fireTreeStructureChanged(e);
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AbstractCatalogDirectory.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

