/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryArgs;
import jsky.catalog.SearchCondition;
import jsky.catalog.ValueRange;
import jsky.coords.CoordinateRadius;

public class BasicQueryArgs
implements QueryArgs {
    private Catalog _catalog;
    private Object[] _values;
    private int _maxRows;
    private String _id;
    private CoordinateRadius _region;
    private String _queryType;

    public BasicQueryArgs(Catalog catalog) {
        this._catalog = catalog;
        int n = this._catalog.getNumParams();
        if (n != 0) {
            this._values = new Object[n];
            for (int i = 0; i < n; ++i) {
                FieldDesc param = this._catalog.getParamDesc(i);
                this._values[i] = param != null ? param.getDefaultValue() : null;
            }
        }
    }

    public void setParamValue(int i, Object value) {
        this._values[i] = value;
    }

    public void setParamValue(String label, Object value) {
        int n = this._catalog.getNumParams();
        for (int i = 0; i < n; ++i) {
            FieldDesc param = this._catalog.getParamDesc(i);
            if (param == null) continue;
            String name = param.getName();
            String id = param.getId();
            if ((id == null || !id.equalsIgnoreCase(label)) && (name == null || !name.equalsIgnoreCase(label))) continue;
            this.setParamValue(i, value);
            return;
        }
    }

    public void setParamValue(String label, int value) {
        this.setParamValue(label, (Object)new Integer(value));
    }

    public void setParamValue(String label, double value) {
        this.setParamValue(label, (Object)new Double(value));
    }

    public void setParamValues(Object[] values) {
        this._values = values;
    }

    public Object getParamValue(int i) {
        return this._values[i];
    }

    public Object getParamValue(String label) {
        int n = this._catalog.getNumParams();
        for (int i = 0; i < n; ++i) {
            FieldDesc param = this._catalog.getParamDesc(i);
            if (param == null) continue;
            String name = param.getName();
            String id = param.getId();
            if ((id == null || !id.equalsIgnoreCase(label)) && (name == null || !name.equalsIgnoreCase(label))) continue;
            return this.getParamValue(i);
        }
        return null;
    }

    public int getParamValueAsInt(String label, int defaultValue) {
        Object o = this.getParamValue(label);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return defaultValue;
    }

    public double getParamValueAsDouble(String label, double defaultValue) {
        Object o = this.getParamValue(label);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        return defaultValue;
    }

    public String getParamValueAsString(String label, String defaultValue) {
        Object o = this.getParamValue(label);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public CoordinateRadius getRegion() {
        return this._region;
    }

    public void setRegion(CoordinateRadius region) {
        this._region = region;
    }

    public Catalog getCatalog() {
        return this._catalog;
    }

    public SearchCondition[] getConditions() {
        if (this._values == null) {
            return null;
        }
        int n = this._catalog.getNumParams();
        Vector<SearchCondition> v = new Vector<SearchCondition>(n + 1, 1);
        for (int i = 0; i < n; ++i) {
            FieldDesc p;
            if (this._values[i] == null || (p = this._catalog.getParamDesc(i)) == null) continue;
            if (this._values[i] instanceof ValueRange) {
                ValueRange r = (ValueRange)this._values[i];
                v.add(new SearchCondition(p, r.getMinValue(), r.isMinInclusive(), r.getMaxValue(), r.isMaxInclusive()));
                continue;
            }
            if (!(this._values[i] instanceof Comparable)) continue;
            v.add(new SearchCondition(p, (Comparable)this._values[i]));
        }
        n = v.size();
        if (n == 0) {
            return null;
        }
        SearchCondition[] sc = new SearchCondition[n];
        v.toArray(sc);
        return sc;
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
    }

    public String getQueryType() {
        return this._queryType;
    }

    public void setQueryType(String queryType) {
        this._queryType = queryType;
    }

    public String toString() {
        SearchCondition[] sc = this.getConditions();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sc.length; ++i) {
            sb.append(sc[i].toString());
            if (i >= sc.length - 1) continue;
            sb.append("&");
        }
        return sb.toString();
    }
}

