/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.util.Vector;
import jsky.coords.Coordinates;
import jsky.coords.ImageCoords;
import jsky.coords.WorldCoords;

public class RowCoordinates {
    protected int idCol = -1;
    protected int xCol = -1;
    protected int yCol = -1;
    protected boolean isWcs = false;
    protected double equinox = 2000.0;
    protected int equinoxCol = -1;
    protected boolean isPix = false;

    public RowCoordinates(int raCol, int decCol, double equinox) {
        this.xCol = raCol;
        this.yCol = decCol;
        this.equinox = equinox;
        this.isWcs = true;
    }

    public RowCoordinates(int raCol, int decCol, int equinoxCol) {
        this.xCol = raCol;
        this.yCol = decCol;
        this.equinoxCol = equinoxCol;
        this.isWcs = true;
    }

    public RowCoordinates(int xCol, int yCol) {
        this.xCol = xCol;
        this.yCol = yCol;
        this.isPix = true;
    }

    public RowCoordinates() {
    }

    public boolean hasCoordinates() {
        return this.isWcs || this.isPix;
    }

    public boolean isWCS() {
        return this.isWcs;
    }

    public double equinox() {
        return this.equinox;
    }

    public boolean isPix() {
        return this.isPix;
    }

    public Coordinates getCoordinates(Vector row) {
        try {
            if (this.isWcs) {
                Object ra = row.get(this.xCol);
                Object dec = row.get(this.yCol);
                if (ra != null && dec != null) {
                    if (ra instanceof String && dec instanceof String && ((String)ra).length() != 0 && ((String)dec).length() != 0) {
                        return new WorldCoords((String)ra, (String)dec, this.equinox);
                    }
                    if (ra instanceof Double && dec instanceof Double) {
                        return new WorldCoords((Double)ra, (Double)dec, this.equinox);
                    }
                    if (ra instanceof Float && dec instanceof Float) {
                        return new WorldCoords(((Float)ra).floatValue(), ((Float)dec).floatValue(), this.equinox);
                    }
                }
            } else if (this.isPix) {
                Object x = row.get(this.xCol);
                Object y = row.get(this.yCol);
                if (x != null && y != null) {
                    if (x instanceof Double && y instanceof Double) {
                        return new ImageCoords((Double)x, (Double)y);
                    }
                    if (x instanceof Float && y instanceof Float) {
                        return new ImageCoords(((Float)x).floatValue(), ((Float)y).floatValue());
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public int getXCol() {
        return this.xCol;
    }

    public int getYCol() {
        return this.yCol;
    }

    public int getRaCol() {
        return this.xCol;
    }

    public int getDecCol() {
        return this.yCol;
    }

    public double getEquinox() {
        return this.equinox;
    }

    public int getEquinoxCol() {
        return this.equinoxCol;
    }

    public int getIdCol() {
        return this.idCol;
    }

    public void setIdCol(int idCol) {
        this.idCol = idCol;
    }
}

