/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.astrocat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.util.NameValue;
import jsky.util.Resources;
import jsky.util.SaxParserUtil;
import jsky.util.TclUtil;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class AstroCatXML
extends SaxParserUtil {
    private static String VERSION = "0.1";
    private static final String NAMESPACE = "";
    private static final String LOCAL_NAME = "";
    private static final String CDATA = "CDATA";
    private static final String PUBLIC_ID = "-//JSky//DTD for Catalog Access//EN";
    private static final String SYSTEM_ID = "AstroCat.dtd";
    private Vector _catalogs;
    private AstroCatalog _catalog;
    private List _params;
    private FieldDescAdapter _param;
    private List _options;
    private NameValue _option;
    private List _symbols;
    private TablePlotSymbol _symbol;
    static /* synthetic */ Class class$jsky$catalog$astrocat$AstroCatConfig;

    public List getCatalogs() {
        return this._catalogs;
    }

    public void _catalogsStart(Attributes attrs) {
        this._catalogs = new Vector();
    }

    public void _catalogsEnd() {
        int n = this._catalogs.size();
        for (int i = n - 1; i >= 0; --i) {
            PlotableCatalog pc;
            AstroCatalog catalog;
            String path;
            Catalog c = (Catalog)this._catalogs.get(i);
            if (!(c instanceof AstroCatalog) || (path = (catalog = (AstroCatalog)c).getURLPath()) != null && path.length() != 0) continue;
            Catalog cat = CatalogFactory.getCatalogByName(catalog.getName());
            if (cat == null) {
                this._catalogs.remove(i);
                System.out.println("Warning: catalog not found in any config files: '" + catalog.getName() + "', referenced in " + this.getURL());
                continue;
            }
            if (this._catalogs.contains(cat)) {
                this._catalogs.remove(i);
                System.out.println("Warning: duplicate catalog: '" + catalog.getName() + "' in " + this.getURL());
                continue;
            }
            this._catalogs.setElementAt(cat, i);
            if (!(c instanceof PlotableCatalog) || !(cat instanceof PlotableCatalog) || (pc = (PlotableCatalog)c).getNumSymbols() == 0) continue;
            PlotableCatalog pcat = (PlotableCatalog)cat;
            pcat.setSymbols(pc.getSymbols());
            pcat.setSymbolsEdited(true);
        }
    }

    public void _catalogStart(Attributes attrs) {
        if (this._catalogs == null) {
            this._catalogs = new Vector();
        }
        if (attrs != null) {
            this._catalog = new AstroCatalog();
            this._catalog.setURL(this.getURL());
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (name.equals("id")) {
                    this._catalog.setId(value);
                    continue;
                }
                if (name.equals("name")) {
                    this._catalog.setName(value);
                    continue;
                }
                if (name.equals("type")) {
                    this._catalog.setType(value);
                    continue;
                }
                if (name.equals("protocol")) {
                    this._catalog.setProtocol(value);
                    continue;
                }
                if (name.equals("host")) {
                    this._catalog.setHost(value);
                    continue;
                }
                if (name.equals("port")) {
                    this._catalog.setPort(Integer.parseInt(value));
                    continue;
                }
                if (name.equals("path")) {
                    this._catalog.setURLPath(value);
                    continue;
                }
                if (!name.equals("class")) continue;
                this._catalog.setHandlerClass(value);
            }
        }
    }

    public void _catalogEnd() {
        if (this._catalog != null) {
            if (this._catalog.getName() == null) {
                System.out.println("Warning: no name defined for catalog in " + this.getURL());
            } else if ("directory".equals(this._catalog.getType())) {
                this._catalogs.add(this._getCatalogDirectory(this._catalog));
            } else {
                this._catalogs.add(this._catalog);
            }
            this._catalog = null;
        }
    }

    public void _paramsStart(Attributes attrs) {
        this._params = new ArrayList();
    }

    public void _paramsEnd() {
        if (this._catalog != null && this._params.size() != 0) {
            FieldDesc[] params = new FieldDescAdapter[this._params.size()];
            this._params.toArray(params);
            this._catalog.setParams(params);
        }
        this._params = null;
    }

    public void _paramStart(Attributes attrs) {
        if (attrs != null) {
            this._param = new FieldDescAdapter();
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (name.equals("id")) {
                    this._param.setId(value);
                    continue;
                }
                if (name.equals("name")) {
                    this._param.setName(value);
                    continue;
                }
                if (name.equals("description")) {
                    this._param.setDescription(value);
                    continue;
                }
                if (name.equals("value")) {
                    this._param.setDefaultValue(value);
                    continue;
                }
                if (name.equals("type")) {
                    this._param.setType(value);
                    continue;
                }
                if (name.equals("units")) {
                    this._param.setUnits(value);
                    continue;
                }
                if (!name.equals("format")) continue;
                this._param.setFormat(value);
            }
        }
    }

    public void _paramEnd() {
        this._params.add(this._param);
    }

    public void _optionsStart(Attributes attrs) {
        this._options = new ArrayList();
    }

    public void _optionsEnd() {
        if (this._param != null && this._options.size() != 0) {
            NameValue[] options = new NameValue[this._options.size()];
            this._options.toArray(options);
            this._param.setOptions(options);
        }
        this._options = null;
    }

    public void _optionStart(Attributes attrs) {
        if (attrs != null) {
            this._option = new NameValue();
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (name.equals("name")) {
                    this._option.setName(value);
                    continue;
                }
                if (!name.equals("value")) continue;
                this._option.setValue(value);
            }
        }
    }

    public void _optionEnd() {
        this._options.add(this._option);
    }

    public void _symbolsStart(Attributes attrs) {
        this._symbols = new ArrayList();
    }

    public void _symbolsEnd() {
        if (this._catalog != null && this._symbols.size() != 0) {
            TablePlotSymbol[] symbols = new TablePlotSymbol[this._symbols.size()];
            this._symbols.toArray(symbols);
            this._catalog.setSymbols(symbols);
        }
        this._symbols = null;
    }

    public void _symbolStart(Attributes attrs) {
        if (attrs != null) {
            this._symbol = new TablePlotSymbol();
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (name.equals("name")) {
                    this._symbol.setName(value);
                    continue;
                }
                if (name.equals("description")) {
                    this._symbol.setDescription(value);
                    continue;
                }
                if (name.equals("raCol")) {
                    this._symbol.setRaCol(Integer.parseInt(value));
                    continue;
                }
                if (name.equals("decCol")) {
                    this._symbol.setDecCol(Integer.parseInt(value));
                    continue;
                }
                if (name.equals("equinox")) {
                    this._symbol.setEquinox(this._getEquinox(value));
                    continue;
                }
                if (name.equals("columnsUsed")) {
                    this._symbol.setColNames(TclUtil.splitList(value));
                    continue;
                }
                if (name.equals("shape")) {
                    this._symbol.setShapeName(value);
                    continue;
                }
                if (name.equals("color")) {
                    this._symbol.setFg(value);
                    continue;
                }
                if (name.equals("condition")) {
                    this._symbol.setCond(value);
                    continue;
                }
                if (name.equals("ratio")) {
                    this._symbol.setRatio(value);
                    continue;
                }
                if (name.equals("angle")) {
                    this._symbol.setAngle(value);
                    continue;
                }
                if (name.equals("label")) {
                    this._symbol.setLabel(value);
                    continue;
                }
                if (name.equals("size")) {
                    this._symbol.setSize(value);
                    continue;
                }
                if (!name.equals("units")) continue;
                this._symbol.setUnits(value);
            }
        }
    }

    public void _symbolEnd() {
        this._symbols.add(this._symbol);
    }

    private double _getEquinox(String s) {
        if (s == null || s.length() == 0 || s.equals("J2000")) {
            return 2000.0;
        }
        if (s.equals("B1950")) {
            return 1950.0;
        }
        return Double.parseDouble(s);
    }

    private CatalogDirectory _getCatalogDirectory(AstroCatalog cat) {
        String className = cat.getHandlerClass();
        Class c = class$jsky$catalog$astrocat$AstroCatConfig == null ? (class$jsky$catalog$astrocat$AstroCatConfig = AstroCatXML.class$("jsky.catalog.astrocat.AstroCatConfig")) : class$jsky$catalog$astrocat$AstroCatConfig;
        try {
            String path;
            if (className != null) {
                this.getClass();
                c = Class.forName(className);
            }
            if ((path = cat.getURLPath()) == null || path.length() == 0) {
                Object o = c.getMethod("getDirectory", null).invoke(null, null);
                CatalogDirectory catDir = (CatalogDirectory)o;
                catDir.setName(cat.getName());
                return catDir;
            }
        }
        catch (InvocationTargetException e1) {
            Throwable t = e1.getTargetException();
            RuntimeException ex = new RuntimeException("Error calling " + className + ".getDirectory(): " + t);
            ex.setStackTrace(t.getStackTrace());
            throw ex;
        }
        catch (Exception e2) {
            throw new RuntimeException("Error calling " + className + ".getDirectory(): " + e2);
        }
        throw new RuntimeException("Could not load catalog directory entry: " + cat.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, List catalogs) throws SAXException, IOException {
        String sep = System.getProperty("file.separator");
        String filename = file.getPath();
        FileOutputStream out = null;
        XMLWriter xml = null;
        try {
            out = new FileOutputStream(filename);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setExpandEmptyElements(false);
            xml = new XMLWriter(out, format);
            xml.startDocument();
            xml.startDTD("catalogs", PUBLIC_ID, SYSTEM_ID);
            xml.endDTD();
            AstroCatXML._saveCatalogs(xml, catalogs);
            xml.endDocument();
        }
        finally {
            try {
                xml.flush();
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void _saveCatalogs(XMLWriter xml, List catalogs) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        AstroCatXML._addAttr(attrs, "version", VERSION);
        xml.startElement("", "", "catalogs", attrs);
        ListIterator it = catalogs.listIterator();
        while (it.hasNext()) {
            Catalog catalog = (Catalog)it.next();
            AstroCatXML._saveCatalog(xml, catalog);
        }
        xml.endElement("", "", "catalogs");
    }

    private static void _saveCatalog(XMLWriter xml, Catalog catalog) throws SAXException {
        PlotableCatalog pcat;
        if (catalog instanceof AstroCatConfig) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        AstroCatXML._addAttr(attrs, "name", catalog.getName());
        AstroCatXML._addAttr(attrs, "type", catalog.getType());
        AstroCatalog cat = null;
        if (catalog instanceof AstroCatalog) {
            String fileName;
            cat = (AstroCatalog)catalog;
            URL url = cat.getURL();
            if (url != null && (fileName = url.getFile()) != null) {
                File file = new File(fileName);
                String relPath = file.getName();
                AstroCatXML._addAttr(attrs, "path", relPath);
            }
        } else if (catalog instanceof CatalogDirectory) {
            AstroCatXML._addAttr(attrs, "class", catalog.getClass().getName());
        }
        xml.startElement("", "", "catalog", attrs);
        if (catalog instanceof PlotableCatalog && (pcat = (PlotableCatalog)catalog).isSymbolsEdited()) {
            AstroCatXML._saveSymbols(xml, pcat.getSymbols());
        }
        xml.endElement("", "", "catalog");
    }

    private static void _saveSymbols(XMLWriter xml, TablePlotSymbol[] symbols) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        xml.startElement("", "", "symbols", attrs);
        for (int i = 0; i < symbols.length; ++i) {
            AstroCatXML._saveSymbol(xml, symbols[i]);
        }
        xml.endElement("", "", "symbols");
    }

    private static void _saveSymbol(XMLWriter xml, TablePlotSymbol symbol) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        AstroCatXML._addAttr(attrs, "name", symbol.getName());
        AstroCatXML._addAttr(attrs, "description", symbol.getDescription());
        AstroCatXML._addAttr(attrs, "columnsUsed", TclUtil.makeList(symbol.getColNames()));
        AstroCatXML._addAttr(attrs, "shape", symbol.getShapeName());
        AstroCatXML._addAttr(attrs, "color", symbol.getColorName(symbol.getFg()));
        AstroCatXML._addAttr(attrs, "condition", symbol.getCond());
        AstroCatXML._addAttr(attrs, "ratio", symbol.getRatio());
        AstroCatXML._addAttr(attrs, "angle", symbol.getAngle());
        AstroCatXML._addAttr(attrs, "label", symbol.getLabel());
        AstroCatXML._addAttr(attrs, "size", symbol.getSize());
        AstroCatXML._addAttr(attrs, "units", symbol.getUnits());
        int raCol = symbol.getRaCol();
        int decCol = symbol.getDecCol();
        double equinox = symbol.getEquinox();
        if (raCol != 1) {
            AstroCatXML._addAttr(attrs, "raCol", String.valueOf(raCol));
        }
        if (decCol != 2) {
            AstroCatXML._addAttr(attrs, "decCol", String.valueOf(decCol));
        }
        if (equinox != 2000.0) {
            AstroCatXML._addAttr(attrs, "equinox", String.valueOf(equinox));
        }
        xml.startElement("", "", "symbol", attrs);
        xml.endElement("", "", "symbol");
    }

    private static void _addAttr(AttributesImpl attrs, String name, String value) {
        if (value != null) {
            attrs.addAttribute("", "", name, CDATA, value);
        }
    }

    public static void main(String[] args) {
        try {
            URL url = Resources.getResource("conf/AstroCat.xml");
            AstroCatXML astroCatXML = new AstroCatXML();
            astroCatXML.parse(url);
            System.out.println("Parsed conf/AstroCat.xml and found " + astroCatXML.getCatalogs().size() + " catalogs");
            String sep = System.getProperty("file.separator");
            File file = new File("test" + sep + "test.xml");
            File dir = file.getParentFile();
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            AstroCatXML.save(file, astroCatXML.getCatalogs());
            System.out.println("Saved results to " + file);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Test passed");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

