/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasLayer;
import diva.canvas.DamageRegion;
import diva.canvas.TransformContext;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.RowCoordinates;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.SymbolSelectionEvent;
import jsky.catalog.gui.SymbolSelectionListener;
import jsky.catalog.gui.TablePlotter;
import jsky.catalog.gui.TableSelectionEvent;
import jsky.catalog.gui.TableSelectionListener;
import jsky.catalog.gui.TableSymbolConfig;
import jsky.coords.CoordinateConverter;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.ImageCoords;
import jsky.coords.NamedCoordinates;
import jsky.coords.WorldCoordinates;
import jsky.coords.WorldCoords;
import jsky.graphics.CanvasGraphics;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.graphics.ShapeUtil;
import jsky.image.gui.GraphicsImageDisplay;
import jsky.image.gui.ImageCoordinateConverter;
import jsky.navigator.NavigatorPane;
import jsky.util.java2d.ShapeUtilities;

public class BasicTablePlotter
implements TablePlotter,
LayerListener,
ChangeListener {
    private JDesktopPane _desktop;
    private DivaImageGraphics _imageGraphics;
    private CanvasLayer _layer;
    private ImageCoordinateConverter _coordinateConverter;
    private double _imageEquinox = 2000.0;
    private LinkedList _tableList = new LinkedList();
    private SymbolListItem[] _symbolAr;
    private LinkedList _figureList;
    private boolean _visible = true;
    private EventListenerList _listenerList = new EventListenerList();
    private EventListenerList _tableListenerList = new EventListenerList();
    private Hashtable _plotSymbolMap = new Hashtable(32);
    private Stroke _selectedStroke = new BasicStroke(3.0f);
    static /* synthetic */ Class class$jsky$catalog$gui$SymbolSelectionListener;
    static /* synthetic */ Class class$jsky$catalog$gui$TableSelectionListener;

    public BasicTablePlotter() {
    }

    public BasicTablePlotter(JDesktopPane desktop) {
        this._desktop = desktop;
    }

    public BasicTablePlotter(CanvasGraphics canvasGraphics, CoordinateConverter coordinateConverter) {
        this.setCanvasGraphics(canvasGraphics);
        this.setCoordinateConverter(this._coordinateConverter);
    }

    public void setCanvasGraphics(CanvasGraphics canvasGraphics) {
        this._imageGraphics = (DivaImageGraphics)canvasGraphics;
        NavigatorPane pane = (NavigatorPane)this._imageGraphics.getGraphicsPane();
        this._layer = pane.getSymbolLayer();
        pane.getBackgroundEventLayer().addLayerListener((LayerListener)this);
    }

    public CanvasGraphics getCanvasGraphics() {
        return this._imageGraphics;
    }

    public CoordinateConverter getCoordinateConverter() {
        return this._coordinateConverter;
    }

    public void setCoordinateConverter(CoordinateConverter c) {
        this._coordinateConverter = (ImageCoordinateConverter)c;
    }

    public boolean check(TableQueryResult table) {
        WorldCoordinates pos;
        GraphicsImageDisplay imageDisplay = (GraphicsImageDisplay)this._coordinateConverter.getImageDisplay();
        if (imageDisplay.isClear() && (pos = table.getWCSCenter()) != null) {
            imageDisplay.blankImage(pos.getRaDeg(), pos.getDecDeg());
        }
        return this._coordinateConverter.isWCS();
    }

    public void plot(TableQueryResult table) {
        int i;
        if (this._layer == null || this._coordinateConverter == null) {
            throw new RuntimeException("Can't plot the given table data");
        }
        if (!this.check(table)) {
            return;
        }
        TablePlotSymbol[] symbols = this.getPlotSymbolInfo(table);
        if (symbols == null) {
            return;
        }
        for (i = 0; i < symbols.length; ++i) {
            symbols[i].setTable(table);
        }
        this._symbolAr = new SymbolListItem[symbols.length];
        for (i = 0; i < symbols.length; ++i) {
            this._symbolAr[i] = new SymbolListItem(symbols[i]);
        }
        this.plotSymbols(table, symbols);
        ListIterator it = this._tableList.listIterator(0);
        while (it.hasNext()) {
            TableListItem item = (TableListItem)it.next();
            if (item.table != table && !item.table.getName().equals(table.getName()) || item.table.getCatalog() != table.getCatalog()) continue;
            it.remove();
            break;
        }
        this._tableList.add(new TableListItem(table, this._symbolAr));
        this._coordinateConverter.removeChangeListener(this);
        this._coordinateConverter.addChangeListener(this);
        this._layer.repaint();
    }

    public void stateChanged(ChangeEvent e) {
        this.replotAll();
    }

    public TablePlotSymbol[] getPlotSymbolInfo(TableQueryResult table) {
        Object o = this._plotSymbolMap.get(table);
        Catalog catalog = table.getCatalog();
        if (o == null && catalog != null) {
            o = this._plotSymbolMap.get(catalog);
        }
        if (o instanceof TablePlotSymbol[]) {
            return (TablePlotSymbol[])o;
        }
        if (catalog instanceof PlotableCatalog) {
            TablePlotSymbol[] symbols = ((PlotableCatalog)catalog).getSymbols();
            if (symbols != null) {
                this._plotSymbolMap.put(table, symbols);
                this._plotSymbolMap.put(catalog, symbols);
            }
            return symbols;
        }
        return null;
    }

    public void setPlotSymbolInfo(TableQueryResult table, TablePlotSymbol[] symbols) {
        Catalog catalog = table.getCatalog();
        this._plotSymbolMap.put(table, symbols);
        if (catalog != null) {
            this._plotSymbolMap.put(catalog, symbols);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void plotSymbols(TableQueryResult table, TablePlotSymbol[] symbols) {
        int cooSys;
        int nrows = table.getRowCount();
        RowCoordinates rowCoords = table.getRowCoordinates();
        double tableEquinox = rowCoords.getEquinox();
        Vector dataVec = table.getDataVector();
        boolean isWCS = rowCoords.isWCS();
        boolean isPix = rowCoords.isPix();
        if (isPix) {
            cooSys = 0;
        } else if (isWCS) {
            cooSys = 4;
            this._imageEquinox = this._coordinateConverter.getEquinox();
        } else {
            throw new RuntimeException("no wcs or image coordinates to plot");
        }
        for (int row = 0; row < nrows; ++row) {
            double y;
            double x;
            Vector rowVec = (Vector)dataVec.get(row);
            Coordinates pos = rowCoords.getCoordinates(rowVec);
            if (pos == null) continue;
            if (isPix) {
                x = pos.getX();
                y = pos.getY();
            } else {
                double[] radec = ((WorldCoords)pos).getRaDec(this._imageEquinox);
                x = radec[0];
                y = radec[1];
            }
            for (int i = 0; i < symbols.length; ++i) {
                this._figureList = this._symbolAr[i].figureList;
                try {
                    void var10_9;
                    this.plotRow(table, row, rowVec, x, y, (int)var10_9, symbols[i]);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected void plotRow(TableQueryResult table, int row, Vector rowVec, double x, double y, int cooSys, TablePlotSymbol symbol) {
        boolean cond = symbol.getCond(rowVec);
        if (!cond) {
            return;
        }
        double radius = symbol.getSize(rowVec);
        if (radius <= 0.0 || Double.isNaN(radius)) {
            radius = 1.0;
        }
        double ratio = symbol.getRatio(rowVec);
        double angle = symbol.getAngle(rowVec);
        String label = symbol.getLabel(rowVec);
        this.plotSymbol(table, row, symbol, x, y, cooSys, radius, ratio, angle, label);
    }

    protected void plotSymbol(TableQueryResult table, int row, TablePlotSymbol symbol, double x, double y, int cooSys, double radius, double ratio, double angle, String label) {
        Point2D.Double pos = new Point2D.Double(x, y);
        this._coordinateConverter.convertCoords(pos, cooSys, 3, false);
        double w = this._coordinateConverter.getWidth();
        double h = this._coordinateConverter.getHeight();
        if (pos.x < 0.0 || pos.y < 0.0 || pos.x >= w || pos.y >= h) {
            return;
        }
        this._coordinateConverter.convertCoords(pos, 3, 1, false);
        Point2D.Double size = new Point2D.Double(radius, radius);
        int sizeType = this.getCoordType(symbol.getUnits());
        this._coordinateConverter.convertCoords(size, sizeType, 1, true);
        Shape shape = this.makeShape(symbol, pos.x, pos.y, Math.max(size.x, size.y), ratio, angle);
        FigureListItem item = new FigureListItem(shape, label, row);
        this._figureList.add(item);
    }

    protected int getCoordType(String name) {
        if (name != null && name.length() != 0) {
            if (name.startsWith("deg")) {
                return 4;
            }
            if (name.equals("image")) {
                return 0;
            }
            if (name.equals("screen")) {
                return 1;
            }
            if (name.equals("canvas")) {
                return 2;
            }
            if (name.equals("user")) {
                return 3;
            }
        }
        return 0;
    }

    protected Shape makeShape(TablePlotSymbol symbol, double x, double y, double size, double ratio, double angle) {
        int shape = symbol.getShape();
        switch (shape) {
            case 0: {
                return new Ellipse2D.Double(x - size, y - size, size * 2.0, size * 2.0);
            }
            case 1: {
                return new Rectangle2D.Double(x - size, y - size, size * 2.0, size * 2.0);
            }
            case 3: {
                return ShapeUtil.makeCross(x, y, size);
            }
            case 4: {
                return ShapeUtil.makeTriangle(x, y, size);
            }
            case 5: {
                return ShapeUtil.makeDiamond(x, y, size);
            }
        }
        Point2D.Double center = new Point2D.Double(x, y);
        Point2D.Double north = new Point2D.Double(x, y - size);
        Point2D.Double east = new Point2D.Double(x - size, y);
        this.getNorthAndEast(center, size, ratio, angle, north, east);
        switch (shape) {
            case 7: {
                return ShapeUtil.makeCompass(center, north, east);
            }
            case 8: {
                return ShapeUtil.makeLine(center, north, east);
            }
            case 9: {
                return ShapeUtil.makeArrow(center, north);
            }
            case 6: {
                return ShapeUtil.makeEllipse(center, north, east);
            }
            case 2: {
                return ShapeUtil.makePlus(center, north, east);
            }
        }
        throw new RuntimeException("Unknown plot symbol shape: " + symbol.getShapeName());
    }

    protected void getNorthAndEast(Point2D.Double center, double size, double ratio, double angle, Point2D.Double north, Point2D.Double east) {
        if (this._coordinateConverter.isWCS()) {
            Point2D.Double wcsCenter = new Point2D.Double(center.x, center.y);
            this._coordinateConverter.screenToWorldCoords(wcsCenter, false);
            Point2D.Double wcsRadius = new Point2D.Double(size, size);
            this._coordinateConverter.screenToWorldCoords(wcsRadius, true);
            if (ratio < 1.0) {
                wcsRadius.y *= 1.0 / ratio;
            } else if (ratio > 1.0) {
                wcsRadius.x *= ratio;
            }
            east.x = Math.IEEEremainder(wcsCenter.x + Math.abs(wcsRadius.x) / Math.cos(wcsCenter.y / 180.0 * Math.PI), 360.0);
            if (east.x < 0.0) {
                east.x += 360.0;
            }
            east.y = wcsCenter.y;
            north.x = wcsCenter.x;
            north.y = wcsCenter.y + Math.abs(wcsRadius.y);
            if (north.y >= 90.0) {
                north.y = 180.0 - north.y;
            } else if (north.y <= -90.0) {
                north.y = -180.0 - north.y;
            }
            this._coordinateConverter.worldToScreenCoords(north, false);
            this._coordinateConverter.worldToScreenCoords(east, false);
        } else {
            double rx = size;
            double ry = size;
            if (ratio < 1.0) {
                ry *= 1.0 / ratio;
            } else if (ratio > 1.0) {
                rx *= ratio;
            }
            east.x = center.x - rx;
            east.y = center.y;
            north.x = center.x;
            north.y = center.y - ry;
        }
        if (angle != 0.0) {
            this.rotatePoint(north, center, angle);
            this.rotatePoint(east, center, angle);
        }
    }

    protected void rotatePoint(Point2D.Double p, Point2D.Double center, double angle) {
        p.x -= center.x;
        p.y -= center.y;
        double tmp = p.x;
        double rad = angle * Math.PI / 180.0;
        double cosa = Math.cos(rad);
        double sina = Math.sin(rad);
        p.x = p.x * cosa + p.y * sina + center.x;
        p.y = -tmp * sina + p.y * cosa + center.y;
    }

    public void unplot(TableQueryResult table) {
        ListIterator it = this._tableList.listIterator(0);
        while (it.hasNext()) {
            TableListItem item = (TableListItem)it.next();
            if (item.table != table) continue;
            it.remove();
            this._layer.repaint();
            break;
        }
    }

    public void unplotAll() {
        this._tableList = new LinkedList();
        this._layer.repaint();
    }

    public void replotAll() {
        LinkedList list = (LinkedList)this._tableList.clone();
        this._tableList = new LinkedList();
        ListIterator it = list.listIterator(0);
        while (it.hasNext()) {
            TableListItem tli = (TableListItem)it.next();
            tli.inRange = this.tableInRange(tli.table);
            if (tli.inRange) {
                this.plot(tli.table);
                continue;
            }
            this._tableList.add(tli);
        }
        this._layer.repaint();
    }

    public TableQueryResult[] getTables() {
        int n = this._tableList.size();
        if (n == 0) {
            return null;
        }
        ListIterator it = this._tableList.listIterator(0);
        Vector<TableQueryResult> tableVec = new Vector<TableQueryResult>(n);
        while (it.hasNext()) {
            TableListItem item = (TableListItem)it.next();
            if (!item.inRange) continue;
            tableVec.add(item.table);
        }
        n = tableVec.size();
        if (n == 0) {
            return null;
        }
        TableQueryResult[] tables = new TableQueryResult[n];
        for (int i = 0; i < n; ++i) {
            tables[i] = (TableQueryResult)tableVec.get(i);
        }
        return tables;
    }

    protected void repaint(Shape shape) {
        this._layer.repaint(DamageRegion.createDamageRegion((TransformContext)new TransformContext((CanvasComponent)this._layer), (Rectangle2D)shape.getBounds2D()));
    }

    public void selectSymbol(TableQueryResult table, int tableRow, boolean selected) {
        ListIterator tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = (TableListItem)tableIt.next();
            if (tli.table != table) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = (FigureListItem)figureListIt.next();
                    if (fli.row != tableRow || fli.selected == selected) continue;
                    fli.selected = selected;
                    this.repaint(fli.shape);
                }
            }
        }
        this.fireTableSelectionEvent(table, tableRow, selected);
    }

    public void selectSymbol(TableQueryResult table, int tableRow) {
        this.selectSymbol(table, tableRow, true);
    }

    public void deselectSymbol(TableQueryResult table, int tableRow) {
        this.selectSymbol(table, tableRow, false);
    }

    public void addSymbolSelectionListener(SymbolSelectionListener listener) {
        this._listenerList.add(class$jsky$catalog$gui$SymbolSelectionListener == null ? (class$jsky$catalog$gui$SymbolSelectionListener = BasicTablePlotter.class$("jsky.catalog.gui.SymbolSelectionListener")) : class$jsky$catalog$gui$SymbolSelectionListener, listener);
    }

    public void removeSymbolSelectionListener(SymbolSelectionListener listener) {
        this._listenerList.remove(class$jsky$catalog$gui$SymbolSelectionListener == null ? (class$jsky$catalog$gui$SymbolSelectionListener = BasicTablePlotter.class$("jsky.catalog.gui.SymbolSelectionListener")) : class$jsky$catalog$gui$SymbolSelectionListener, listener);
    }

    protected void fireSymbolSelectionEvent(TableQueryResult table, int row, boolean isSelected) {
        SymbolSelectionEvent event = new SymbolSelectionEvent(row, table);
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$jsky$catalog$gui$SymbolSelectionListener == null ? BasicTablePlotter.class$("jsky.catalog.gui.SymbolSelectionListener") : class$jsky$catalog$gui$SymbolSelectionListener)) continue;
            SymbolSelectionListener listener = (SymbolSelectionListener)listeners[i + 1];
            if (isSelected) {
                listener.symbolSelected(event);
                continue;
            }
            listener.symbolDeselected(event);
        }
    }

    public void addTableSelectionListener(TableSelectionListener listener) {
        this._tableListenerList.add(class$jsky$catalog$gui$TableSelectionListener == null ? (class$jsky$catalog$gui$TableSelectionListener = BasicTablePlotter.class$("jsky.catalog.gui.TableSelectionListener")) : class$jsky$catalog$gui$TableSelectionListener, listener);
    }

    public void removeTableSelectionListener(TableSelectionListener listener) {
        this._tableListenerList.remove(class$jsky$catalog$gui$TableSelectionListener == null ? (class$jsky$catalog$gui$TableSelectionListener = BasicTablePlotter.class$("jsky.catalog.gui.TableSelectionListener")) : class$jsky$catalog$gui$TableSelectionListener, listener);
    }

    protected void fireTableSelectionEvent(TableQueryResult table, int row, boolean selected) {
        TableSelectionEvent event = new TableSelectionEvent(row, table);
        Object[] listeners = this._tableListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$jsky$catalog$gui$TableSelectionListener == null ? BasicTablePlotter.class$("jsky.catalog.gui.TableSelectionListener") : class$jsky$catalog$gui$TableSelectionListener)) continue;
            TableSelectionListener listener = (TableSelectionListener)listeners[i + 1];
            if (!selected) continue;
            listener.tableSelected(event);
        }
    }

    public void setVisible(boolean isVisible) {
        this._visible = isVisible;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public JPanel getConfigPanel(TableQueryResult table) {
        return new TableSymbolConfig(this, table);
    }

    public void paintSymbols(Graphics2D g2d, Rectangle2D region) {
        if (!this._visible) {
            return;
        }
        g2d.setPaintMode();
        ListIterator tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = (TableListItem)tableIt.next();
            if (!tli.inRange) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                g2d.setColor(sli.symbol.getFg());
                ListIterator figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = (FigureListItem)figureListIt.next();
                    if (region != null && !fli.shape.intersects(region)) continue;
                    if (fli.selected) {
                        Stroke stroke = g2d.getStroke();
                        g2d.setStroke(this._selectedStroke);
                        g2d.draw(fli.shape);
                        g2d.setStroke(stroke);
                    } else {
                        g2d.draw(fli.shape);
                    }
                    if (fli.label == null) continue;
                    Rectangle r = fli.shape.getBounds();
                    g2d.drawString(fli.label, (float)r.getCenterX(), (float)r.getCenterY());
                }
            }
        }
    }

    public void transformGraphics(AffineTransform trans) {
        ListIterator tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = (TableListItem)tableIt.next();
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = (FigureListItem)figureListIt.next();
                    fli.shape = ShapeUtilities.transformModify(fli.shape, trans);
                }
            }
        }
        this._layer.repaint();
    }

    protected boolean tableInRange(TableQueryResult table) {
        QueryArgs queryArgs = table.getQueryArgs();
        CoordinateRadius region = null;
        if (queryArgs == null) {
            region = this.getTableRegion(table);
            if (region != null) {
                queryArgs = new BasicQueryArgs(table);
                queryArgs.setRegion(region);
                table.setQueryArgs(queryArgs);
            }
        } else {
            region = queryArgs.getRegion();
        }
        if (region == null) {
            return false;
        }
        Coordinates centerPosition = region.getCenterPosition();
        if (!(centerPosition instanceof WorldCoords)) {
            return true;
        }
        if (!this._coordinateConverter.isWCS()) {
            return false;
        }
        WorldCoords pos = (WorldCoords)centerPosition;
        double ra = pos.getRaDeg();
        double dec = pos.getDecDeg();
        double w = region.getWidth();
        double h = region.getHeight();
        Rectangle2D.Double tableRect = new Rectangle2D.Double(ra, dec, w, h);
        Point2D.Double p = this._coordinateConverter.getWCSCenter();
        pos = new WorldCoords(p.x, p.y, this._imageEquinox);
        ra = pos.getRaDeg();
        dec = pos.getDecDeg();
        w = this._coordinateConverter.getWidthInDeg() * 60.0;
        h = this._coordinateConverter.getHeightInDeg() * 60.0;
        Rectangle2D.Double imageRect = new Rectangle2D.Double(ra, dec, w, h);
        return tableRect.intersects(imageRect);
    }

    protected CoordinateRadius getTableRegion(TableQueryResult table) {
        int nrows = table.getRowCount();
        if (nrows == 0) {
            return null;
        }
        RowCoordinates rowCoords = table.getRowCoordinates();
        double tableEquinox = rowCoords.getEquinox();
        Vector dataVec = table.getDataVector();
        if (rowCoords.isPix()) {
            Point2D.Double p = this._coordinateConverter.getImageCenter();
            ImageCoords pos = new ImageCoords(p.x, p.y);
            double w = this._coordinateConverter.getWidth();
            double h = this._coordinateConverter.getHeight();
            double r = Math.sqrt(w * w + h * h);
            return new CoordinateRadius(pos, r, w, h);
        }
        if (!rowCoords.isWCS()) {
            return null;
        }
        int cooSys = 4;
        double ra0 = 0.0;
        double ra1 = 0.0;
        double dec0 = 0.0;
        double dec1 = 0.0;
        boolean firstTime = true;
        for (int row = 1; row < nrows; ++row) {
            Vector rowVec = (Vector)dataVec.get(row);
            Coordinates pos = rowCoords.getCoordinates(rowVec);
            if (pos == null) continue;
            if (firstTime) {
                firstTime = false;
                ra1 = ra0 = pos.getX();
                dec1 = dec0 = pos.getY();
                continue;
            }
            double ra = pos.getX();
            double dec = pos.getY();
            ra0 = Math.min(ra0, ra);
            ra1 = Math.max(ra1, ra);
            dec0 = Math.min(dec0, dec);
            dec1 = Math.max(dec1, dec);
        }
        WorldCoords centerPos = new WorldCoords((ra0 + ra1) / 2.0, (dec0 + dec1) / 2.0, tableEquinox);
        double d = WorldCoords.dist(ra0, dec0, ra1, dec1);
        CoordinateRadius region = new CoordinateRadius(centerPos, d / 2.0);
        return region;
    }

    public void mouseDragged(LayerEvent e) {
    }

    public void mousePressed(LayerEvent e) {
    }

    public void mouseReleased(LayerEvent e) {
    }

    public void mouseClicked(LayerEvent e) {
        if (!this._visible) {
            return;
        }
        double x = e.getLayerX();
        double y = e.getLayerY();
        boolean toggleSel = e.isShiftDown() || e.isControlDown();
        ListIterator tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = (TableListItem)tableIt.next();
            if (!tli.inRange) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = (FigureListItem)figureListIt.next();
                    if (sli.symbol.getBoundingShape(fli.shape).contains(x, y)) {
                        if (toggleSel) {
                            fli.selected = !fli.selected;
                            this.repaint(fli.shape);
                            this.fireSymbolSelectionEvent(tli.table, fli.row, fli.selected);
                            continue;
                        }
                        if (fli.selected) continue;
                        fli.selected = true;
                        this.repaint(fli.shape);
                        this.fireSymbolSelectionEvent(tli.table, fli.row, fli.selected);
                        continue;
                    }
                    if (toggleSel || !fli.selected) continue;
                    fli.selected = false;
                    this.repaint(fli.shape);
                    this.fireSymbolSelectionEvent(tli.table, fli.row, fli.selected);
                }
            }
        }
    }

    public NamedCoordinates getCatalogPosition(Point2D.Double p) {
        ListIterator tableIt = this._tableList.listIterator(0);
        while (tableIt.hasNext()) {
            TableListItem tli = (TableListItem)tableIt.next();
            if (!tli.inRange) continue;
            for (int i = 0; i < tli.symbolAr.length; ++i) {
                SymbolListItem sli = tli.symbolAr[i];
                ListIterator figureListIt = sli.figureList.listIterator(0);
                while (figureListIt.hasNext()) {
                    FigureListItem fli = (FigureListItem)figureListIt.next();
                    if (!fli.selected || !sli.symbol.getBoundingShape(fli.shape).contains(p)) continue;
                    RowCoordinates rowCoords = tli.table.getRowCoordinates();
                    if (!rowCoords.isWCS()) {
                        return null;
                    }
                    double tableEquinox = rowCoords.getEquinox();
                    Vector dataVec = tli.table.getDataVector();
                    this._imageEquinox = this._coordinateConverter.getEquinox();
                    Vector rowVec = (Vector)dataVec.get(fli.row);
                    Coordinates cpos = rowCoords.getCoordinates(rowVec);
                    if (cpos == null) {
                        return null;
                    }
                    WorldCoords pos = (WorldCoords)cpos;
                    double[] radec = pos.getRaDec(this._imageEquinox);
                    p.x = radec[0];
                    p.y = radec[1];
                    this._coordinateConverter.convertCoords(p, 4, 1, false);
                    int idCol = rowCoords.getIdCol();
                    String id = null;
                    if (idCol != -1) {
                        id = (String)rowVec.get(idCol);
                    }
                    Vector columnIdentifiers = tli.table.getColumnIdentifiers();
                    int numCols = columnIdentifiers.size();
                    String brightness = "";
                    for (int col = 0; col < numCols; ++col) {
                        Object o;
                        String s = (String)columnIdentifiers.get(col);
                        String sl = s.toLowerCase();
                        if (sl.equals("mag")) {
                            o = rowVec.get(col);
                            if (o == null) continue;
                            brightness = o + " mag";
                            break;
                        }
                        if (!sl.endsWith("mag") || sl.startsWith("e") || (o = rowVec.get(col)) == null) continue;
                        if (brightness.length() != 0) {
                            brightness = brightness + ", ";
                        }
                        brightness = brightness + o + s.charAt(0);
                    }
                    return new NamedCoordinates(id, pos, brightness);
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FigureListItem {
        public Shape shape;
        public String label;
        public int row;
        public boolean selected = false;

        public FigureListItem(Shape s, String lab, int r) {
            this.shape = s;
            this.label = lab;
            this.row = r;
        }
    }

    protected class SymbolListItem {
        public TablePlotSymbol symbol;
        public LinkedList figureList = new LinkedList();

        public SymbolListItem(TablePlotSymbol s) {
            this.symbol = s;
        }
    }

    protected class TableListItem {
        public TableQueryResult table;
        public SymbolListItem[] symbolAr;
        public boolean inRange = true;

        public TableListItem(TableQueryResult t, SymbolListItem[] ar) {
            this.table = t;
            this.symbolAr = ar;
        }
    }
}

