/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogNavigatorMenuBar;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.util.gui.DialogUtil;

public class CatalogHistoryItem
extends AbstractAction
implements Serializable {
    protected String urlStr;
    protected String name;
    protected transient JComponent queryComponent;

    public CatalogHistoryItem(String name, URL url, JComponent queryComponent) {
        super(name);
        this.name = name;
        if (url != null) {
            this.urlStr = url.toString();
        }
        this.queryComponent = queryComponent;
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            CatalogNavigator navigator = CatalogNavigatorMenuBar.getCurrentCatalogNavigator();
            URL url = null;
            if (this.urlStr != null) {
                url = new URL(this.urlStr);
            }
            if (this.queryComponent != null) {
                navigator.setOrigURL(url);
                navigator.setQueryComponent(this.queryComponent);
            } else if (url != null) {
                navigator.setQueryResult(new URLQueryResult(url));
            } else if (navigator instanceof CatalogNavigatorOpener) {
                ((CatalogNavigatorOpener)((Object)navigator)).openCatalogWindow(this.name);
            } else {
                System.out.println("XXX CatalogHistoryItem.actionPerformed: don't know how to display catalog");
            }
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public String getURLStr() {
        return this.urlStr;
    }

    public String getName() {
        return this.name;
    }

    public JComponent getQueryComponent() {
        return this.queryComponent;
    }
}

