/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.CatalogHistoryItem;
import jsky.catalog.gui.CatalogNavigatorMenuBar;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.CatalogTree;
import jsky.catalog.gui.CatalogUIHandler;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.gui.TablePlotter;
import jsky.html.HTMLViewerFrame;
import jsky.html.HTMLViewerInternalFrame;
import jsky.util.FileUtil;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.PrintableWithDialog;
import jsky.util.Saveable;
import jsky.util.SaveableAsHTML;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GenericToolBarTarget;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;

public abstract class CatalogNavigator
extends JPanel
implements QueryResultDisplay,
GenericToolBarTarget,
HTMLQueryResultHandler {
    private static final I18N _I18N = I18N.getInstance(class$jsky$catalog$gui$CatalogNavigator == null ? (class$jsky$catalog$gui$CatalogNavigator = CatalogNavigator.class$("jsky.catalog.gui.CatalogNavigator")) : class$jsky$catalog$gui$CatalogNavigator);
    private Component _parent;
    private static boolean _mainWindowFlag = false;
    private JDesktopPane _desktop = null;
    private boolean _autoQuery = false;
    private JPanel _queryPanel;
    private JPanel _resultPanel;
    private CatalogTree _catalogTree;
    private JComponent _queryComponent;
    private JComponent _resultComponent;
    private URL _origURL;
    private static JFileChooser _fileChooser;
    private ProgressPanel _progressPanel;
    private EventListenerList _listenerList = new EventListenerList();
    private Stack _backStack = new Stack();
    private Stack _forwStack = new Stack();
    private boolean _noStack = false;
    private QueryResult _queryResult;
    private TablePlotter _plotter;
    private SwingWorker _worker;
    private Component _htmlViewerFrame;
    private Hashtable _panelTreeNodeTable = new Hashtable(10);
    private LinkedList _historyList;
    private static final String HISTORY_LIST_NAME = "catalogHistoryList";
    private int _maxHistoryItems = 20;
    private Hashtable _queryResultComponentMap = new Hashtable();
    private JSplitPane _querySplitPane;
    private JSplitPane _resultSplitPane;
    private AbstractAction _openAction = new AbstractAction(_I18N.getString("open")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.open();
        }
    };
    private AbstractAction _saveAsAction = new AbstractAction(_I18N.getString("saveAs")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.saveAs();
        }
    };
    private AbstractAction _saveWithImageAction = new AbstractAction(_I18N.getString("saveCatalogWithImage")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.saveWithImage();
        }
    };
    private AbstractAction _saveAsHTMLAction = new AbstractAction(_I18N.getString("saveAsHTML")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.saveAsHTML();
        }
    };
    private AbstractAction _printAction = new AbstractAction(_I18N.getString("print") + "..."){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.print();
        }
    };
    private AbstractAction _backAction = new AbstractAction(_I18N.getString("back")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.back();
        }
    };
    private AbstractAction _forwAction = new AbstractAction(_I18N.getString("forward")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.forward();
        }
    };
    private AbstractAction _addRowAction = new AbstractAction(_I18N.getString("addRow")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.addRow();
        }
    };
    private AbstractAction _deleteSelectedRowsAction = new AbstractAction(_I18N.getString("deleteSelectedRows")){

        public void actionPerformed(ActionEvent evt) {
            CatalogNavigator.this.deleteSelectedRows();
        }
    };
    static /* synthetic */ Class class$jsky$catalog$gui$CatalogNavigator;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public CatalogNavigator(Component parent, CatalogTree catalogTree) {
        this._parent = parent;
        this.setLayout(new BorderLayout());
        this._catalogTree = catalogTree;
        catalogTree.setQueryResultDisplay(this);
        catalogTree.setHTMLQueryResultHandler(this);
        catalogTree.setPreferredSize(new Dimension(256, 0));
        this._queryPanel = new JPanel();
        this._queryPanel.setLayout(new BorderLayout());
        this._resultPanel = new JPanel();
        this._resultPanel.setLayout(new BorderLayout());
        this._querySplitPane = new JSplitPane(1, catalogTree, this._queryPanel);
        this._querySplitPane.setOneTouchExpandable(true);
        this._resultSplitPane = new JSplitPane(0, this._querySplitPane, this._resultPanel);
        this._resultSplitPane.setOneTouchExpandable(true);
        this._resultSplitPane.setDividerLocation(270);
        this.add((Component)this._resultSplitPane, "Center");
        this.loadHistory();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                CatalogNavigator.this.saveHistory(true);
            }
        });
    }

    public CatalogNavigator(Component parent, CatalogTree catalogTree, TablePlotter plotter) {
        this(parent, catalogTree);
        this._plotter = plotter;
    }

    public CatalogTree getCatalogTree() {
        return this._catalogTree;
    }

    protected JSplitPane getQuerySplitPane() {
        return this._querySplitPane;
    }

    protected JSplitPane getResultSplitPane() {
        return this._resultSplitPane;
    }

    public JDesktopPane getDesktop() {
        return this._desktop;
    }

    public void setDesktop(JDesktopPane desktop) {
        this._desktop = desktop;
    }

    public void setAutoQuery(boolean b) {
        this._autoQuery = b;
    }

    public TablePlotter getPlotter() {
        return this._plotter;
    }

    public void setPlotter(TablePlotter tp) {
        this._plotter = tp;
    }

    public Component getParentFrame() {
        return this._parent;
    }

    public void setComponent(JComponent component) {
        if (component instanceof QueryResultDisplay) {
            this.setResultComponent(component);
        } else {
            this.setQueryComponent(component);
            if (component instanceof CatalogQueryTool && (this._autoQuery || ((CatalogQueryTool)component).getCatalog().isLocal())) {
                ((CatalogQueryTool)component).search();
            }
        }
    }

    public void setQueryComponent(JComponent component) {
        if (component == null || component == this._queryComponent) {
            return;
        }
        if (this._queryComponent != null) {
            this.addToHistory();
            this._queryPanel.remove(this._queryComponent);
            this._queryComponent = null;
        }
        this._queryComponent = component;
        Catalog cat = this._catalogTree.getSelectedNode();
        if (cat != null) {
            this._panelTreeNodeTable.put(this._queryComponent, cat);
        }
        this._queryPanel.add((Component)this._queryComponent, "Center");
        Object resultComp = this._queryResultComponentMap.get(this._queryComponent);
        if (resultComp == null) {
            this.setResultComponent(new EmptyPanel());
        } else {
            this.setResultComponent((JComponent)resultComp);
        }
        this.update();
    }

    public JComponent getQueryComponent() {
        return this._queryComponent;
    }

    public void setResultComponent(JComponent component) {
        if (component == null || component == this._resultComponent) {
            return;
        }
        if (this._resultComponent != null) {
            if (this._resultComponent instanceof TableDisplayTool) {
                // empty if block
            }
            this._resultPanel.remove(this._resultComponent);
            this._resultComponent = null;
        }
        this._resultComponent = component;
        if (this._queryComponent != null) {
            this._queryResultComponentMap.put(this._queryComponent, this._resultComponent);
        }
        this._resultPanel.add((Component)this._resultComponent, "Center");
        this.update();
        this._resultComponentChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CatalogNavigator.this._resultSplitPane.resetToPreferredSizes();
            }
        });
    }

    public JComponent getResultComponent() {
        return this._resultComponent;
    }

    protected void _resultComponentChanged() {
        this._saveAsAction.setEnabled(this._resultComponent instanceof Saveable);
        this._printAction.setEnabled(this._resultComponent instanceof PrintableWithDialog);
        boolean isTable = this._resultComponent instanceof TableDisplayTool;
        this._saveWithImageAction.setEnabled(isTable);
        this._deleteSelectedRowsAction.setEnabled(isTable);
        this._addRowAction.setEnabled(isTable);
        this.fireChange(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CatalogNavigator.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CatalogNavigator.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChange(ChangeEvent e) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? CatalogNavigator.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    protected void addToHistory() {
        if (this._queryComponent == null) {
            return;
        }
        CatalogHistoryItem historyItem = this.makeCatalogHistoryItem();
        if (historyItem == null) {
            return;
        }
        if (!this._noStack) {
            this._backStack.push(historyItem);
            this._backAction.setEnabled(true);
            if (this._forwStack.size() != 0) {
                this.cleanupHistoryStack(this._forwStack);
                this._forwStack.clear();
                this._forwAction.setEnabled(false);
            }
        }
        this.addToHistory(historyItem);
    }

    protected void addToHistory(CatalogHistoryItem historyItem) {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            CatalogHistoryItem item = (CatalogHistoryItem)it.next();
            if (item.name.equals(historyItem.name)) {
                this._historyList.remove(i);
            }
            ++i;
        }
        this._historyList.addFirst(historyItem);
        if (this._historyList.size() > this._maxHistoryItems) {
            this._historyList.removeLast();
        }
    }

    protected CatalogHistoryItem makeCatalogHistoryItem() {
        String s = this._queryComponent.getName();
        if (s != null) {
            return new CatalogHistoryItem(s, this._origURL, this._queryComponent);
        }
        return null;
    }

    public int getMaxHistoryItems() {
        return this._maxHistoryItems;
    }

    public void setMaxHistoryItems(int n) {
        this._maxHistoryItems = n;
    }

    public void addHistoryMenuItems(JMenu menu) {
        ListIterator it = this._historyList.listIterator(0);
        while (it.hasNext()) {
            menu.add((CatalogHistoryItem)it.next());
        }
    }

    protected void cleanupHistoryList() {
        ListIterator it = this._historyList.listIterator(0);
        while (it.hasNext()) {
            CatalogHistoryItem item = (CatalogHistoryItem)it.next();
            if (item.getURLStr() != null) continue;
            it.remove();
        }
    }

    protected void cleanupHistoryStack(Stack stack) {
        this.unplot(stack);
    }

    protected LinkedList mergeHistoryList() {
        LinkedList savedHistory = this._historyList;
        this.loadHistory();
        ListIterator it = savedHistory.listIterator(savedHistory.size() - 1);
        while (it.hasPrevious()) {
            this.addToHistory((CatalogHistoryItem)it.previous());
        }
        return this._historyList;
    }

    protected void clearHistory() {
        this._historyList = new LinkedList();
        this._backAction.setEnabled(false);
        this._backStack.clear();
        this._forwAction.setEnabled(false);
        this._forwStack.clear();
        this.saveHistory(false);
    }

    protected void saveHistory(boolean merge) {
        try {
            LinkedList l = merge ? this.mergeHistoryList() : this._historyList;
            Preferences.getPreferences().serialize(HISTORY_LIST_NAME, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadHistory() {
        try {
            this._historyList = (LinkedList)Preferences.getPreferences().deserialize(HISTORY_LIST_NAME);
            this.cleanupHistoryList();
        }
        catch (Exception e) {
            this._historyList = new LinkedList();
        }
    }

    public void setOrigURL(URL url) {
        this._origURL = url;
    }

    protected void unplot(Stack stack) {
        int n = stack.size();
        for (int i = 0; i < n; ++i) {
            CatalogHistoryItem item = (CatalogHistoryItem)stack.get(i);
            Object resultComp = this._queryResultComponentMap.get(item.queryComponent);
            if (!(resultComp instanceof TableDisplayTool)) continue;
            ((TableDisplayTool)resultComp).unplot();
        }
    }

    public void unplot() {
        Enumeration e = this._queryResultComponentMap.elements();
        while (e.hasMoreElements()) {
            JComponent comp = (JComponent)e.nextElement();
            if (!(comp instanceof TableDisplayTool)) continue;
            ((TableDisplayTool)comp).unplot();
        }
    }

    protected void update() {
        this._queryPanel.revalidate();
        this._resultPanel.revalidate();
        this._parent.repaint();
    }

    protected void updateTreeSelection() {
        if (this._queryComponent instanceof CatalogQueryTool) {
            this._catalogTree.selectNode(((CatalogQueryTool)this._queryComponent).getCatalog());
            this._updateTitle(((CatalogQueryTool)this._queryComponent).getCatalog());
        } else if (this._queryComponent instanceof TableDisplayTool) {
            this._catalogTree.selectNode(((TableDisplayTool)this._queryComponent).getTable());
        }
    }

    public QueryResult getQueryResult() {
        return this._queryResult;
    }

    public void setQueryResult(QueryResult queryResult) {
        if (queryResult == null) {
            return;
        }
        if (this._worker != null) {
            DialogUtil.error(_I18N.getString("queryInProgress"));
            return;
        }
        this._queryResult = queryResult;
        boolean isLocal = true;
        if (queryResult instanceof URLQueryResult) {
            URLQueryResult uqr = (URLQueryResult)queryResult;
            URL url = uqr.getURL();
            isLocal = url.getProtocol().equals("file");
        } else if (queryResult instanceof Catalog) {
            isLocal = ((Catalog)queryResult).isLocal();
        }
        if (isLocal) {
            this.setComponent(this.makeQueryResultComponent(queryResult));
        } else {
            this.makeProgressPanel();
            this._worker = new SwingWorker(){
                JComponent component;

                public Object construct() {
                    this.component = CatalogNavigator.this.makeQueryResultComponent();
                    return this.component;
                }

                public void finished() {
                    CatalogNavigator.this._worker = null;
                    CatalogNavigator.this._progressPanel.stop();
                    CatalogNavigator.this.setComponent(this.component);
                }
            };
            this._worker.start();
        }
    }

    private void _updateTitle(Catalog catalog) {
        String title = _I18N.getString("catalogNavigator");
        String s = catalog.getTitle();
        if (s != null && s.length() > 0) {
            title = title + " - " + s;
        }
        if (this._parent != null) {
            if (this._parent instanceof JFrame) {
                ((JFrame)this._parent).setTitle(title);
            } else {
                ((JInternalFrame)this._parent).setTitle(title);
            }
        }
    }

    protected void makeProgressPanel() {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel(_I18N.getString("accessingCatalogServer"), this._parent);
            this._progressPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (CatalogNavigator.this._worker != null) {
                        CatalogNavigator.this._worker.interrupt();
                        CatalogNavigator.this._worker = null;
                    }
                }
            });
        }
    }

    protected JComponent makeQueryResultComponent() {
        return this.makeQueryResultComponent(this._queryResult);
    }

    protected JComponent makeQueryResultComponent(QueryResult queryResult) {
        this._origURL = null;
        try {
            JComponent c;
            if (queryResult instanceof CatalogUIHandler && (c = ((CatalogUIHandler)((Object)queryResult)).makeComponent(this)) != null) {
                return c;
            }
            if (queryResult instanceof CatalogDirectory) {
                return this.makeCatalogDirectoryComponent((CatalogDirectory)queryResult);
            }
            if (queryResult instanceof TableQueryResult) {
                return this.makeTableQueryResultComponent((TableQueryResult)queryResult);
            }
            if (queryResult instanceof Catalog) {
                return this.makeCatalogComponent((Catalog)queryResult);
            }
            if (queryResult instanceof URLQueryResult) {
                URL url = ((URLQueryResult)queryResult).getURL();
                return this.makeURLComponent(url);
            }
        }
        catch (Exception e) {
            if (this._progressPanel != null) {
                this._progressPanel.stop();
            }
            DialogUtil.error(e);
        }
        return new EmptyPanel();
    }

    protected JComponent makeCatalogDirectoryComponent(CatalogDirectory catalogDirectory) {
        int numCatalogs = catalogDirectory.getNumCatalogs();
        if (numCatalogs == 0) {
            return this.makeCatalogComponent(catalogDirectory);
        }
        if (numCatalogs == 1) {
            return this.makeCatalogComponent(catalogDirectory.getCatalog(0));
        }
        return new EmptyPanel();
    }

    protected JComponent makeTableQueryResultComponent(TableQueryResult tableQueryResult) {
        TableDisplayTool tdt;
        if (this._resultComponent instanceof TableDisplayTool && (tdt = (TableDisplayTool)this._resultComponent).getTable().getName().equals(tableQueryResult.getName())) {
            tdt.setQueryResult(tableQueryResult);
            return tdt;
        }
        TableDisplayTool t = new TableDisplayTool(tableQueryResult, this, this._plotter);
        this.makeTablePopupMenu(t);
        return t;
    }

    protected void makeTablePopupMenu(TableDisplayTool t) {
        final JPopupMenu m = new JPopupMenu();
        m.add(this._addRowAction);
        m.add(this._deleteSelectedRowsAction);
        t.getTableDisplay().getTable().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    m.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    m.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    protected JComponent makeCatalogComponent(Catalog catalog) {
        if (catalog instanceof CatalogDirectory) {
            CatalogDirectory catalogDirectory = (CatalogDirectory)catalog;
            int numCatalogs = catalogDirectory.getNumCatalogs();
            if (numCatalogs == 1) {
                Catalog c = catalogDirectory.getCatalog(0);
                if (c instanceof TableQueryResult) {
                    return this.makeTableQueryResultComponent((TableQueryResult)c);
                }
                DialogUtil.error(_I18N.getString("subCatalogError") + ": " + c);
                return new EmptyPanel();
            }
            if (numCatalogs > 1) {
                return this.makeTableQueryResultComponent(catalogDirectory.getCatalogList());
            }
        }
        if (catalog instanceof TableQueryResult) {
            return this.makeTableQueryResultComponent((TableQueryResult)catalog);
        }
        CatalogQueryTool panel = this.makeCatalogQueryTool(catalog);
        return panel;
    }

    protected CatalogQueryTool makeCatalogQueryTool(Catalog catalog) {
        return new CatalogQueryTool(catalog, this);
    }

    protected JComponent makeURLComponent(URL url) throws IOException {
        try {
            URLConnection connection = url.getProtocol().equals("file") ? url.openConnection() : this._progressPanel.openConnection(url);
            if (connection == null) {
                return this._queryComponent;
            }
            int contentLength = connection.getContentLength();
            String contentType = connection.getContentType();
            if (contentType == null) {
                contentType = "unknown";
            }
            return this.makeURLComponent(url, contentType);
        }
        catch (ProgressException e) {
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        if (this._resultComponent != null) {
            return this._resultComponent;
        }
        return new EmptyPanel();
    }

    protected JComponent makeURLComponent(URL url, String contentType) throws IOException {
        String filename = url.getFile();
        if (contentType.equals("text/html") || filename.endsWith(".html")) {
            this.displayHTMLPage(url);
            return this._resultComponent;
        }
        if (contentType.equals("text/plain")) {
            this.displayPlainText(url);
            return this._resultComponent;
        }
        return this.makeUnknownURLComponent(url, contentType);
    }

    public void displayHTMLPage(URL url) {
        if (this._htmlViewerFrame != null) {
            if (this._htmlViewerFrame instanceof HTMLViewerFrame) {
                ((HTMLViewerFrame)this._htmlViewerFrame).getHTMLViewer().setPage(url);
                ((HTMLViewerFrame)this._htmlViewerFrame).setState(0);
                this._htmlViewerFrame.setVisible(true);
            } else if (this._htmlViewerFrame instanceof HTMLViewerInternalFrame) {
                ((HTMLViewerInternalFrame)this._htmlViewerFrame).getHTMLViewer().setPage(url);
                this._htmlViewerFrame.setVisible(true);
            }
            return;
        }
        if (this._desktop != null) {
            this._htmlViewerFrame = new HTMLViewerInternalFrame();
            ((HTMLViewerInternalFrame)this._htmlViewerFrame).getHTMLViewer().setPage(url);
            this._desktop.add(this._htmlViewerFrame, JLayeredPane.DEFAULT_LAYER);
            this._desktop.moveToFront(this._htmlViewerFrame);
        } else {
            this._htmlViewerFrame = new HTMLViewerFrame();
            ((HTMLViewerFrame)this._htmlViewerFrame).getHTMLViewer().setPage(url);
        }
    }

    public void displayPlainText(URL url) {
        try {
            String msg = FileUtil.getURL(url);
            if (this._progressPanel != null) {
                this._progressPanel.stop();
            }
            if (msg.length() < 256) {
                DialogUtil.error(msg);
            } else {
                this.displayHTMLPage(url);
            }
        }
        catch (IOException e) {
            DialogUtil.error(e);
        }
    }

    protected JComponent makeUnknownURLComponent(URL url, String contentType) {
        if (this._resultComponent != null) {
            return this._resultComponent;
        }
        return new EmptyPanel();
    }

    public void open() {
        int option;
        if (_fileChooser == null) {
            _fileChooser = this.makeFileChooser();
        }
        if ((option = _fileChooser.showOpenDialog(this)) == 0 && _fileChooser.getSelectedFile() != null) {
            this.open(_fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected JFileChooser makeFileChooser() {
        JFileChooser _fileChooser = new JFileChooser(new File("."));
        return _fileChooser;
    }

    public void open(String fileOrUrl) {
        try {
            this.setQueryComponent(new EmptyPanel());
            URL url = FileUtil.makeURL(null, fileOrUrl);
            URLQueryResult _queryResult = new URLQueryResult(url);
            String filename = url.getFile();
            if (filename.endsWith(".xml")) {
                this._catalogTree.setQueryResult(_queryResult);
            } else {
                this.setQueryResult(_queryResult);
            }
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void exit() {
        System.exit(0);
    }

    public void close() {
        if (this._parent != null) {
            this._parent.setVisible(false);
        }
    }

    public void back() {
        Catalog cat;
        if (this._backStack.size() == 0) {
            return;
        }
        if (this._queryComponent != null) {
            this._queryPanel.remove(this._queryComponent);
            URL url = this._origURL;
            CatalogHistoryItem item = this.makeCatalogHistoryItem();
            this._origURL = url;
            if (item != null) {
                this._forwStack.push(item);
                this._forwAction.setEnabled(true);
            }
        }
        CatalogHistoryItem historyItem = (CatalogHistoryItem)this._backStack.pop();
        if (this._backStack.size() == 0) {
            this._backAction.setEnabled(false);
        }
        CatalogNavigatorMenuBar.setCurrentCatalogNavigator(this);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
        if (historyItem.queryComponent != null && (cat = (Catalog)this._panelTreeNodeTable.get(historyItem.queryComponent)) != null) {
            this._catalogTree.selectNode(cat);
        }
        this.update();
    }

    public void forward() {
        Catalog cat;
        if (this._forwStack.size() == 0) {
            return;
        }
        if (this._queryComponent != null) {
            this._queryPanel.remove(this._queryComponent);
            URL url = this._origURL;
            CatalogHistoryItem item = this.makeCatalogHistoryItem();
            this._origURL = url;
            if (item != null) {
                this._backStack.push(item);
                this._backAction.setEnabled(true);
            }
        }
        CatalogHistoryItem historyItem = (CatalogHistoryItem)this._forwStack.pop();
        if (this._forwStack.size() == 0) {
            this._forwAction.setEnabled(false);
        }
        CatalogNavigatorMenuBar.setCurrentCatalogNavigator(this);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
        if (historyItem.queryComponent != null && (cat = (Catalog)this._panelTreeNodeTable.get(historyItem.queryComponent)) != null) {
            this._catalogTree.selectNode(cat);
        }
        this.update();
    }

    public AbstractAction getOpenAction() {
        return this._openAction;
    }

    public AbstractAction getSaveAsAction() {
        return this._saveAsAction;
    }

    public AbstractAction getSaveAsHTMLAction() {
        return this._saveAsHTMLAction;
    }

    public AbstractAction getSaveWithImageAction() {
        return this._saveWithImageAction;
    }

    public AbstractAction getPrintAction() {
        return this._printAction;
    }

    public AbstractAction getBackAction() {
        return this._backAction;
    }

    public AbstractAction getForwAction() {
        return this._forwAction;
    }

    public AbstractAction getAddRowAction() {
        return this._addRowAction;
    }

    public AbstractAction getDeleteSelectedRowsAction() {
        return this._deleteSelectedRowsAction;
    }

    public Component getRootComponent() {
        return this._parent;
    }

    public void openURL() {
        String urlStr = DialogUtil.input(_I18N.getString("enterURLDisplay") + ":");
        if (urlStr != null) {
            URL url = null;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                DialogUtil.error(e);
                return;
            }
            this.setQueryResult(new URLQueryResult(url));
        }
    }

    public void clear() {
        this.setQueryComponent(new EmptyPanel());
        this._origURL = null;
    }

    public void saveAs() {
        if (this._resultComponent instanceof Saveable) {
            int option;
            if (_fileChooser == null) {
                _fileChooser = this.makeFileChooser();
            }
            if ((option = _fileChooser.showSaveDialog(this)) == 0 && _fileChooser.getSelectedFile() != null) {
                this.saveAs(_fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else {
            DialogUtil.error(_I18N.getString("saveNotSupportedForObjType"));
        }
    }

    public void saveAs(String filename) {
        if (this._resultComponent instanceof Saveable) {
            try {
                ((Saveable)((Object)this._resultComponent)).saveAs(filename);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        } else {
            DialogUtil.error(_I18N.getString("saveNotSupportedForObjType"));
        }
    }

    public void saveWithImage() {
    }

    public void saveAsHTML() {
        if (this._resultComponent instanceof SaveableAsHTML) {
            int option;
            if (_fileChooser == null) {
                _fileChooser = this.makeFileChooser();
            }
            if ((option = _fileChooser.showSaveDialog(this)) == 0 && _fileChooser.getSelectedFile() != null) {
                this.saveAsHTML(_fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else {
            DialogUtil.error(_I18N.getString("htmlOutputNotSupportedForObjType"));
        }
    }

    public void saveAsHTML(String filename) {
        if (this._resultComponent instanceof SaveableAsHTML) {
            try {
                ((SaveableAsHTML)((Object)this._resultComponent)).saveAsHTML(filename);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        } else {
            DialogUtil.error(_I18N.getString("htmlOutputNotSupportedForObjType"));
        }
    }

    public void print() {
        if (this._resultComponent instanceof PrintableWithDialog) {
            try {
                ((PrintableWithDialog)((Object)this._resultComponent)).print();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        } else {
            DialogUtil.error(_I18N.getString("printingNotSupportedForObjType"));
        }
    }

    public void addRow() {
        if (this._resultComponent instanceof TableDisplayTool) {
            ((TableDisplayTool)this._resultComponent).addRow();
        }
    }

    public void deleteSelectedRows() {
        if (this._resultComponent instanceof TableDisplayTool) {
            ((TableDisplayTool)this._resultComponent).deleteSelectedRows();
        }
    }

    public void setTableCellsEditable(boolean b) {
        if (this._resultComponent instanceof TableDisplayTool) {
            ((TableDisplayTool)this._resultComponent).setTableCellsEditable(b);
        }
    }

    public boolean isMainWindow() {
        return _mainWindowFlag;
    }

    public static void setMainWindow(boolean b) {
        _mainWindowFlag = b;
    }

    protected ProgressPanel getProgressPanel() {
        return this._progressPanel;
    }

    protected Stack getBackStack() {
        return this._backStack;
    }

    protected Stack getForwStack() {
        return this._forwStack;
    }

    protected LinkedList getHistoryList() {
        return this._historyList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class EmptyPanel
    extends JPanel
    implements QueryResultDisplay {
        public void setQueryResult(QueryResult queryResult) {
            throw new RuntimeException(_I18N.getString("queryResultDisplayError"));
        }
    }
}

