/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PrinterException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.TestTableQueryResult;
import jsky.catalog.gui.HyperlinkTableCellEditor;
import jsky.catalog.gui.HyperlinkTableCellRenderer;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.Preferences;
import jsky.util.PrintableWithDialog;
import jsky.util.SaveableAsHTML;
import jsky.util.gui.ArrayTableCellRenderer;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.SexagesimalTableCellEditor;
import jsky.util.gui.SexagesimalTableCellRenderer;
import jsky.util.gui.SortedJTable;
import jsky.util.gui.TableUtil;

public class TableDisplay
extends JPanel
implements QueryResultDisplay,
PrintableWithDialog,
SaveableAsHTML {
    private TableQueryResult _tableQueryResult;
    private QueryResultDisplay _queryResultDisplay;
    private JScrollPane _scrollPane;
    private SortedJTable _table;
    private int _sumColWidths = 0;
    private boolean[] _show;
    private static Hashtable _showTab = new Hashtable();
    private static String SHOW_TAB_FILE_NAME = "tableDisplayShowTab";

    public TableDisplay(TableQueryResult tableQueryResult, QueryResultDisplay queryResultDisplay) {
        this._queryResultDisplay = queryResultDisplay;
        this._table = new SortedJTable();
        this.setBackground(Color.white);
        if (tableQueryResult != null) {
            this.setModel(tableQueryResult);
        }
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(false);
        JTableHeader header = this._table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        header.setFont(header.getFont().deriveFont(1));
        this.setLayout(new BorderLayout());
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TableDisplay.this.resize();
            }
        });
    }

    public TableDisplay(TableQueryResult tableQueryResult) {
        this(tableQueryResult, null);
    }

    public TableDisplay(QueryResultDisplay queryResultDisplay) {
        this(null, queryResultDisplay);
    }

    public TableDisplay() {
        this(null, null);
    }

    public SortedJTable getTable() {
        return this._table;
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void setQueryResultDisplay(QueryResultDisplay q) {
        this._queryResultDisplay = q;
    }

    public QueryResultDisplay getQueryResultDisplay() {
        return this._queryResultDisplay;
    }

    public void setQueryResult(QueryResult queryResult) {
        if (queryResult instanceof TableQueryResult) {
            this.setModel((TableQueryResult)queryResult);
        }
    }

    public TableQueryResult getTableQueryResult() {
        return this._tableQueryResult;
    }

    public void setModel(TableQueryResult tableQueryResult) {
        this._tableQueryResult = tableQueryResult;
        Object o = _showTab.get(this._tableQueryResult.getName());
        if (o != null) {
            this._show = (boolean[])o;
            if (this._show.length != this._tableQueryResult.getColumnCount()) {
                this._show = null;
            }
        }
        this._table.setModel(tableQueryResult);
        this.setColumnRenderers();
        this._sumColWidths = TableUtil.initColumnSizes(this._table, this._show);
    }

    public void update() {
        this._table.setModel(this._tableQueryResult);
        this.setColumnRenderers();
        this._sumColWidths = TableUtil.initColumnSizes(this._table, this._show);
    }

    protected void setColumnRenderers() {
        int numCols = this._tableQueryResult.getColumnCount();
        for (int col = 0; col < numCols; ++col) {
            FieldDesc field = this._tableQueryResult.getColumnDesc(col);
            TableColumn column = this._table.getColumn(this._tableQueryResult.getColumnName(col));
            if (field.hasLink()) {
                column.setCellRenderer(new HyperlinkTableCellRenderer(field, this._tableQueryResult));
                column.setCellEditor(new HyperlinkTableCellEditor(field, this._tableQueryResult, this._queryResultDisplay));
                continue;
            }
            if (field.isRA()) {
                column.setCellRenderer(new SexagesimalTableCellRenderer(true));
                column.setCellEditor(new SexagesimalTableCellEditor(true));
                continue;
            }
            if (field.isDec()) {
                column.setCellRenderer(new SexagesimalTableCellRenderer(false));
                column.setCellEditor(new SexagesimalTableCellEditor(false));
                continue;
            }
            Class<?> c = this._tableQueryResult.getColumnClass(col);
            if (c == null || !c.isArray()) continue;
            column.setCellRenderer(new ArrayTableCellRenderer(c));
        }
    }

    public void print(String title) throws PrinterException {
        this._table.setTitle(title);
        this._table.print();
    }

    public void print() throws PrinterException {
        this._table.print();
    }

    public void resize() {
        if (this._tableQueryResult == null) {
            return;
        }
        int numCols = this._tableQueryResult.getColumnCount();
        if (numCols == 1) {
            this._table.setAutoResizeMode(4);
            this._table.sizeColumnsToFit(0);
        } else if (this._sumColWidths < this.getWidth()) {
            this._table.setAutoResizeMode(3);
        } else {
            this._table.setAutoResizeMode(0);
        }
    }

    public void selectRow(int row) {
        row = this._table.getUnsortedRowIndex(row);
        ListSelectionModel model = this._table.getSelectionModel();
        model.addSelectionInterval(row, row);
        BoundedRangeModel brm = this._scrollPane.getVerticalScrollBar().getModel();
        int min = brm.getMinimum();
        int max = brm.getMaximum();
        int value = brm.getValue();
        int extent = brm.getExtent();
        int newvalue = row * (max - min) / this._tableQueryResult.getRowCount();
        if (newvalue < value || newvalue > value + extent) {
            brm.setValue(newvalue - extent / 2);
        }
    }

    public void deselectRow(int row) {
        row = this._table.getUnsortedRowIndex(row);
        this._table.getSelectionModel().removeSelectionInterval(row, row);
    }

    public boolean[] getShow() {
        return this._show;
    }

    public void setShow(boolean[] show) {
        this._show = show;
        this._sumColWidths = TableUtil.initColumnSizes(this._table, this._show);
        if (this._show != null) {
            _showTab.put(this._tableQueryResult.getName(), show);
        } else {
            _showTab.remove(this._tableQueryResult.getName());
        }
        this.update();
        try {
            Preferences.getPreferences().serialize(SHOW_TAB_FILE_NAME, _showTab);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveAsHTML(String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        int numCols = this._table.getColumnCount();
        int numRows = this._table.getRowCount();
        int n = numCols - 1;
        if (numCols == 0) {
            return;
        }
        PrintStream out = new PrintStream(os);
        out.println("<html>");
        out.println("<body>");
        out.println("<table BORDER COLS=" + numCols + " WIDTH=\"100%\" NOSAVE>");
        out.println("<caption>" + this._tableQueryResult.getTitle() + "</caption>");
        out.println("<tr>");
        for (int col = 0; col < numCols; ++col) {
            if (this._show != null && !this._show[col]) continue;
            out.println("<th>" + this._table.getColumnName(col) + "</th>");
        }
        out.println("</tr>");
        for (int row = 0; row < numRows; ++row) {
            out.println("<tr>");
            for (int col = 0; col < numCols; ++col) {
                Object o;
                if (this._show != null && !this._show[col]) continue;
                TableCellRenderer r = this._table.getCellRenderer(row, col);
                Component c = r.getTableCellRendererComponent(this._table, this._table.getValueAt(row, col), false, false, row, col);
                String s = null;
                s = c instanceof JLabel ? ((JLabel)((Object)r)).getText() : (c instanceof AbstractButton ? ((AbstractButton)((Object)r)).getText() : ((o = this._table.getValueAt(row, col)) != null ? o.toString() : " "));
                out.println("<td>" + s + "</td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TableDisplay");
        TableDisplay tableDisplay = new TableDisplay(new TestTableQueryResult());
        frame.getContentPane().add((Component)tableDisplay, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    static {
        try {
            _showTab = (Hashtable)Preferences.getPreferences().deserialize(SHOW_TAB_FILE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

