/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.irsa;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryArgs;
import jsky.catalog.gui.CatalogQueryPanel;
import jsky.catalog.irsa.IRSACatalog;
import jsky.catalog.irsa.IRSAFieldDesc;
import jsky.catalog.irsa.IRSAQueryArgs;
import jsky.util.gui.DialogUtil;

public class IRSACatalogQueryPanel
extends CatalogQueryPanel {
    private IRSACatalog _catalog = (IRSACatalog)this.getCatalog();
    private IRSAFieldDesc[] _columns;
    private String _sqlString;
    private FieldDesc _selectParam;
    private JComboBox _selectComboBox;

    public IRSACatalogQueryPanel(Catalog catalog) {
        super(catalog);
        try {
            this._columns = this._catalog.getFieldDesc();
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._selectParam = this._catalog.getParamDesc("Select");
        this._selectComboBox = (JComboBox)this.getComponentForLabel("Select");
        this._selectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IRSACatalogQueryPanel.this._updateSQLString();
            }
        });
        this._updateSQLString();
    }

    public String getSQLString() {
        return this._sqlString;
    }

    public void setSQLString(String s) {
        this._sqlString = s;
    }

    private void _updateSQLString() {
        int i = this._selectComboBox.getSelectedIndex();
        Integer value = (Integer)this._selectParam.getOptionValue(i);
        this._sqlString = "select ";
        if (value == IRSACatalog.MINI_COLUMN_LIST) {
            this._sqlString = this._sqlString + this._getMiniColumnList();
        } else if (value == IRSACatalog.SHORT_COLUMN_LIST) {
            this._sqlString = this._sqlString + this._getShortColumnList();
        } else if (value == IRSACatalog.STANDARD_COLUMN_LIST) {
            this._sqlString = this._sqlString + this._getStandardColumnList();
        } else if (value == IRSACatalog.ALL_COLUMNS) {
            this._sqlString = this._sqlString + this._getAllColumnList();
        } else if (value == IRSACatalog.CUSTOM_SQL) {
            this._sqlString = this._sqlString + this._getCustomColumnList();
        }
        this._sqlString = this._sqlString + " from " + this._catalog.getId();
    }

    private String _getMiniColumnList() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].isMini()) continue;
            l.add(this._columns[i].getName());
        }
        return this._getColumnList(l);
    }

    private String _getShortColumnList() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].isShort()) continue;
            l.add(this._columns[i].getName());
        }
        return this._getColumnList(l);
    }

    private String _getStandardColumnList() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].isStd()) continue;
            l.add(this._columns[i].getName());
        }
        return this._getColumnList(l);
    }

    private String _getAllColumnList() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this._columns.length; ++i) {
            l.add(this._columns[i].getName());
        }
        return this._getColumnList(l);
    }

    private String _getCustomColumnList() {
        return null;
    }

    private String _getColumnList(List l) {
        StringBuffer sb = new StringBuffer();
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            sb.append((String)l.get(i));
            if (i >= n - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public QueryArgs getQueryArgs() {
        IRSAQueryArgs queryArgs = new IRSAQueryArgs(this._catalog);
        this.initQueryArgs(queryArgs);
        return queryArgs;
    }

    public void initQueryArgs(QueryArgs queryArgs) {
        super.initQueryArgs(queryArgs);
        ((IRSAQueryArgs)queryArgs).setSQLString(this.getSQLString());
    }
}

