/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.skycat;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.RowCoordinates;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.catalog.skycat.SkycatPlotSymbol;
import jsky.util.NameValue;
import jsky.util.StringUtil;
import jsky.util.TclUtil;

public class SkycatConfigEntry {
    public static final String OBJECT = "Object";
    public static final String NAME_SERVER = "Name Server";
    public static final String RA = "RA";
    public static final String DEC = "Dec";
    public static final String EQUINOX = "Equinox";
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String MIN_RADIUS = "Min Radius";
    public static final String MAX_RADIUS = "Max Radius";
    public static final String MAX_OBJECTS = "Max Objects";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String J2000 = "2000";
    public static final String B1950 = "1950";
    private CatalogDirectory _configFile;
    private String _name;
    private String _longName;
    private String _shortName;
    private Properties _properties;
    private String _servType;
    private RowCoordinates _rowCoordinates;
    private String[] _urls;
    private FieldDescAdapter[] _paramDesc;
    private static NameValue[] _equinoxOptions = new NameValue[]{new NameValue("J2000", "2000"), new NameValue("B1950", "1950")};
    private TablePlotSymbol[] _symbols;
    private boolean _symbolsEdited = false;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public SkycatConfigEntry(SkycatConfigFile configFile, Properties properties) {
        this._configFile = configFile;
        this._properties = properties;
        this.parseProperties();
    }

    public SkycatConfigEntry(Properties properties) {
        this(SkycatConfigFile.getConfigFile(), properties);
    }

    public Properties getProperties() {
        return this._properties;
    }

    public CatalogDirectory getConfigFile() {
        return this._configFile;
    }

    public void setConfigFile(CatalogDirectory configFile) {
        this._configFile = configFile;
    }

    protected void parseProperties() {
        int mark;
        this._servType = this._properties.getProperty("serv_type");
        if (this._servType == null) {
            throw new RuntimeException("Missing 'serv_type' entry in catalog config file");
        }
        this._name = this._longName = this._properties.getProperty("long_name");
        if (this._servType.equals("local") && this._name != null) {
            this._name = new File(this._name).getName();
        }
        this._shortName = this._properties.getProperty("short_name");
        if (this._shortName == null) {
            this._shortName = this._name;
        }
        if (this._name == null) {
            throw new RuntimeException("Missing 'long_name' entry in catalog config file");
        }
        this._urls = new String[3];
        String cat_dir = this._properties.getProperty("url");
        if (cat_dir != null && (mark = cat_dir.indexOf("{") + 1) > 0 && cat_dir.indexOf("}") > -1) {
            String lmtmc = cat_dir.substring(mark, cat_dir.indexOf("}"));
            lmtmc = System.getProperty(lmtmc);
            mark = cat_dir.indexOf("/");
            cat_dir = cat_dir.substring(mark, cat_dir.length());
            cat_dir = lmtmc + cat_dir;
        }
        this._urls[0] = cat_dir;
        this._urls[1] = this._properties.getProperty("backup1");
        this._urls[2] = this._properties.getProperty("backup2");
        int idCol = -1;
        int raCol = -1;
        int decCol = -1;
        int xCol = -1;
        int yCol = -1;
        double equinox = 2000.0;
        boolean idColSet = false;
        boolean raColSet = false;
        boolean decColSet = false;
        boolean xColSet = false;
        boolean yColSet = false;
        try {
            idCol = Integer.parseInt(this.getProperty("id_col"));
            idColSet = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            raCol = Integer.parseInt(this.getProperty("ra_col"));
            raColSet = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            decCol = Integer.parseInt(this.getProperty("dec_col"));
            decColSet = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            equinox = Double.parseDouble(this.getProperty("equinox"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            xCol = Integer.parseInt(this.getProperty("x_col"));
            xColSet = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            yCol = Integer.parseInt(this.getProperty("y_col"));
            yColSet = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!idColSet) {
            idCol = 0;
        }
        if (!(raColSet || decColSet || xColSet || yColSet)) {
            raCol = 1;
            decCol = 2;
        }
        this._rowCoordinates = raCol >= 0 && decCol >= 0 ? new RowCoordinates(raCol, decCol, equinox) : (xCol >= 0 && yCol >= 0 ? new RowCoordinates(xCol, yCol) : new RowCoordinates());
        this._rowCoordinates.setIdCol(idCol);
    }

    protected void determineSearchParameters() {
        boolean isCatalog;
        boolean bl = isCatalog = this._servType.equals("catalog") || this._servType.equals("archive") || this._servType.equals("local");
        if (this._servType.equals("namesvr")) {
            this._paramDesc = new FieldDescAdapter[1];
            this._paramDesc[0] = new FieldDescAdapter(OBJECT);
            this._paramDesc[0].setDescription("Enter the name of the object");
        } else if (isCatalog || this._servType.equals("imagesvr")) {
            FieldDescAdapter p;
            Vector<FieldDescAdapter> params = new Vector<FieldDescAdapter>(10, 10);
            boolean hasCoords = false;
            if (this._rowCoordinates.isWCS()) {
                hasCoords = true;
                p = new FieldDescAdapter(OBJECT);
                p.setDescription("Enter the name of the object");
                params.add(p);
                p = new FieldDescAdapter(NAME_SERVER);
                p.setDescription("Select the name server to use to resolve the object name");
                List l = this._configFile.getNameServers();
                NameValue[] ar = new NameValue[l.size()];
                for (int i = 0; i < ar.length; ++i) {
                    Catalog cat = (Catalog)l.get(i);
                    ar[i] = new NameValue(cat.getName(), cat);
                }
                p.setOptions(ar);
                params.add(p);
                p = new FieldDescAdapter(RA);
                p.setIsRA(true);
                p.setDescription("Right Ascension in the selected equinox, format: hh:mm:ss.sss");
                params.add(p);
                p = new FieldDescAdapter(DEC);
                p.setDescription("Declination in the selected equinox, format: dd:mm:ss.sss");
                p.setIsDec(true);
                params.add(p);
                p = new FieldDescAdapter(EQUINOX);
                p.setDescription("Equinox of RA and Dec");
                p.setOptions(_equinoxOptions);
                params.add(p);
            } else if (this._rowCoordinates.isPix()) {
                hasCoords = true;
                p = new FieldDescAdapter(X);
                p.setDescription("The X pixel coordinate");
                p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = SkycatConfigEntry.class$("java.lang.Double")) : class$java$lang$Double);
                params.add(p);
                p = new FieldDescAdapter(Y);
                p.setDescription("The Y pixel coordinate");
                p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = SkycatConfigEntry.class$("java.lang.Double")) : class$java$lang$Double);
                params.add(p);
            }
            if (hasCoords) {
                if (isCatalog) {
                    p = new FieldDescAdapter(MIN_RADIUS);
                    p.setDescription("The minimum radius from the center coordinates in arcmin");
                    p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = SkycatConfigEntry.class$("java.lang.Double")) : class$java$lang$Double);
                    p.setUnits("arcmin");
                    params.add(p);
                    p = new FieldDescAdapter(MAX_RADIUS);
                    p.setDescription("The maximum radius from the center coordinates in arcmin");
                    p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = SkycatConfigEntry.class$("java.lang.Double")) : class$java$lang$Double);
                    p.setUnits("arcmin");
                    params.add(p);
                } else {
                    p = new FieldDescAdapter(WIDTH);
                    p.setDescription("The width about the center coordinates in arcmin");
                    p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = SkycatConfigEntry.class$("java.lang.Double")) : class$java$lang$Double);
                    p.setUnits("arcmin");
                    params.add(p);
                    p = new FieldDescAdapter(HEIGHT);
                    p.setDescription("The height about the center coordinates in arcmin");
                    p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = SkycatConfigEntry.class$("java.lang.Double")) : class$java$lang$Double);
                    p.setUnits("arcmin");
                    params.add(p);
                }
            }
            if (!this._servType.equals("local")) {
                this.checkSearchCols(params);
            }
            if (isCatalog) {
                p = new FieldDescAdapter(MAX_OBJECTS);
                p.setDescription("The maximum number of objects to return");
                p.setFieldClass(class$java$lang$Integer == null ? (class$java$lang$Integer = SkycatConfigEntry.class$("java.lang.Integer")) : class$java$lang$Integer);
                p.setDefaultValue(new Integer(1000));
                params.add(p);
            }
            this._paramDesc = new FieldDescAdapter[params.size()];
            params.toArray(this._paramDesc);
        } else {
            this._paramDesc = new FieldDescAdapter[0];
        }
    }

    protected void checkSearchCols(Vector params) {
        String searchCols = this.getProperty("search_cols");
        if (searchCols != null && searchCols.length() != 0) {
            StringTokenizer st = new StringTokenizer(searchCols, ":");
            int n = st.countTokens();
            for (int i = 0; i < n; ++i) {
                FieldDescAdapter p;
                String s = st.nextToken();
                String[] ar = TclUtil.splitList(s);
                if (ar.length == 3) {
                    p = new FieldDescAdapter(ar[1]);
                    p.setId(ar[0]);
                    p.setIsMin(true);
                    params.add(p);
                    p = new FieldDescAdapter(ar[2]);
                    p.setId(ar[0]);
                    p.setIsMax(true);
                    params.add(p);
                    continue;
                }
                if (ar.length == 2) {
                    p = new FieldDescAdapter(ar[1]);
                    params.add(p);
                    continue;
                }
                throw new RuntimeException("Invalid format for search columns specification: " + s);
            }
        }
    }

    public static NameValue[] getEquinoxOptions() {
        return _equinoxOptions;
    }

    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public URL getDocURL() {
        String s = this.getProperty("help");
        URL url = null;
        if (s != null) {
            try {
                url = new URL(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        return url;
    }

    public String getServType() {
        return this._servType;
    }

    public void setServType(String servType) {
        this._servType = servType;
    }

    public int getNumParams() {
        if (this._paramDesc == null) {
            this.determineSearchParameters();
        }
        return this._paramDesc.length;
    }

    public FieldDesc getParamDesc(int i) {
        if (this._paramDesc == null) {
            this.determineSearchParameters();
        }
        return this._paramDesc[i];
    }

    public FieldDesc getParamDesc(String name) {
        if (this._paramDesc == null) {
            this.determineSearchParameters();
        }
        for (int i = 0; i < this._paramDesc.length; ++i) {
            if (this._paramDesc[i] == null || !this._paramDesc[i].getName().equals(name)) continue;
            return this._paramDesc[i];
        }
        return null;
    }

    public void setParamDesc(FieldDescAdapter[] paramDesc) {
        this._paramDesc = paramDesc;
    }

    public String getShortName() {
        return this._shortName;
    }

    public String getLongName() {
        return this._longName;
    }

    public int getNumURLs() {
        return this._urls.length;
    }

    public String getURL(int n) {
        return this._urls[n];
    }

    public void setURLs(String[] urls) {
        this._urls = urls;
    }

    public RowCoordinates getRowCoordinates() {
        return this._rowCoordinates;
    }

    public int getNumSymbols() {
        return this.getSymbols().length;
    }

    public TablePlotSymbol getSymbolDesc(int i) {
        return this.getSymbols()[i];
    }

    public TablePlotSymbol[] getSymbols() {
        if (this._symbols == null) {
            this._symbols = this._parsePlotSymbolInfo();
        }
        return this._symbols;
    }

    public void setSymbols(TablePlotSymbol[] symbols) {
        this._symbols = symbols;
        String symbolInfo = TablePlotSymbol.getPlotSymbolInfo(symbols);
        if (symbolInfo != null) {
            this._properties.setProperty("symbol", symbolInfo);
        }
    }

    public void setSymbolsEdited(boolean edited) {
        this._symbolsEdited = edited;
    }

    public boolean isSymbolsEdited() {
        return this._symbolsEdited;
    }

    private TablePlotSymbol[] _parsePlotSymbolInfo() {
        String symbolInfo = this.getProperty("symbol");
        String[] ar = null;
        if (symbolInfo == null) {
            ar = new String[]{"", "square yellow", "4"};
        } else {
            ar = TclUtil.splitList(symbolInfo = StringUtil.replace(symbolInfo, ":", " : "));
            if (ar.length < 3) {
                throw new RuntimeException("Bad plot symbol entry: " + symbolInfo);
            }
        }
        TablePlotSymbol[] symbols = new TablePlotSymbol[(ar.length + 1) / 4];
        int n = 0;
        for (int i = 0; i < ar.length; i += 4) {
            if (ar.length > i + 3 && !ar[i + 3].equals(":") || ar.length < i + 3) {
                throw new RuntimeException("Bad plot symbol entry: " + symbolInfo);
            }
            symbols[n++] = new SkycatPlotSymbol(null, ar[i], ar[i + 1], ar[i + 2]);
        }
        return symbols;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

