/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.codec;

import ca.nrc.cadc.arch.io.FitsFilterInputStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.TiledImage;
import jsky.image.SimpleRenderedImage;
import jsky.image.fits.codec.FITSData;
import jsky.image.fits.codec.FITSDataByte;
import jsky.image.fits.codec.FITSDataDouble;
import jsky.image.fits.codec.FITSDataFloat;
import jsky.image.fits.codec.FITSDataInt;
import jsky.image.fits.codec.FITSDataShort;
import jsky.image.fits.codec.FITSDecodeParam;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import nom.tam.util.Cursor;

public class FITSImage
extends SimpleRenderedImage {
    private Fits _fits;
    private ImageHDU _hdu;
    private int _hduIndex = -1;
    private Header _header;
    private Data _data;
    private int _dataType;
    private FITSData _fitsData;
    private int[] _axes;
    private int _bitpix;
    private ImageTiler _tiler;
    private static int _defaultTileWidth = 256;
    private static int _defaultTileHeight = 256;
    private TileCache _tileCache = JAI.getDefaultInstance().getTileCache();
    private FITSDecodeParam _param;
    private static int _previewSize = 152;
    private boolean _empty = false;
    private float _scale = 1.0f;
    private int _subsample = 1;
    private MappedByteBuffer _byteBuffer;

    public FITSImage(SeekableStream input, FITSDecodeParam param, int page) throws IOException, FitsException {
        this._param = param;
        this._fits = new Fits((InputStream)input);
        this._fits.read();
        this.setHDU(page);
        input.close();
    }

    public FITSImage(String fileOrUrl) throws IOException, FitsException {
        try {
            this._fits = new Fits(fileOrUrl);
            this._fits.read();
        }
        catch (Exception e) {
            try {
                this._fits = new Fits((InputStream)new FitsFilterInputStream(this._getStream(fileOrUrl)));
                this._fits.read();
            }
            catch (Exception e2) {
                if (e instanceof FitsException) {
                    throw (FitsException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }
        this.setHDU(0);
    }

    public FITSImage(Fits fits, FITSDecodeParam param, int page) throws IOException, FitsException {
        this._fits = fits;
        this._param = param;
        this.setHDU(page);
    }

    public FITSImage(Object ar) throws IOException, FitsException {
        ImageData data = new ImageData(ar);
        Header header = new Header((Data)data);
        ImageHDU hdu = new ImageHDU(header, (Data)data);
        this._fits = new Fits();
        this._fits.addHDU((BasicHDU)hdu);
        this.setHDU(0);
    }

    public int getCurrentHDUIndex() {
        return this._hduIndex;
    }

    private BufferedInputStream _getStream(String fileOrUrl) throws IOException {
        URL url = this._getURL(fileOrUrl);
        InputStream stream = url.openStream();
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return (BufferedInputStream)stream;
    }

    public void close() {
        try {
            this._fits.getStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private URL _getURL(String fileOrUrl) throws MalformedURLException {
        URL url = null;
        if (fileOrUrl.startsWith("http:") || fileOrUrl.startsWith("file:") || fileOrUrl.startsWith("ftp:")) {
            url = new URL(fileOrUrl);
        } else {
            File file = new File(fileOrUrl);
            url = file.getAbsoluteFile().toURL();
        }
        return url;
    }

    public int getNumHDUs() {
        try {
            this._fits.read();
        }
        catch (FitsException e) {
            throw new RuntimeException(e);
        }
        return this._fits.getNumberOfHDUs();
    }

    public Fits getFits() {
        return this._fits;
    }

    public BasicHDU getHDU(int num) {
        BasicHDU hdu = null;
        try {
            hdu = this._fits.getHDU(num);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hdu;
    }

    public void update() {
    }

    public void setHDU(int num) throws IOException, FitsException {
        if (this._hduIndex == num) {
            return;
        }
        this._hduIndex = num;
        this._hdu = (ImageHDU)this._fits.getHDU(num);
        if (this._hdu != null) {
            this._tiler = this._hdu.getTiler();
            this._axes = this._hdu.getAxes();
            this._header = this._hdu.getHeader();
            this._data = this._hdu.getData();
            this._bitpix = this._hdu.getBitPix();
            this._empty = false;
        }
        if (this._hdu == null || this._axes == null) {
            this._tiler = null;
            this._axes = new int[2];
            this._axes[0] = 2;
            this._axes[1] = 2;
            this._header = null;
            this._data = null;
            this._bitpix = 8;
            this._empty = true;
            this._byteBuffer = null;
        }
        this.minX = 0;
        this.minY = 0;
        if (this._axes.length > 4) {
            throw new IOException("Expected NAXIS <= 4, but got: " + this._axes.length);
        }
        this._scale = 1.0f;
        this._subsample = 1;
        this._initFITSData();
    }

    public int getRealWidth() {
        return this._axes[this._axes.length - 1];
    }

    public int getRealHeight() {
        return this._axes[this._axes.length - 2];
    }

    public int getNAXIS() {
        return this._axes.length;
    }

    public ImageTiler getImageTiler() {
        return this._tiler;
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public float getScale() {
        return this._scale;
    }

    public int getSubsample() {
        return this._subsample;
    }

    public MappedByteBuffer getByteBuffer() {
        return this._byteBuffer;
    }

    public static void setDefaultTileWidth(int w) {
        _defaultTileWidth = w;
    }

    public static int getDefaultTileWidth() {
        return _defaultTileWidth;
    }

    public static void setDefaultTileHeight(int h) {
        _defaultTileHeight = h;
    }

    public static int getDefaultTileHeight() {
        return _defaultTileHeight;
    }

    public void clearTileCache() {
        this._tileCache.flush();
    }

    public Header getHeader() {
        return this._header;
    }

    public Object getProperty(String name) {
        if (name.equals("#num_pages")) {
            return Integer.toString(this.getNumHDUs());
        }
        if (name.equals("#preview_image")) {
            return this._getPreviewImage(_previewSize);
        }
        if (name.equals("#fits_image")) {
            return this;
        }
        return null;
    }

    public String[] getPropertyNames() {
        String[] names = new String[]{"#num_pages", "#preview_image", "#fits_image"};
        return names;
    }

    public Object getKeywordValue(String name) {
        HeaderCard card;
        if (this._header != null && (card = this._header.findCard(name)) != null) {
            String s = card.getValue();
            if (s != null) {
                return s;
            }
            return "";
        }
        return null;
    }

    public String getKeywordComment(String name) {
        String s;
        HeaderCard card = this._header.findCard(name);
        if (card != null && (s = card.getComment()) != null) {
            return s;
        }
        return "";
    }

    public String getKeywordValue(String name, String defaultValue) {
        Object o = this.getKeywordValue(name);
        if (o instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }

    public int getKeywordValue(String name, int defaultValue) {
        Object o = this.getKeywordValue(name);
        if (o != null) {
            return Integer.parseInt(o.toString());
        }
        return defaultValue;
    }

    public double getKeywordValue(String name, double defaultValue) {
        Object o = this.getKeywordValue(name);
        if (o != null) {
            return Double.parseDouble(o.toString());
        }
        return defaultValue;
    }

    public float getKeywordValue(String name, float defaultValue) {
        Object o = this.getKeywordValue(name);
        if (o != null) {
            return Float.parseFloat(o.toString());
        }
        return defaultValue;
    }

    public String[] getKeywords() {
        int index = 0;
        int numKeywords = this._header.getNumberOfCards();
        String[] names = new String[numKeywords];
        Cursor iter = this._header.iterator();
        while (iter.hasNext()) {
            HeaderCard hc = (HeaderCard)iter.next();
            String key = hc.getKey();
            if (key == null) {
                key = "";
            }
            names[index++] = key;
        }
        return names;
    }

    private TiledImage _getPreviewImage(int size) {
        int h;
        if (size == 0 || this._empty) {
            return null;
        }
        int w = this.getRealWidth();
        int factor = Math.max((w - 1) / size + 1, ((h = this.getRealHeight()) - 1) / size + 1);
        if (factor <= 1) {
            return null;
        }
        int tileWidth = w / factor;
        int tileHeight = h / factor;
        SampleModel sampleModel = this._initSampleModel(tileWidth, tileHeight);
        ColorModel colorModel = this._initColorModel(sampleModel);
        TiledImage tiledImage = new TiledImage(0, 0, tileWidth, tileHeight, 0, 0, sampleModel, colorModel);
        Point origin = new Point(0, 0);
        Raster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (Point)origin);
        try {
            raster = this._fitsData.getPreviewImage(raster, factor);
        }
        catch (EOFException e) {
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (raster == null) {
            return null;
        }
        tiledImage.setData(raster);
        return tiledImage;
    }

    public boolean setScale(float scale) throws IOException {
        boolean needsUpdate = false;
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        if (this._byteBuffer != null && scale != this._scale) {
            needsUpdate = true;
            this._scale = scale;
            this._subsample = this._scale < 1.0f ? Math.round(1.0f / this._scale) : 1;
            this._tileCache.flush();
            this._initImage();
        }
        return needsUpdate;
    }

    public boolean isYFlipped() {
        return this._byteBuffer != null;
    }

    private void _initImage() throws IOException {
        this.width = this._axes[this._axes.length - 1];
        this.height = this._axes[this._axes.length - 2];
        if (this.width != 0 && this.height != 0) {
            if (this._subsample != 1) {
                this.width /= this._subsample;
                this.height /= this._subsample;
            }
            this.tileWidth = _defaultTileWidth;
            if (this.width / this.tileWidth <= 1) {
                this.tileWidth = this.width;
            }
            this.tileHeight = _defaultTileHeight;
            if (this.height / this.tileHeight <= 1) {
                this.tileHeight = this.height;
            }
            this._dataType = this._getDataType();
            this.sampleModel = this._initSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = this._initColorModel(this.sampleModel);
            if (!this._empty) {
                this._initByteBuffer();
            }
        }
    }

    private ColorModel _initColorModel(SampleModel sampleModel) {
        return ImageCodec.createComponentColorModel((SampleModel)sampleModel);
    }

    private SampleModel _initSampleModel(int tileWidth, int tileHeight) {
        int[] bandOffsets = new int[]{0};
        int pixelStride = 1;
        int scanlineStride = tileWidth;
        return RasterFactory.createPixelInterleavedSampleModel((int)this._dataType, (int)tileWidth, (int)tileHeight, (int)pixelStride, (int)scanlineStride, (int[])bandOffsets);
    }

    private void _initByteBuffer() throws IOException {
        ArrayDataInput arrayDataInput = this._fits.getStream();
        if (arrayDataInput instanceof BufferedFile) {
            long headerSize = this._header.getSize();
            long offset = this._hdu.getFileOffset() + headerSize;
            long size = this._hdu.getSize() - headerSize;
            BufferedFile bufferedFile = (BufferedFile)arrayDataInput;
            FileChannel channel = bufferedFile.getChannel();
            this._byteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, offset, size);
        }
    }

    private void _initFITSData() throws IOException {
        this._initImage();
        switch (this._dataType) {
            case 2: {
                this._fitsData = new FITSDataShort(this);
                break;
            }
            case 0: {
                this._fitsData = new FITSDataByte(this);
                break;
            }
            case 3: {
                this._fitsData = new FITSDataInt(this);
                break;
            }
            case 4: {
                this._fitsData = new FITSDataFloat(this);
                break;
            }
            case 5: {
                this._fitsData = new FITSDataDouble(this);
                break;
            }
            default: {
                throw new RuntimeException("Unknonwn image data type: " + this._dataType);
            }
        }
    }

    private int _getDataType() {
        if (this._empty) {
            this._bitpix = 8;
            return 0;
        }
        switch (this._bitpix) {
            case 16: {
                return 2;
            }
            case 8: {
                return 0;
            }
            case 32: {
                return 3;
            }
            case -32: {
                return 4;
            }
            case -64: {
                return 5;
            }
        }
        throw new RuntimeException("Invalid BITPIX value: " + this._bitpix);
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (this._empty) {
            return RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (Point)new Point(0, 0));
        }
        Raster tile = this._tileCache.getTile((RenderedImage)this, tileX, tileY);
        if (tile == null) {
            Point origin = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
            tile = RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (Point)origin);
            this._fillTile(tile);
            this._tileCache.add((RenderedImage)this, tileX, tileY, tile);
        }
        return tile;
    }

    private Raster _fillTile(Raster tile) {
        try {
            this._fitsData.getTile(tile, this._subsample, this.width, this.height);
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return tile;
    }

    public static void setPreviewSize(int i) {
        _previewSize = i;
    }

    public static int getPreviewSize() {
        return _previewSize;
    }
}

