/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import jsky.image.ImageChangeEvent;
import jsky.image.fits.codec.FITSImage;
import jsky.image.gui.MainImageDisplay;
import jsky.util.gui.SortedJTable;
import jsky.util.gui.TableUtil;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;

public class FITSKeywords
extends JPanel {
    protected Component parent;
    protected MainImageDisplay imageDisplay;
    protected SortedJTable table;
    protected int sumColWidths = 0;

    public FITSKeywords(Component parent, MainImageDisplay imageDisplay) {
        this.parent = parent;
        this.imageDisplay = imageDisplay;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeTable(), "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        imageDisplay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewImage() && !e.isBefore()) {
                    FITSKeywords.this.updateDisplay();
                }
            }
        });
        this.updateDisplay();
    }

    JScrollPane makeTable() {
        this.table = new SortedJTable();
        this.table.setAutoResizeMode(0);
        this.table.setIntercellSpacing(new Dimension(6, 3));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        JTableHeader header = this.table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        header.setFont(header.getFont().deriveFont(1));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FITSKeywords.this.resize();
            }
        });
        return new JScrollPane(this.table);
    }

    public void resize() {
        if (this.sumColWidths < this.getWidth()) {
            this.table.setAutoResizeMode(3);
        } else {
            this.table.setAutoResizeMode(0);
        }
    }

    JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton closeButton = new JButton("Close");
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FITSKeywords.this.close();
            }
        });
        return panel;
    }

    public void updateDisplay() {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        if (fitsImage == null) {
            this.table.setModel(new DefaultTableModel());
            return;
        }
        this.updateDisplay(fitsImage.getCurrentHDUIndex());
    }

    public void updateDisplay(int hduIndex) {
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        BasicHDU hdu = null;
        if (fitsImage == null || (hdu = fitsImage.getHDU(hduIndex)) == null) {
            this.table.setModel(new DefaultTableModel());
            return;
        }
        Object[] columnNames = new String[]{"Keyword", "Value", "Comment"};
        Header header = hdu.getHeader();
        int numKeywords = header.getNumberOfCards();
        Object[][] values = new String[numKeywords][3];
        Cursor it = header.iterator();
        int n = 0;
        while (it.hasNext()) {
            HeaderCard card = (HeaderCard)it.next();
            String name = card.getKey();
            String value = card.getValue();
            String comment = card.getComment();
            values[n][0] = name;
            values[n][1] = value;
            values[n++][2] = comment;
        }
        this.table.setModel(new DefaultTableModel(values, columnNames));
        this.sumColWidths = TableUtil.initColumnSizes(this.table, null);
        this.resize();
        this.updateTitle(header.getStringValue("EXTNAME"));
    }

    protected void updateTitle(String title) {
        String s = "FITS Keywords";
        if (title != null) {
            s = s + ": " + title;
        }
        if (this.parent != null) {
            if (this.parent instanceof JFrame) {
                ((JFrame)this.parent).setTitle(s);
            } else {
                ((JInternalFrame)this.parent).setTitle(s);
            }
        }
    }

    void close() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
    }
}

