/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.BasicFigure;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class ImageFigure
extends BasicFigure
implements CanvasFigure {
    protected Object clientData;
    protected CanvasFigureListenerManager listenerManager = new CanvasFigureListenerManager(this);
    protected LinkedList slaves;

    public ImageFigure(Shape shape, Paint fill, Paint outline, float lineWidth, Interactor interactor) {
        super(shape, fill, lineWidth);
        if (interactor != null) {
            this.setInteractor(interactor);
        }
        this.setStrokePaint(outline);
    }

    public void setClientData(Object o) {
        this.clientData = o;
    }

    public Object getClientData() {
        return this.clientData;
    }

    public Rectangle2D getBoundsWithoutLabel() {
        return this.getBounds();
    }

    public boolean hit(Rectangle2D r) {
        return this.getShape().intersects(r);
    }

    public void setVisible(boolean flag) {
        SelectionModel model;
        Interactor interactor;
        super.setVisible(flag);
        if (!flag && (interactor = this.getInteractor()) instanceof SelectionInteractor && (model = ((SelectionInteractor)interactor).getSelectionModel()).containsSelection((Object)this)) {
            model.removeSelection((Object)this);
        }
        this.repaint();
    }

    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.addCanvasFigureListener(listener);
    }

    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.removeCanvasFigureListener(listener);
    }

    public void fireCanvasFigureEvent(int eventType) {
        this.listenerManager.fireCanvasFigureEvent(eventType);
    }

    public void addSlave(CanvasFigure fig) {
        if (this.slaves == null) {
            this.slaves = new LinkedList();
        }
        this.slaves.add(fig);
    }

    public void translate(double x, double y) {
        super.translate(x, y);
        if (this.slaves != null) {
            ListIterator it = this.slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = (Figure)it.next();
                fig.translate(x, y);
            }
        }
    }
}

