/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.geom.Point2D;
import javax.media.jai.PlanarImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.coords.CoordinateConverter;
import jsky.image.ImageProcessor;
import jsky.image.gui.BasicImageDisplay;

public class ImageCoordinateConverter
implements CoordinateConverter {
    private BasicImageDisplay _imageDisplay;
    private EventListenerList _listenerList = new EventListenerList();
    private ChangeEvent _changeEvent = new ChangeEvent(this);
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ImageCoordinateConverter(BasicImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
    }

    public BasicImageDisplay getImageDisplay() {
        return this._imageDisplay;
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ImageCoordinateConverter.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ImageCoordinateConverter.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChange() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? ImageCoordinateConverter.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this._changeEvent);
        }
    }

    public boolean isWCS() {
        return this._imageDisplay.getWCS() != null;
    }

    public Point2D.Double getWCSCenter() {
        return this._imageDisplay.getWCS().getWCSCenter();
    }

    public Point2D.Double getImageCenter() {
        return this._imageDisplay.getWCS().getImageCenter();
    }

    public double getEquinox() {
        if (this.isWCS()) {
            return this._imageDisplay.getWCS().getEquinox();
        }
        return 2000.0;
    }

    public double getWidthInDeg() {
        return this._imageDisplay.getWCS().getWidthInDeg();
    }

    public double getHeightInDeg() {
        return this._imageDisplay.getWCS().getHeightInDeg();
    }

    public double getWidth() {
        return this._imageDisplay.getImageWidth();
    }

    public double getHeight() {
        return this._imageDisplay.getImageHeight();
    }

    public void convertCoords(Point2D.Double p, int inType, int outType, boolean isDistance) {
        block0 : switch (inType) {
            case 0: {
                switch (outType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.imageToScreenCoords(p, isDistance);
                        break;
                    }
                    case 2: {
                        this.imageToCanvasCoords(p, isDistance);
                        break;
                    }
                    case 3: {
                        this.imageToUserCoords(p, isDistance);
                        break;
                    }
                    case 4: {
                        this.imageToWorldCoords(p, isDistance);
                    }
                }
                break;
            }
            case 1: {
                switch (outType) {
                    case 0: {
                        this.screenToImageCoords(p, isDistance);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.screenToCanvasCoords(p, isDistance);
                        break;
                    }
                    case 3: {
                        this.screenToUserCoords(p, isDistance);
                        break;
                    }
                    case 4: {
                        this.screenToWorldCoords(p, isDistance);
                    }
                }
                break;
            }
            case 2: {
                switch (outType) {
                    case 0: {
                        this.canvasToImageCoords(p, isDistance);
                        break;
                    }
                    case 1: {
                        this.canvasToScreenCoords(p, isDistance);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.canvasToUserCoords(p, isDistance);
                        break;
                    }
                    case 4: {
                        this.canvasToWorldCoords(p, isDistance);
                    }
                }
                break;
            }
            case 3: {
                switch (outType) {
                    case 0: {
                        this.userToImageCoords(p, isDistance);
                        break;
                    }
                    case 1: {
                        this.userToScreenCoords(p, isDistance);
                        break;
                    }
                    case 2: {
                        this.userToCanvasCoords(p, isDistance);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.userToWorldCoords(p, isDistance);
                    }
                }
                break;
            }
            case 4: {
                switch (outType) {
                    case 0: {
                        this.worldToImageCoords(p, isDistance);
                        break block0;
                    }
                    case 1: {
                        this.worldToScreenCoords(p, isDistance);
                        break block0;
                    }
                    case 2: {
                        this.worldToCanvasCoords(p, isDistance);
                        break block0;
                    }
                    case 3: {
                        this.worldToUserCoords(p, isDistance);
                        break block0;
                    }
                }
            }
        }
    }

    public void canvasToImageCoords(Point2D.Double p, boolean isDistance) {
        float scale = this._imageDisplay.getScale();
        p.x /= (double)scale;
        p.y /= (double)scale;
        if (!isDistance) {
            this.rotate(p, -1);
            this.flip(p);
            double f = scale > 1.0f ? 0.5 : 1.0;
            p.x += f;
            p.y += f;
        }
    }

    public void userToImageCoords(Point2D.Double p, boolean isDistance) {
        this.userToCanvasCoords(p, isDistance);
        this.canvasToImageCoords(p, isDistance);
    }

    public void canvasToUserCoords(Point2D.Double p, boolean isDistance) {
        float scale = this._imageDisplay.getScale();
        p.x /= (double)scale;
        p.y /= (double)scale;
        if (!isDistance) {
            this.rotate(p, -1);
        }
    }

    public void userToCanvasCoords(Point2D.Double p, boolean isDistance) {
        if (!isDistance) {
            this.rotate(p, 1);
        }
        float scale = this._imageDisplay.getScale();
        p.x *= (double)scale;
        p.y *= (double)scale;
    }

    public void imageToCanvasCoords(Point2D.Double p, boolean isDistance) {
        float scale = this._imageDisplay.getScale();
        if (!isDistance) {
            double f = scale > 1.0f ? 0.5 : 1.0;
            p.x -= f;
            p.y -= f;
            this.flip(p);
            this.rotate(p, 1);
        }
        p.x *= (double)scale;
        p.y *= (double)scale;
    }

    public void imageToUserCoords(Point2D.Double p, boolean isDistance) {
        this.imageToCanvasCoords(p, isDistance);
        this.canvasToUserCoords(p, isDistance);
    }

    public void canvasToScreenCoords(Point2D.Double p, boolean isDistance) {
        PlanarImage displayImage = this._imageDisplay.getDisplayImage();
        if (!isDistance && displayImage != null) {
            p.x += (double)displayImage.getMinX();
            p.y += (double)displayImage.getMinY();
        }
    }

    public void screenToCanvasCoords(Point2D.Double p, boolean isDistance) {
        PlanarImage displayImage = this._imageDisplay.getDisplayImage();
        if (!isDistance && displayImage != null) {
            p.x -= (double)displayImage.getMinX();
            p.y -= (double)displayImage.getMinY();
        }
    }

    public void screenToImageCoords(Point2D.Double p, boolean isDistance) {
        this.screenToCanvasCoords(p, isDistance);
        this.canvasToImageCoords(p, isDistance);
    }

    public void imageToScreenCoords(Point2D.Double p, boolean isDistance) {
        this.imageToCanvasCoords(p, isDistance);
        this.canvasToScreenCoords(p, isDistance);
    }

    public void screenToUserCoords(Point2D.Double p, boolean isDistance) {
        this.screenToCanvasCoords(p, isDistance);
        this.canvasToUserCoords(p, isDistance);
    }

    public void userToScreenCoords(Point2D.Double p, boolean isDistance) {
        this.userToCanvasCoords(p, isDistance);
        this.canvasToScreenCoords(p, isDistance);
    }

    public void imageToWorldCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this._imageDisplay.getWCS().imageToWorldCoords(p, isDistance);
    }

    public void screenToWorldCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this.screenToImageCoords(p, isDistance);
        this.imageToWorldCoords(p, isDistance);
    }

    public void canvasToWorldCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this.canvasToImageCoords(p, isDistance);
        this.imageToWorldCoords(p, isDistance);
    }

    public void userToWorldCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this.userToImageCoords(p, isDistance);
        this.imageToWorldCoords(p, isDistance);
    }

    public void worldToImageCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this._imageDisplay.getWCS().worldToImageCoords(p, isDistance);
    }

    public void worldToCanvasCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this.worldToImageCoords(p, isDistance);
        this.imageToCanvasCoords(p, isDistance);
    }

    public void worldToScreenCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this.worldToImageCoords(p, isDistance);
        this.imageToScreenCoords(p, isDistance);
    }

    public void worldToUserCoords(Point2D.Double p, boolean isDistance) {
        this.assertWCS();
        this.worldToImageCoords(p, isDistance);
        this.imageToUserCoords(p, isDistance);
    }

    public void flip(Point2D.Double p) {
        boolean flipY;
        float scale = this._imageDisplay.getScale();
        int c = scale > 1.0f ? 0 : 1;
        double x = p.x;
        double y = p.y;
        int width = this._imageDisplay.getImageWidth();
        int height = this._imageDisplay.getImageHeight();
        ImageProcessor imageProcessor = this._imageDisplay.getImageProcessor();
        boolean bl = flipY = imageProcessor.getFlipY() != imageProcessor.getReverseY();
        if (imageProcessor.isInvertedYAxis()) {
            boolean bl2 = flipY = !flipY;
        }
        if (flipY) {
            y = (double)(height - c) - y;
        }
        if (imageProcessor.getFlipX()) {
            x = (double)(width - c) - x;
        }
        p.setLocation(x, y);
    }

    public void rotate(Point2D.Double p, int factor) {
        ImageProcessor imageProcessor = this._imageDisplay.getImageProcessor();
        double angle = imageProcessor.getAngle() * (double)(-factor);
        if (angle == 0.0) {
            return;
        }
        double cx = (double)this._imageDisplay.getImageWidth() / 2.0;
        double cy = (double)this._imageDisplay.getImageHeight() / 2.0;
        p.x -= cx;
        p.y -= cy;
        double tmp = p.x;
        double cosa = Math.cos(angle);
        double sina = Math.sin(angle);
        p.x = p.x * cosa + p.y * sina + cx;
        p.y = -tmp * sina + p.y * cosa + cy;
    }

    public void assertWCS() {
        if (!this.isWCS()) {
            throw new RuntimeException("No world coordinate information available.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

