/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.data.DatasetChangeListener;
import com.jrefinery.data.XYDataset;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.media.jai.Histogram;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.image.BasicImageReadableProcessor;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.util.I18N;
import jsky.util.gui.VRangeSlider;

public class ImageCutLevels
extends JPanel {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImageCutLevels == null ? (class$jsky$image$gui$ImageCutLevels = ImageCutLevels.class$("jsky.image.gui.ImageCutLevels")) : class$jsky$image$gui$ImageCutLevels);
    protected Component parent;
    protected JFreeChart chart;
    protected ImageProcessor imageProcessor;
    protected BasicImageReadableProcessor imageDisplay;
    protected VRangeSlider rangeSlider;
    protected double lowCut = 0.0;
    protected double highCut = 0.0;
    protected int numValues = 0;
    protected boolean ignoreChangeEvents = false;
    protected static final int HISTOGRAM_SIZE = 2048;
    static /* synthetic */ Class class$jsky$image$gui$ImageCutLevels;

    public ImageCutLevels(final Component parent, BasicImageReadableProcessor imageDisplay) {
        this.parent = parent;
        this.imageDisplay = imageDisplay;
        this.imageProcessor = imageDisplay.getImageProcessor();
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeGraph(), "Center");
        JPanel bot = new JPanel();
        bot.setLayout(new BorderLayout());
        this.add((Component)bot, "South");
        bot.add((Component)this.makeControlPanel(), "North");
        bot.add((Component)this.makeButtonPanel(), "South");
        this.imageProcessor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (parent.isVisible() && e.isNewCutLevels()) {
                    ImageCutLevels.this.updateDisplay();
                }
            }
        });
        this.updateDisplay();
    }

    ChartPanel makeGraph() {
        String title = _I18N.getString("pixelValueDist");
        String xAxisLabel = _I18N.getString("pixelValue");
        String yAxisLabel = _I18N.getString("frequency");
        SimpleDataset data = new SimpleDataset();
        boolean legend = false;
        this.chart = ChartFactory.createXYChart(title, xAxisLabel, yAxisLabel, data, legend);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(250, 250));
        return chartPanel;
    }

    public void plotHistogram() {
        this.numValues = 2048;
        int dataType = this.imageProcessor.getRescaledSourceImage().getSampleModel().getDataType();
        boolean isFloatingPoint = dataType == 4 || dataType == 5;
        double n = this.highCut - this.lowCut;
        if (n < (double)this.numValues && !isFloatingPoint) {
            this.numValues = (int)n;
        }
        if (this.numValues <= 0) {
            this.chart.getPlot().setDataset(new SimpleDataset());
            return;
        }
        double[] xValues = new double[this.numValues];
        int[] yValues = new int[this.numValues];
        double m = this.lowCut;
        double factor = n / (double)this.numValues;
        int i = 0;
        while (i < this.numValues) {
            xValues[i] = m;
            yValues[i] = 0;
            ++i;
            m += factor;
        }
        if (factor >= 0.0) {
            Rectangle2D.Double region = this.imageDisplay.getVisibleArea();
            ROIShape roi = new ROIShape((Shape)region);
            Histogram histogram = this.imageProcessor.getHistogram(this.numValues, (ROI)roi);
            yValues = histogram.getBins(0);
            this.chart.getPlot().setDataset(new SimpleDataset(xValues, yValues));
        }
    }

    public void updateHistogram() {
    }

    JPanel makeControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)this.makeSliderPanel(), "North");
        panel.add((Component)this.makePercentPanel(), "South");
        return panel;
    }

    JPanel makeSliderPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.rangeSlider = new VRangeSlider(_I18N.getString("cutLevels"), this.imageProcessor.getMinValue(), this.imageProcessor.getMaxValue());
        this.rangeSlider.setValues(this.imageProcessor.getLowCut(), this.imageProcessor.getHighCut());
        this.rangeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                if (ImageCutLevels.this.ignoreChangeEvents) {
                    return;
                }
                ImageCutLevels.this.setCutLevels(ImageCutLevels.this.rangeSlider.getMinValue(), ImageCutLevels.this.rangeSlider.getMaxValue());
            }
        });
        panel.add((Component)this.rangeSlider, "North");
        return panel;
    }

    JPanel makePercentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JLabel label = new JLabel(_I18N.getString("autoSet") + ":");
        panel.add(label);
        String[] ar = new String[]{"90.0", "95.0", "98.0", "99.0", "99.5", "100.0"};
        for (int i = 0; i < ar.length; ++i) {
            JButton b = new JButton(ar[i] + "%");
            b.setToolTipText(_I18N.getString("cutLevelPercentTip", ar[i]));
            b.setActionCommand(ar[i]);
            panel.add(b);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ImageCutLevels.this.setByPercent(Double.parseDouble(ev.getActionCommand()));
                }
            });
        }
        return panel;
    }

    JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton resetButton = new JButton(_I18N.getString("reset"));
        resetButton.setToolTipText(_I18N.getString("resetCutLevelsTip"));
        panel.add(resetButton);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageCutLevels.this.reset();
            }
        });
        JButton medianFilterButton = new JButton(_I18N.getString("medianFilter"));
        panel.add(medianFilterButton);
        medianFilterButton.setToolTipText(_I18N.getString("medianFilterTip"));
        medianFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageCutLevels.this.medianFilter();
            }
        });
        JButton closeButton = new JButton(_I18N.getString("close"));
        closeButton.setToolTipText(_I18N.getString("closeTip"));
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageCutLevels.this.close();
            }
        });
        return panel;
    }

    void set() {
        this.imageProcessor.update();
    }

    void reset() {
        double minValue = this.imageProcessor.getMinValue();
        double maxValue = this.imageProcessor.getMaxValue();
        this.setCutLevels(minValue, maxValue);
    }

    void setCutLevels(double minVal, double maxVal) {
        this.lowCut = minVal;
        this.highCut = maxVal;
        this.imageProcessor.setCutLevels(minVal, maxVal);
        this.imageProcessor.update();
    }

    void setByPercent(double percent) {
        this.imageProcessor.autoSetCutLevels(percent, this.imageDisplay.getVisibleArea());
        this.imageProcessor.update();
    }

    void medianFilter() {
        this.imageProcessor.autoSetCutLevels(this.imageDisplay.getVisibleArea());
        this.imageProcessor.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDisplay() {
        this.ignoreChangeEvents = true;
        try {
            this.lowCut = this.imageProcessor.getLowCut();
            this.highCut = this.imageProcessor.getHighCut();
            this.plotHistogram();
            double minValue = this.imageProcessor.getMinValue();
            double maxValue = this.imageProcessor.getMaxValue();
            if (minValue != maxValue) {
                this.rangeSlider.setBounds(minValue, maxValue);
                this.rangeSlider.setValues(this.lowCut, this.highCut);
            }
        }
        finally {
            this.ignoreChangeEvents = false;
        }
    }

    void close() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SimpleDataset
    implements XYDataset {
        double[] xData;
        int[] yData;

        public SimpleDataset() {
        }

        public SimpleDataset(double[] xData, int[] yData) {
            this.xData = xData;
            this.yData = yData;
        }

        public int getSeriesCount() {
            return 1;
        }

        public String getSeriesName(int seriesIndex) {
            return "Pixels";
        }

        public void addChangeListener(DatasetChangeListener listener) {
        }

        public void removeChangeListener(DatasetChangeListener listener) {
        }

        public Number getXValue(int seriesIndex, int itemIndex) {
            if (this.xData == null) {
                return new Double(0.0);
            }
            return new Double(this.xData[itemIndex]);
        }

        public Number getYValue(int seriesIndex, int itemIndex) {
            if (this.yData == null) {
                return new Integer(0);
            }
            return new Integer(this.yData[itemIndex]);
        }

        public int getItemCount(int seriesIndex) {
            if (this.xData == null) {
                return 1;
            }
            return this.xData.length;
        }
    }
}

