/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jsky.image.GifEncoder;
import jsky.image.GreyscaleFilter;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GridBagUtil;

public class ImageSaveDialog
extends JFileChooser {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImageSaveDialog == null ? (class$jsky$image$gui$ImageSaveDialog = ImageSaveDialog.class$("jsky.image.gui.ImageSaveDialog")) : class$jsky$image$gui$ImageSaveDialog);
    protected MainImageDisplay imageDisplay;
    JRadioButton useAll;
    JRadioButton useView;
    JComboBox formatBox;
    protected static final String JPEG_TYPE = "JPEG";
    protected static final String GIF_TYPE = "GIF";
    protected static final String FITS_TYPE = "FITS";
    protected static final String TIFF_TYPE = "TIFF";
    protected static final String PNG_TYPE = "PNG";
    protected static final String PNM_TYPE = "PNM";
    protected static final String BMP_TYPE = "BMP";
    protected static final String[] VIEW_FILE_TYPES = new String[]{"JPEG", "GIF"};
    protected static final String[] SAVE_FILE_TYPES = new String[]{"FITS", "JPEG", "TIFF", "PNG", "PNM", "BMP"};
    protected static final int SAVE_CURRENT_VIEW = 1;
    protected static final int SAVE_ENTIRE_IMAGE = 2;
    static /* synthetic */ Class class$jsky$image$gui$ImageSaveDialog;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$awt$image$BufferedImage;

    public ImageSaveDialog(MainImageDisplay imageDisplay) {
        super(new File("."));
        this.imageDisplay = imageDisplay;
        this.createAccessoryPanel();
    }

    protected void createAccessoryPanel() {
        JPanel accessoryPanel = new JPanel();
        accessoryPanel.setLayout(new GridBagLayout());
        GridBagUtil layout = new GridBagUtil(accessoryPanel, (GridBagLayout)accessoryPanel.getLayout());
        accessoryPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.formatBox = new JComboBox();
        this.formatBox.setSelectedItem(JPEG_TYPE);
        this.formatBox.setToolTipText(_I18N.getString("selectFileFormat"));
        this.formatBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSaveDialog.this.updateFileSuffix();
            }
        });
        int r = 0;
        int none = 0;
        int west = 17;
        layout.add(new JLabel(_I18N.getString("saveAsType") + ":"), 0, r++, 1, 1, 0.0, 0.0, none, west);
        layout.add(this.formatBox, 0, r++, 1, 1, 0.0, 0.0, none, west);
        layout.add(new JLabel(" "), 0, r++, 1, 1, 0.0, 0.0, none, west);
        layout.add(new JLabel(_I18N.getString("options") + ":"), 0, r++, 1, 1, 0.0, 0.0, none, west);
        this.useAll = new JRadioButton(_I18N.getString("saveImage"));
        this.useAll.setToolTipText(_I18N.getString("saveImageAreaNoGraphics"));
        this.useAll.setSelected(true);
        this.useAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSaveDialog.this.updateFormatBox(false);
            }
        });
        this.useView = new JRadioButton(_I18N.getString("saveCurrentView"));
        this.useView.setToolTipText(_I18N.getString("saveImageAreaWithGraphics"));
        this.useView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSaveDialog.this.updateFormatBox(true);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.useAll);
        bg.add(this.useView);
        layout.add(this.useAll, 0, r++, 1, 1, 0.0, 0.0, none, west);
        layout.add(this.useView, 0, r++, 1, 1, 0.0, 0.0, none, west);
        this.setAccessory(accessoryPanel);
    }

    protected void updateFileSuffix() {
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        String filename = file.getName();
        String s = filename.toLowerCase();
        if (this.formatBox.getSelectedItem() == JPEG_TYPE) {
            if (!s.endsWith(".jpg") && !s.endsWith(".jpeg")) {
                this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(JPEG_TYPE))));
            }
        } else if (this.formatBox.getSelectedItem() == GIF_TYPE) {
            if (!s.endsWith(".gif")) {
                this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(GIF_TYPE))));
            }
        } else if (this.formatBox.getSelectedItem() == FITS_TYPE) {
            if (!s.endsWith(".fits") && !s.endsWith(".fts")) {
                this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(FITS_TYPE))));
            }
        } else if (this.formatBox.getSelectedItem() == PNG_TYPE) {
            if (!s.endsWith(".png")) {
                this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(PNG_TYPE))));
            }
        } else if (this.formatBox.getSelectedItem() == PNM_TYPE) {
            if (!s.endsWith(".pnm")) {
                this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(PNM_TYPE))));
            }
        } else if (this.formatBox.getSelectedItem() == TIFF_TYPE) {
            if (!s.endsWith(".tiff") && !s.endsWith(".tif")) {
                this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(TIFF_TYPE))));
            }
        } else if (this.formatBox.getSelectedItem() == BMP_TYPE && !s.endsWith(".bmp")) {
            this.setSelectedFile(new File(this.addSuffix(filename, this.getTypeSuffix(BMP_TYPE))));
        }
    }

    protected void updateFormatBox(boolean useView) {
        if (useView) {
            this.formatBox.setModel(new DefaultComboBoxModel<String>(VIEW_FILE_TYPES));
        } else {
            this.formatBox.setModel(new DefaultComboBoxModel<String>(SAVE_FILE_TYPES));
        }
    }

    public void save() {
        String location;
        this.updateFormatBox(this.useView.isSelected());
        String initialFilename = this.imageDisplay.getFilename();
        if (initialFilename == null) {
            initialFilename = this.imageDisplay.getObjectName();
        }
        if (initialFilename == null) {
            initialFilename = "unknown";
        }
        if ((location = this.promptUserForSaveLocation(initialFilename)) == null) {
            return;
        }
        String type = (String)this.formatBox.getSelectedItem();
        if (!location.toLowerCase().endsWith(this.getTypeSuffix(type))) {
            location = location + this.getTypeSuffix(type);
        }
        try {
            if (this.useView.isSelected()) {
                if (type == JPEG_TYPE) {
                    this.saveJpegImage(location);
                } else if (type == GIF_TYPE) {
                    this.saveGifImage(location);
                }
            } else {
                this.imageDisplay.saveAs(location);
            }
        }
        catch (Exception ex) {
            DialogUtil.error(_I18N.getString("unableToSaveImage") + ": " + ex.toString());
            ex.printStackTrace();
        }
    }

    protected String addSuffix(String filename, String suffix) {
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(0, i) + suffix;
        }
        return filename + suffix;
    }

    protected void saveGifImage(String filename) throws IOException, OutOfMemoryError {
        Image paintedImage;
        File fd = new File(filename);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fd));
        Image oldImage = paintedImage = this.createOutputImage();
        GreyscaleFilter filter = new GreyscaleFilter();
        Image tempImage = this.createImage(new FilteredImageSource(oldImage.getSource(), filter));
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(tempImage, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            DialogUtil.error(e);
        }
        Image newImage = tempImage;
        GifEncoder encoder = new GifEncoder(newImage, (OutputStream)out);
        encoder.encode();
        ((OutputStream)out).close();
    }

    public void saveJpegImage(String filename) throws IOException, OutOfMemoryError {
        File fd = new File(filename);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fd));
        Image paintedImage = this.createOutputImage();
        try {
            this.getClass();
            Class<?> c = Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
            Method m = c.getMethod("createJPEGEncoder", class$java$io$OutputStream == null ? (class$java$io$OutputStream = ImageSaveDialog.class$("java.io.OutputStream")) : class$java$io$OutputStream);
            Object encoder = m.invoke(null, out);
            Method m2 = c.getMethod("getDefaultJPEGEncodeParam", class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = ImageSaveDialog.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage);
            Object encodeParam = m2.invoke(null, paintedImage);
            Class<?> clazz = encoder.getClass();
            Class[] classArray = new Class[2];
            classArray[0] = class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = ImageSaveDialog.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage;
            this.getClass();
            classArray[1] = Class.forName("com.sun.image.codec.jpeg.JPEGEncodeParam");
            Method em = clazz.getMethod("encode", classArray);
            em.invoke(encoder, paintedImage, encodeParam);
        }
        catch (Exception ex) {
            DialogUtil.error(_I18N.getString("jpegEncodeError") + ": " + ex.toString());
            ((OutputStream)out).close();
            return;
        }
        ((OutputStream)out).close();
    }

    protected String getTypeSuffix(String type) {
        if (type == GIF_TYPE) {
            return ".gif";
        }
        if (type == JPEG_TYPE) {
            return ".jpg";
        }
        if (type == FITS_TYPE) {
            return ".fits";
        }
        if (type == TIFF_TYPE) {
            return ".tif";
        }
        if (type == PNG_TYPE) {
            return ".png";
        }
        if (type == PNM_TYPE) {
            return ".pnm";
        }
        if (type == BMP_TYPE) {
            return ".bmp";
        }
        return null;
    }

    protected Image createOutputImage() {
        Image paintedImage = null;
        JComponent canvas = this.imageDisplay.getCanvas();
        Dimension size = canvas.getSize();
        paintedImage = canvas.createImage((int)size.getWidth(), (int)size.getHeight());
        Graphics2D g = (Graphics2D)paintedImage.getGraphics();
        g.setClip(0, 0, (int)size.getWidth(), (int)size.getHeight());
        this.imageDisplay.paintImageAndGraphics(g);
        return paintedImage;
    }

    protected String promptUserForSaveLocation(String initialFilename) {
        int result;
        this.setDialogTitle(_I18N.getString("saveImageFile"));
        if (initialFilename != null) {
            this.setSelectedFile(new File(initialFilename));
            this.updateFileSuffix();
        }
        if ((result = this.showSaveDialog(this.imageDisplay.getCanvas())) == 0) {
            File file = this.getSelectedFile();
            String location = file.getAbsolutePath();
            String filename = file.getName();
            String type = (String)this.formatBox.getSelectedItem();
            if (!filename.toLowerCase().endsWith(this.getTypeSuffix(type))) {
                String s = this.getTypeSuffix(type);
                location = location + s;
                file = new File(location);
                filename = filename + s;
            }
            if (file.exists()) {
                String origFilename = this.imageDisplay.getFilename();
                if (origFilename != null && file.equals(new File(origFilename))) {
                    return location;
                }
                int ans = DialogUtil.confirm(_I18N.getString("fileOverwriteQuestion", filename));
                if (ans != 0) {
                    return null;
                }
            }
            return location;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

