/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.TableQueryResult;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.gui.CatalogHistoryItem;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.CatalogTree;
import jsky.catalog.gui.TableDisplayTool;
import jsky.catalog.gui.TablePlotter;
import jsky.catalog.skycat.SkycatCatalog;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.catalog.skycat.SkycatTable;
import jsky.image.gui.MainImageDisplay;
import jsky.image.gui.PickObjectStatistics;
import jsky.navigator.NavigatorImageDisplay;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.navigator.NavigatorImageDisplayInternalFrame;
import jsky.navigator.NavigatorQueryTool;
import jsky.util.Logger;
import jsky.util.Preferences;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import jsky.util.gui.SwingUtil;

public class Navigator
extends CatalogNavigator
implements CatalogNavigatorOpener {
    private Component _imageDisplayControlFrame;
    private NavigatorImageDisplay _imageDisplay;
    private AbstractAction _imageDisplayAction = new AbstractAction("Image"){

        public void actionPerformed(ActionEvent evt) {
            Navigator.this.showImageDisplay();
        }
    };
    private static CatalogDirectory _catDir;

    public static CatalogDirectory getCatalogDirectory() {
        if (_catDir == null) {
            String className = System.getProperty("jsky.catalog.directory", "jsky.catalog.astrocat.AstroCatConfig");
            try {
                Class<?> c = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                Object o = c.getMethod("getDirectory", null).invoke(null, null);
                if (!(o instanceof CatalogDirectory)) {
                    throw new RuntimeException("Error: call to " + className + ".getDirectory() returned: " + o);
                }
                _catDir = (CatalogDirectory)o;
                _catDir.setName("My Catalogs");
            }
            catch (InvocationTargetException e1) {
                Throwable t = e1.getTargetException();
                t.printStackTrace();
                throw new RuntimeException("Error calling " + className + ".getDirectory(): " + t);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new RuntimeException("Error calling " + className + ".getDirectory(): " + e2);
            }
        }
        return _catDir;
    }

    public Navigator(Component parent, CatalogTree catalogTree, TablePlotter plotter, MainImageDisplay imageDisplay) {
        super(parent, catalogTree, plotter);
        if (imageDisplay != null) {
            this._imageDisplay = (NavigatorImageDisplay)imageDisplay;
            this._imageDisplayControlFrame = imageDisplay.getRootComponent();
            this.initSymbolPlotter();
        }
    }

    public Navigator(Component parent, CatalogTree catalogTree, TablePlotter plotter) {
        this(parent, catalogTree, plotter, null);
    }

    public MainImageDisplay getImageDisplay() {
        return this._imageDisplay;
    }

    public Action getImageDisplayAction() {
        return this._imageDisplayAction;
    }

    protected CatalogQueryTool makeCatalogQueryTool(Catalog catalog) {
        return new NavigatorQueryTool(catalog, this, this._imageDisplay);
    }

    protected void makeImageDisplayControlFrame() {
        Component parent = this.getParentFrame();
        if (parent instanceof JFrame) {
            this._imageDisplayControlFrame = new NavigatorImageDisplayFrame();
            this._imageDisplayControlFrame.setVisible(true);
            this._imageDisplay = (NavigatorImageDisplay)((NavigatorImageDisplayFrame)this._imageDisplayControlFrame).getImageDisplayControl().getImageDisplay();
        } else if (parent instanceof JInternalFrame) {
            JDesktopPane desktop = this.getDesktop();
            this._imageDisplayControlFrame = new NavigatorImageDisplayInternalFrame(desktop);
            this._imageDisplayControlFrame.setVisible(true);
            this._imageDisplay = (NavigatorImageDisplay)((NavigatorImageDisplayInternalFrame)this._imageDisplayControlFrame).getImageDisplayControl().getImageDisplay();
            desktop.add(this._imageDisplayControlFrame, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(this._imageDisplayControlFrame);
        }
        this._imageDisplay.setNavigator(this);
    }

    protected void loadImage(String filename, URL url) {
        this.showImageDisplay();
        this._imageDisplay.setFilename(filename, url);
    }

    public void showImageDisplay() {
        if (this._imageDisplay == null) {
            this.makeImageDisplayControlFrame();
            this.notifyNewImageDisplay();
            this.initSymbolPlotter();
        } else {
            SwingUtil.showFrame(this._imageDisplayControlFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(URL url, String contentType) throws IOException {
        if (url.getProtocol().equals("file")) {
            SwingUtilities.invokeLater(new NavigatorImageLoader(url.getPath(), url));
        } else {
            String dir = Preferences.getPreferences().getCacheDir().getPath();
            String suffix = contentType.endsWith("hfits") ? ".hfits" : (contentType.endsWith("zfits") || contentType.equals("image/x-fits") ? ".fits.gz" : (contentType.endsWith("fits") ? ".fits" : ".tmp"));
            File file = File.createTempFile("jsky", suffix, new File(dir));
            ProgressPanel progressPanel = this.getProgressPanel();
            ProgressBarFilterInputStream in = progressPanel.getLoggedInputStream(url);
            FileOutputStream out = new FileOutputStream(file);
            ProgressBarFilterInputStream progressBarFilterInputStream = in;
            synchronized (progressBarFilterInputStream) {
                FileOutputStream fileOutputStream = out;
                synchronized (fileOutputStream) {
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        if (progressPanel.isInterrupted()) {
                            throw new ProgressException("Interrupted");
                        }
                        out.write(buffer, 0, bytesRead);
                    }
                }
            }
            in.close();
            out.flush();
            out.close();
            if (!progressPanel.isInterrupted()) {
                SwingUtilities.invokeLater(new NavigatorImageLoader(file.toString(), url));
            }
        }
    }

    protected void notifyNewImageDisplay() {
        this.notifyNewImageDisplay(this.getBackStack());
        this.notifyNewImageDisplay(this.getForwStack());
        JComponent queryComponent = this.getQueryComponent();
        if (queryComponent instanceof NavigatorQueryTool) {
            ((NavigatorQueryTool)queryComponent).setImageDisplay(this._imageDisplay);
        }
    }

    protected void notifyNewImageDisplay(Stack stack) {
        int n = stack.size();
        for (int i = 0; i < n; ++i) {
            JComponent comp = (JComponent)stack.get(i);
            if (!(comp instanceof NavigatorQueryTool)) continue;
            ((NavigatorQueryTool)comp).setImageDisplay(this._imageDisplay);
        }
    }

    protected void initSymbolPlotter() {
        TablePlotter plotter = this.getPlotter();
        if (plotter != null) {
            plotter.setCanvasGraphics(this._imageDisplay.getCanvasGraphics());
            plotter.setCoordinateConverter(this._imageDisplay.getCoordinateConverter());
            this._imageDisplay.getNavigatorPane().setPlotter(plotter);
        }
    }

    protected JComponent makeURLComponent(URL url, String contentType) throws IOException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(this, "Display URL: ContentType=" + contentType + ", URL=" + url);
        }
        if (contentType.equals("text/html")) {
            return super.makeURLComponent(url, contentType);
        }
        String filename = url.getFile();
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            if (filename.endsWith(".cfg")) {
                String basename = new File(filename).getName();
                SkycatConfigFile cf = new SkycatConfigFile(basename, url);
                cf.setHTMLQueryResultHandler(this);
                return this.makeCatalogDirectoryComponent(cf);
            }
            if (filename.endsWith(".table") || filename.endsWith(".scat") || filename.endsWith(".cat")) {
                SkycatTable table = new SkycatTable(filename);
                return this.makeCatalogComponent(table.getCatalog());
            }
        }
        if (protocol.equals("file") || protocol.equals("xml") && filename.endsWith(".xml")) {
            String basename = new File(filename).getName();
            AstroCatConfig cf = new AstroCatConfig(basename, url);
            cf.setHTMLQueryResultHandler(this);
            return this.makeCatalogDirectoryComponent(cf);
        }
        if (contentType.equals("text/plain")) {
            return super.makeURLComponent(url, contentType);
        }
        this.loadImage(url, contentType);
        return this.getResultComponent();
    }

    public void openCatalogWindow() {
    }

    public void openCatalogWindow(Catalog cat) {
        if (cat != null) {
            this.setQueryResult(cat);
        }
    }

    public void openCatalogWindow(String name) {
        Catalog cat = Navigator.getCatalogDirectory().getCatalog(name);
        if (cat != null) {
            this.openCatalogWindow(cat);
        }
    }

    public void openLocalCatalog() {
        this.open();
    }

    public void saveWithImage() {
        JComponent resultComponent = this.getResultComponent();
        if (!(resultComponent instanceof TableDisplayTool)) {
            DialogUtil.error("This operation is only supported for tables");
        } else if (this._imageDisplay == null) {
            DialogUtil.error("No current FITS image.");
        } else {
            TableQueryResult table = ((TableDisplayTool)resultComponent).getTable();
            this._imageDisplay.saveFITSTable(table);
        }
    }

    protected void cleanupHistoryList() {
        ListIterator it = this.getHistoryList().listIterator(0);
        while (it.hasNext()) {
            CatalogHistoryItem item = (CatalogHistoryItem)it.next();
            if (item.getURLStr() != null || _catDir.getCatalog(item.getName()) != null) continue;
            it.remove();
        }
    }

    public JFileChooser makeFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        ExampleFileFilter configFileFilter = new ExampleFileFilter(new String[]{"cfg"}, "Catalog config Files (Skycat style)");
        fileChooser.addChoosableFileFilter(configFileFilter);
        ExampleFileFilter fitsFilter = new ExampleFileFilter(new String[]{"fit", "fits", "fts"}, "FITS File with Table Extensions");
        fileChooser.addChoosableFileFilter(fitsFilter);
        ExampleFileFilter skycatLocalCatalogFilter = new ExampleFileFilter(new String[]{"table", "scat", "cat"}, "Local catalog Files (Skycat style)");
        fileChooser.addChoosableFileFilter(skycatLocalCatalogFilter);
        ExampleFileFilter htmlFilter = new ExampleFileFilter(new String[]{"html", "htm"}, "HTML File");
        fileChooser.addChoosableFileFilter(htmlFilter);
        fileChooser.setFileFilter(skycatLocalCatalogFilter);
        return fileChooser;
    }

    public void addPickedObjectToTable(PickObjectStatistics stats, boolean isUpdate) {
        TableQueryResult table = null;
        TableDisplayTool tableDisplayTool = null;
        JComponent resultComponent = this.getResultComponent();
        if (resultComponent instanceof TableDisplayTool) {
            tableDisplayTool = (TableDisplayTool)resultComponent;
            table = tableDisplayTool.getTableDisplay().getTableQueryResult();
        }
        if (table == null) {
            table = this.makePickObjectTable(stats);
            SkycatCatalog cat = new SkycatCatalog((SkycatTable)table);
            this.setQueryResult(cat);
            JComponent queryComponent = this.getQueryComponent();
            if (queryComponent instanceof CatalogQueryTool) {
                ((CatalogQueryTool)queryComponent).search();
            }
            this.getParentFrame().setVisible(true);
        } else {
            this.addRowForPickedObject(table, tableDisplayTool, stats, isUpdate);
        }
    }

    protected TableQueryResult makePickObjectTable(PickObjectStatistics stats) {
        Properties properties = new Properties();
        properties.setProperty("serv_type", "local");
        properties.setProperty("long_name", "Picked Objects");
        properties.setProperty("short_name", "PickedObjects");
        properties.setProperty("symbol", "{{FWHM_X} {FWHM_Y} {Angle}} {{plus} {green} {$FWHM_X/$FWHM_Y} {$Angle} {} {1}} {{($FWHM_X+$FWHM_Y)*0.5} {image}}");
        properties.setProperty("url", "none");
        SkycatConfigEntry configEntry = new SkycatConfigEntry(properties);
        FieldDesc[] fields = PickObjectStatistics.getFields();
        Vector<Vector> dataRows = new Vector<Vector>();
        dataRows.add(stats.getRow());
        SkycatTable table = new SkycatTable(configEntry, dataRows, fields);
        table.setProperties(properties);
        return table;
    }

    protected void addRowForPickedObject(TableQueryResult table, TableDisplayTool tableDisplayTool, PickObjectStatistics stats, boolean isUpdate) {
        if (!table.hasCoordinates()) {
            DialogUtil.error("The current table does not support coordinates");
            return;
        }
        int numCols = table.getColumnCount();
        Vector v = stats.getRow();
        Vector rowVec = new Vector(numCols);
        for (int col = 0; col < numCols; ++col) {
            FieldDesc field = table.getColumnDesc(col);
            String name = field.getName();
            if (field.isId()) {
                rowVec.add(v.get(0));
                continue;
            }
            if (field.isRA()) {
                rowVec.add(stats.getCenterPos().getRA().toString());
                continue;
            }
            if (field.isDec()) {
                rowVec.add(stats.getCenterPos().getDec().toString());
                continue;
            }
            Object o = null;
            int i = 0;
            while (true) {
                if (i >= PickObjectStatistics.NUM_FIELDS) break;
                if (name.equals(PickObjectStatistics.FIELD_NAMES[i])) {
                    o = v.get(i);
                    break;
                }
                ++i;
            }
            rowVec.add(o);
        }
        if (isUpdate) {
            int rowIndex = tableDisplayTool.getRowCount() - 1;
            if (rowIndex >= 0) {
                tableDisplayTool.updateRow(rowIndex, rowVec);
            } else {
                tableDisplayTool.addRow(rowVec);
            }
        } else {
            tableDisplayTool.addRow(rowVec);
        }
        tableDisplayTool.replot();
    }

    protected class NavigatorImageLoader
    implements Runnable {
        String filename;
        URL url;

        public NavigatorImageLoader(String filename, URL url) {
            this.filename = filename;
            this.url = url;
        }

        public void run() {
            Navigator.this.loadImage(this.filename, this.url);
        }
    }
}

