/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.navigator.Navigator;
import jsky.util.I18N;
import jsky.util.ProxyServerUtil;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProxyServerDialog;

public class NavigatorCatalogMenu
extends JMenu
implements TreeModelListener {
    private static final I18N _I18N = I18N.getInstance(class$jsky$navigator$NavigatorCatalogMenu == null ? (class$jsky$navigator$NavigatorCatalogMenu = NavigatorCatalogMenu.class$("jsky.navigator.NavigatorCatalogMenu")) : class$jsky$navigator$NavigatorCatalogMenu);
    private CatalogNavigatorOpener _opener;
    private boolean _isInCatalogWindow = false;
    private JMenu _catalogMenu;
    private JMenu _archiveMenu;
    private JMenu _imageServerMenu;
    private JMenu _localCatalogMenu;
    private JMenuItem _browseMenuItem;
    private JMenuItem _proxyMenuItem;
    private ProxyServerDialog _proxyDialog;
    static /* synthetic */ Class class$jsky$navigator$NavigatorCatalogMenu;

    public NavigatorCatalogMenu(CatalogNavigatorOpener opener, boolean addBrowseItem) {
        super(_I18N.getString("catalog"));
        this._opener = opener;
        this._isInCatalogWindow = !addBrowseItem;
        this.addMenuItems();
    }

    public void addMenuItems() {
        CatalogDirectory dir = null;
        try {
            dir = Navigator.getCatalogDirectory();
        }
        catch (Exception e) {
            DialogUtil.error(e);
            return;
        }
        dir.removeTreeModelListener(this);
        dir.addTreeModelListener(this);
        this._catalogMenu = this._createCatalogSubMenu(this, this._catalogMenu, true, dir, "catalog", _I18N.getString("catalogs"));
        this._archiveMenu = this._createCatalogSubMenu(this, this._archiveMenu, true, dir, "archive", _I18N.getString("archives"));
        this._imageServerMenu = this._createCatalogSubMenu(this, this._imageServerMenu, true, dir, "imagesvr", _I18N.getString("imageServers"));
        this._localCatalogMenu = this._createCatalogSubMenu(this, this._localCatalogMenu, true, dir, "local", _I18N.getString("localCats"));
        this._localCatalogMenu.addSeparator();
        this._localCatalogMenu.add(this._createCatalogLocalOpenMenuItem());
        if (!this._isInCatalogWindow && this._browseMenuItem == null) {
            this.addSeparator();
            this._browseMenuItem = this._createCatalogBrowseMenuItem();
            this.add(this._browseMenuItem);
        }
        if (this._proxyMenuItem == null) {
            this.addSeparator();
            this._proxyMenuItem = this._createProxySettingsMenuItem();
            this.add(this._proxyMenuItem);
        }
    }

    private JMenu _createCatalogSubMenu(JMenu parentMenu, JMenu oldMenu, boolean clearMenu, CatalogDirectory dir, String servType, String label) {
        JMenu menu = oldMenu;
        if (menu == null) {
            menu = new JMenu(label);
            parentMenu.add(menu);
        } else if (clearMenu) {
            menu.removeAll();
        }
        if (dir == null) {
            System.out.println("XXX null config file");
            return menu;
        }
        int n = dir.getNumCatalogs();
        for (int i = 0; i < n; ++i) {
            Catalog cat = dir.getCatalog(i);
            if (!cat.getType().equals(servType)) continue;
            menu.add(this._createCatalogMenuItem(cat));
        }
        return menu;
    }

    private JMenuItem _createCatalogMenuItem(final Catalog cat) {
        JMenuItem menuItem = new JMenuItem(cat.getName());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NavigatorCatalogMenu.this._opener.openCatalogWindow(cat);
            }
        });
        return menuItem;
    }

    private JMenuItem _createCatalogLocalOpenMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("open") + "...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NavigatorCatalogMenu.this._opener.openLocalCatalog();
            }
        });
        return menuItem;
    }

    private JMenuItem _createCatalogBrowseMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("browse") + "...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NavigatorCatalogMenu.this._opener.openCatalogWindow();
            }
        });
        return menuItem;
    }

    private JMenuItem _createProxySettingsMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("proxySettings"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (NavigatorCatalogMenu.this._proxyDialog == null) {
                    NavigatorCatalogMenu.this._proxyDialog = new ProxyServerDialog();
                }
                NavigatorCatalogMenu.this._proxyDialog.setVisible(true);
            }
        });
        return menuItem;
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.addMenuItems();
    }

    public void treeNodesInserted(TreeModelEvent e) {
        this.addMenuItems();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this.addMenuItems();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.addMenuItems();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ProxyServerUtil.init();
    }
}

