/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.gui.BasicTablePlotter;
import jsky.catalog.gui.CatalogTree;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorMenuBar;
import jsky.navigator.NavigatorToolBar;
import jsky.util.Preferences;
import jsky.util.gui.LookAndFeelMenu;

public class NavigatorFrame
extends JFrame {
    protected Navigator navigator;
    private boolean firstTime = true;

    public NavigatorFrame(CatalogDirectory catDir, MainImageDisplay imageDisplay) {
        super("Catalog Navigator");
        CatalogTree catalogTree = new CatalogTree(catDir);
        BasicTablePlotter plotter = new BasicTablePlotter();
        this.navigator = new Navigator(this, catalogTree, plotter, imageDisplay);
        catalogTree.setQueryResult(catDir);
        NavigatorToolBar toolbar = new NavigatorToolBar(this.navigator);
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.navigator, "Center");
        this.setJMenuBar(new NavigatorMenuBar(this.navigator, toolbar));
        Preferences.manageLocation(this);
        Preferences.manageSize(this.navigator, new Dimension(650, 550));
        this.setDefaultCloseOperation(1);
        LookAndFeelMenu.addWindow(this);
    }

    public NavigatorFrame(CatalogDirectory catDir) {
        this(catDir, null);
    }

    public NavigatorFrame() {
        this(Navigator.getCatalogDirectory());
    }

    public NavigatorFrame(MainImageDisplay imageDisplay) {
        this(Navigator.getCatalogDirectory(), imageDisplay);
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    public void setVisible(boolean b) {
        if (b && this.firstTime) {
            this.firstTime = false;
            this.pack();
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        NavigatorFrame f = new NavigatorFrame();
        f.setVisible(true);
    }
}

