/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.gui.BasicTablePlotter;
import jsky.catalog.gui.CatalogTree;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorMenuBar;
import jsky.navigator.NavigatorToolBar;
import jsky.util.Preferences;
import jsky.util.gui.LookAndFeelMenu;

public class NavigatorInternalFrame
extends JInternalFrame {
    protected Navigator navigator;
    private static int openFrameCount = 0;
    private static final int xOffset = 30;
    private static final int yOffset = 30;
    private boolean firstTime = true;

    public NavigatorInternalFrame(JDesktopPane desktop, CatalogDirectory catDir, MainImageDisplay imageDisplay) {
        super("Catalog Navigator", true, false, true, true);
        CatalogTree catalogTree = new CatalogTree(catDir);
        BasicTablePlotter plotter = new BasicTablePlotter();
        this.navigator = new Navigator(this, catalogTree, plotter, imageDisplay);
        this.navigator.setDesktop(desktop);
        catalogTree.setQueryResult(catDir);
        NavigatorToolBar toolbar = new NavigatorToolBar(this.navigator);
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.navigator, "Center");
        this.setJMenuBar(new NavigatorMenuBar(this.navigator, toolbar));
        Preferences.manageLocation(this, 30 * openFrameCount, 30 * openFrameCount);
        Preferences.manageSize(this.navigator, new Dimension(650, 550));
        ++openFrameCount;
        this.setClosable(true);
        this.setMaximizable(true);
        this.setDefaultCloseOperation(1);
        LookAndFeelMenu.addWindow(this);
    }

    public NavigatorInternalFrame(JDesktopPane desktop, CatalogDirectory catDir) {
        this(desktop, catDir, null);
    }

    public NavigatorInternalFrame(JDesktopPane desktop) {
        this(desktop, Navigator.getCatalogDirectory());
    }

    public NavigatorInternalFrame(JDesktopPane desktop, MainImageDisplay imageDisplay) {
        this(desktop, Navigator.getCatalogDirectory(), imageDisplay);
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    public void setVisible(boolean b) {
        if (b && this.firstTime) {
            this.firstTime = false;
            this.pack();
            this.revalidate();
        }
        super.setVisible(b);
    }
}

