/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.catalog.Catalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.gui.CatalogQueryPanel;
import jsky.catalog.gui.CatalogQueryTool;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.coords.CoordinateConverter;
import jsky.coords.CoordinateRadius;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.graphics.SelectedAreaListener;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.Navigator;
import jsky.util.gui.DialogUtil;

public class NavigatorQueryTool
extends CatalogQueryTool
implements SelectedAreaListener {
    private MainImageDisplay _imageDisplay;
    private JButton _selectAreaButton;
    private JButton _setFromImageButton;
    private Rectangle2D _selectedArea;

    public NavigatorQueryTool(Catalog catalog, QueryResultDisplay queryResultDisplay, MainImageDisplay imageDisplay) {
        super(catalog, queryResultDisplay);
        this.setImageDisplay(imageDisplay);
        this.getCatalogQueryPanel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String s = NavigatorQueryTool.this.getCatalogQueryPanel().getLabelForComponent(cb);
                if (s == null) {
                    return;
                }
                if (s.equalsIgnoreCase("equinox")) {
                    if (NavigatorQueryTool.this._selectedArea != null) {
                        NavigatorQueryTool.this.setSelectedArea(NavigatorQueryTool.this._selectedArea);
                    } else {
                        NavigatorQueryTool.this.setFromImage(false);
                    }
                }
            }
        });
    }

    public NavigatorQueryTool(Catalog catalog, QueryResultDisplay queryResultDisplay) {
        this(catalog, queryResultDisplay, null);
        if (queryResultDisplay instanceof Navigator) {
            Navigator navigator = (Navigator)queryResultDisplay;
            this.setImageDisplay(navigator.getImageDisplay());
        }
    }

    public MainImageDisplay getImageDisplay() {
        return this._imageDisplay;
    }

    public void setImageDisplay(MainImageDisplay im) {
        this._imageDisplay = im;
        this.updateImageButtonStates();
        Catalog catalog = this.getCatalog();
        this.setFromImage(catalog != null && catalog.isImageServer());
    }

    protected void updateImageButtonStates() {
        boolean b = this._imageDisplay != null;
        this._selectAreaButton.setEnabled(b);
        this._setFromImageButton.setEnabled(b);
    }

    public JPanel makeButtonPanel() {
        JPanel buttonPanel = super.makeButtonPanel();
        this._selectAreaButton = new JButton("Select Area...");
        this._selectAreaButton.setToolTipText("Drag out an area of the image to use for the query");
        this._selectAreaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorQueryTool.this.selectArea();
            }
        });
        buttonPanel.add(this._selectAreaButton);
        this._setFromImageButton = new JButton("Set From Image");
        this._setFromImageButton.setToolTipText("Set the query parameters from the currently displayed image");
        this._setFromImageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorQueryTool.this.setFromImage(false);
            }
        });
        buttonPanel.add(this._setFromImageButton);
        return buttonPanel;
    }

    protected void selectArea() {
        if (this._imageDisplay == null) {
            DialogUtil.error("There is no image display associated with this window.");
            return;
        }
        DialogUtil.message("Please drag out an area of the image with the left mouse button.");
        this._imageDisplay.getCanvasGraphics().selectArea(this);
    }

    public void setSelectedArea(Rectangle2D r) {
        this._selectedArea = r;
        if (this._imageDisplay == null || r == null) {
            return;
        }
        CoordinateConverter wcs = this._imageDisplay.getCoordinateConverter();
        if (!wcs.isWCS()) {
            return;
        }
        Point2D.Double center = new Point2D.Double(r.getX() + r.getWidth() / 2.0, r.getY() + r.getHeight() / 2.0);
        wcs.screenToWorldCoords(center, false);
        double equinox = wcs.getEquinox();
        WorldCoords centerPos = new WorldCoords(center, equinox);
        Point2D.Double p = new Point2D.Double(r.getX(), r.getY());
        wcs.screenToWorldCoords(p, false);
        WorldCoords origin = new WorldCoords(p, equinox);
        double radius = centerPos.dist(origin);
        Point2D.Double dims = new Point2D.Double(r.getWidth(), r.getHeight());
        wcs.screenToWorldCoords(dims, true);
        double width = dims.x * 60.0;
        double height = dims.y * 60.0;
        CatalogQueryPanel catalogQueryPanel = this.getCatalogQueryPanel();
        QueryArgs queryArgs = catalogQueryPanel.getQueryArgs();
        this.getCatalog().setRegionArgs(queryArgs, new CoordinateRadius(centerPos, radius, width, height));
        catalogQueryPanel.setQueryArgs(queryArgs);
    }

    protected void setFromImage(boolean useDefaultSize) {
        double radius;
        double height;
        double width;
        this._selectedArea = null;
        if (this._imageDisplay == null) {
            return;
        }
        WorldCoordinateConverter wcs = this._imageDisplay.getWCS();
        if (wcs == null) {
            return;
        }
        WorldCoords centerPos = this._imageDisplay.getBasePos();
        Point2D.Double p1 = new Point2D.Double(1.0, 1.0);
        wcs.imageToWorldCoords(p1, false);
        double equinox = wcs.getEquinox();
        WorldCoords origin = new WorldCoords(p1, equinox);
        if (useDefaultSize) {
            width = 15.0;
            height = 15.0;
            radius = Math.sqrt(450.0) / 2.0;
        } else {
            radius = centerPos.dist(origin);
            width = wcs.getWidthInDeg() * 60.0;
            height = wcs.getHeightInDeg() * 60.0;
        }
        CatalogQueryPanel catalogQueryPanel = this.getCatalogQueryPanel();
        QueryArgs queryArgs = catalogQueryPanel.getQueryArgs();
        try {
            this.getCatalog().setRegionArgs(queryArgs, new CoordinateRadius(centerPos, radius, width, height));
            catalogQueryPanel.setQueryArgs(queryArgs);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

